/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.RequestPacketElement;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;

public class CallStackDescriptor
implements RequestPacketElement,
DebugConstants {
    private String m_viewId;
    private String m_pgmLib;
    private String m_pgmName;
    private int m_pgmType;
    private String m_moduleName;
    private String m_procedure;
    private int m_lineNum;
    private int m_statement;
    private String m_address;

    public String getViewId() {
        return this.m_viewId;
    }

    public String getPgmLibrary() {
        return this.m_pgmLib;
    }

    public String getPgmName() {
        return this.m_pgmName;
    }

    public int getPgmType() {
        return this.m_pgmType;
    }

    public String getModuleName() {
        return this.m_moduleName;
    }

    public String getProcedure() {
        return this.m_procedure;
    }

    public int getLineNum() {
        return this.m_lineNum;
    }

    public int getStatement() {
        return this.m_statement;
    }

    public void setAddress(MemoryAddress memoryAddress) {
        this.m_address = memoryAddress != null ? memoryAddress.toString() : null;
    }

    public void setAddress(String string) {
        this.m_address = string;
    }

    public String getAddress() {
        return this.m_address;
    }

    public void read(CommLink commLink) throws IOException {
        this.m_viewId = commLink.readString();
        this.m_pgmLib = commLink.readString();
        this.m_pgmName = commLink.readString();
        this.m_pgmType = commLink.readInt();
        this.m_moduleName = commLink.readString();
        this.m_procedure = commLink.readString();
        this.m_lineNum = commLink.readInt();
        this.m_statement = commLink.readInt();
        switch (this.m_pgmType) {
            case 0: 
            case 1: {
                this.m_pgmLib = Util.firstUpper(this.m_pgmLib);
                this.m_pgmName = Util.firstUpper(this.m_pgmName);
                this.m_moduleName = Util.firstUpper(this.m_moduleName);
                break;
            }
            case 2: {
                this.m_moduleName = "";
                break;
            }
        }
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_viewId);
        n += commLink.writeSize(this.m_pgmLib);
        n += commLink.writeSize(this.m_pgmName);
        n += 4;
        n += commLink.writeSize(this.m_moduleName);
        n += commLink.writeSize(this.m_procedure);
        n += 4;
        return n += 4;
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeString(this.m_viewId);
        commLink.writeString(this.m_pgmLib);
        commLink.writeString(this.m_pgmName);
        commLink.writeInt(this.m_pgmType);
        commLink.writeString(this.m_moduleName);
        commLink.writeString(this.m_procedure);
        commLink.writeInt(this.m_lineNum);
        commLink.writeInt(this.m_statement);
    }
}

