/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PxBooleanParm;
import com.ibm.as400.access.PxByteParm;
import com.ibm.as400.access.PxCharParm;
import com.ibm.as400.access.PxClassParm;
import com.ibm.as400.access.PxConstructorReqSV;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxDoubleParm;
import com.ibm.as400.access.PxFinalizeReqSV;
import com.ibm.as400.access.PxFloatParm;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxListenerReqSV;
import com.ibm.as400.access.PxLongParm;
import com.ibm.as400.access.PxMethodReqSV;
import com.ibm.as400.access.PxNullParm;
import com.ibm.as400.access.PxPxObjectParm;
import com.ibm.as400.access.PxRepSV;
import com.ibm.as400.access.PxReqSV;
import com.ibm.as400.access.PxSerializedObjectParm;
import com.ibm.as400.access.PxShortParm;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.PxTable;
import com.ibm.as400.access.PxToolboxObjectParm;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;

class PSConnection
extends StoppableThread {
    private boolean closed_ = false;
    private long connectionId_;
    private PxDSFactory factory_;
    private InputStream input_;
    private PSLoad load_;
    private OutputStream output_;
    private Socket socket_;
    private PrintWriter trace_;
    private PxTable proxyTable_;

    public PSConnection(long l, Socket socket, InputStream inputStream, OutputStream outputStream, PSLoad pSLoad) {
        super("PSConnection-" + l);
        this.connectionId_ = l;
        this.socket_ = socket;
        this.input_ = inputStream;
        this.load_ = pSLoad;
        this.output_ = outputStream;
        this.proxyTable_ = new PxTable();
        this.factory_ = new PxDSFactory();
        this.factory_.register(new PxByteParm());
        this.factory_.register(new PxShortParm());
        this.factory_.register(new PxIntParm());
        this.factory_.register(new PxLongParm());
        this.factory_.register(new PxFloatParm());
        this.factory_.register(new PxDoubleParm());
        this.factory_.register(new PxBooleanParm());
        this.factory_.register(new PxCharParm());
        this.factory_.register(new PxStringParm());
        this.factory_.register(new PxSerializedObjectParm());
        this.factory_.register(new PxPxObjectParm(this.proxyTable_));
        this.factory_.register(new PxToolboxObjectParm());
        this.factory_.register(new PxNullParm());
        this.factory_.register(new PxClassParm());
        this.factory_.register(new PxConstructorReqSV(this.proxyTable_));
        this.factory_.register(new PxMethodReqSV(this.proxyTable_));
        this.factory_.register(new PxFinalizeReqSV(this.proxyTable_));
        this.factory_.register(new PxListenerReqSV(this, this.proxyTable_));
        if (Trace.isTraceProxyOn()) {
            this.trace_ = Trace.getPrintWriter();
            Trace.log(6, "Px server connection " + this + " opened.");
        }
    }

    public void close() {
        block13: {
            block12: {
                block11: {
                    super.stopSafely();
                    this.closed_ = true;
                    if (Trace.isTraceProxyOn()) {
                        Trace.log(6, "Px server connection " + this + " closed.");
                    }
                    try {
                        if (this.output_ != null) {
                            this.output_.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Trace.isTraceErrorOn()) break block11;
                        Trace.log(2, "Exception closing proxy output stream.", (Throwable)iOException);
                    }
                }
                try {
                    if (this.input_ != null) {
                        this.input_.close();
                    }
                }
                catch (IOException iOException) {
                    if (!Trace.isTraceErrorOn()) break block12;
                    Trace.log(2, "Exception closing proxy input stream.", (Throwable)iOException);
                }
            }
            try {
                if (this.socket_ != null) {
                    this.socket_.close();
                }
            }
            catch (IOException iOException) {
                if (!Trace.isTraceErrorOn()) break block13;
                Trace.log(2, "Exception closing proxy socket.", (Throwable)iOException);
            }
        }
        if (this.proxyTable_ != null) {
            this.proxyTable_.removeAll();
            this.proxyTable_ = null;
        }
        this.factory_ = null;
        this.load_.connectionClosed();
        Verbose.println(ResourceBundleLoader.getText("PROXY_CONNECTION_CLOSED", Long.toString(this.connectionId_)));
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.close();
        }
        super.finalize();
    }

    private void handleIOException(IOException iOException) {
        if (Trace.isTraceErrorOn() && (!(iOException instanceof SocketException) && !(iOException instanceof EOFException) || iOException.getMessage() != null && iOException.getMessage().indexOf("JVM_recv") < 0)) {
            Trace.log(2, "IOException in PSConnection", (Throwable)iOException);
        }
        if (!this.closed_) {
            this.close();
        }
    }

    private void processReq(PxReqSV pxReqSV) {
        PxRepSV pxRepSV = pxReqSV.process();
        if (pxRepSV != null) {
            pxRepSV.setCorrelationId(pxReqSV.getCorrelationId());
            this.send(pxRepSV);
        }
    }

    public void run() {
        this.load_.connectionOpened();
        try {
            while (this.canContinue()) {
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, this, "calling factory_.getNextDS");
                }
                PxReqSV pxReqSV = (PxReqSV)this.factory_.getNextDS(this.input_);
                if (Trace.isTraceProxyOn()) {
                    this.trace_.print(this.getName() + " - ");
                    pxReqSV.dump(this.trace_);
                }
                if (pxReqSV.isAsynchronous()) {
                    final PxReqSV pxReqSV2 = pxReqSV;
                    new Thread(){

                        public void run() {
                            PSConnection.this.processReq(pxReqSV2);
                        }
                    }.start();
                    continue;
                }
                this.processReq(pxReqSV);
            }
        }
        catch (IOException iOException) {
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Exited run loop because of exception", (Throwable)iOException);
            }
            this.handleIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(PxRepSV pxRepSV) {
        block6: {
            try {
                if (pxRepSV == null) break block6;
                OutputStream outputStream = this.output_;
                synchronized (outputStream) {
                    if (Trace.isTraceProxyOn()) {
                        this.trace_.print(this.getName() + " - ");
                        pxRepSV.dump(this.trace_);
                    }
                    pxRepSV.writeTo(this.output_);
                    this.output_.flush();
                }
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
        }
    }

    public void stopSafely() {
        this.close();
    }
}

