/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPoolAuthentication;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionPoolEvent;
import com.ibm.as400.access.ConnectionPoolEventSupport;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ConnectionPoolProperties;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Log;
import com.ibm.as400.access.PoolItem;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SecureAS400;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

final class ConnectionList {
    private static final String NOT_EXPIRED = null;
    private static final String EXPIRED_INACTIVE = "CL_REMUNUSED";
    private static final String EXPIRED_MAX_LIFETIME = "CL_REMLIFE";
    private static final String EXPIRED_MAX_USE_COUNT = "CL_REMUSECOUNT";
    private static final String EXPIRED_MAX_USE_TIME = "CL_REMUSETIME";
    private static final String EXPIRED_FAILED_PRETEST = "CL_REMPRETEST";
    private String systemName_;
    private String userID_;
    private ConnectionPoolProperties properties_;
    private Log log_;
    private Vector connectionList_ = new Vector();

    ConnectionList(String string, String string2, ConnectionPoolProperties connectionPoolProperties) {
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("systemName", 1);
        }
        if (string2 == null) {
            throw new NullPointerException("userID");
        }
        if (string2.length() == 0) {
            throw new ExtendedIllegalArgumentException("userID", 1);
        }
        if (connectionPoolProperties == null) {
            throw new NullPointerException("properties");
        }
        this.systemName_ = string;
        this.userID_ = string2;
        this.properties_ = connectionPoolProperties;
    }

    private String checkConnectionExpiration(PoolItem poolItem) {
        if (this.properties_.getMaxInactivity() >= 0L && poolItem.getInactivityTime() >= this.properties_.getMaxInactivity()) {
            return EXPIRED_INACTIVE;
        }
        if (this.properties_.getMaxUseCount() >= 0 && poolItem.getUseCount() >= this.properties_.getMaxUseCount()) {
            return EXPIRED_MAX_USE_COUNT;
        }
        if (this.properties_.getMaxLifetime() >= 0L && poolItem.getLifeSpan() >= this.properties_.getMaxLifetime()) {
            return EXPIRED_MAX_LIFETIME;
        }
        if (this.properties_.getMaxUseTime() >= 0L && poolItem.getInUseTime() >= this.properties_.getMaxUseTime()) {
            return EXPIRED_MAX_USE_TIME;
        }
        return NOT_EXPIRED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_CLEANUP", new String[]{this.systemName_, this.userID_}));
        }
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = 0; i < n; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                poolItem.getAS400Object().disconnectAllServices();
            }
            this.connectionList_.removeAllElements();
        }
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_CLEANUPCOMP"));
        }
    }

    private PoolItem createNewConnection(int n, boolean bl, boolean bl2, ConnectionPoolEventSupport connectionPoolEventSupport, Locale locale, AS400ConnectionPoolAuthentication aS400ConnectionPoolAuthentication, SocketProperties socketProperties, int n2) throws AS400SecurityException, IOException, ConnectionPoolException {
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_CREATING", new String[]{this.systemName_, this.userID_}));
        }
        if (this.properties_.getMaxConnections() > 0 && this.getConnectionCount() >= this.properties_.getMaxConnections()) {
            if (this.log_ != null || Trace.traceOn_) {
                this.log(ResourceBundleLoader.getText("CL_CLEANUPEXP"));
            }
            this.removeExpiredConnections(connectionPoolEventSupport);
            if (this.getConnectionCount() >= this.properties_.getMaxConnections()) {
                if (this.log_ != null || Trace.traceOn_) {
                    this.log(ResourceBundleLoader.getText("CL_CLEANUPOLD"));
                }
                this.shutDownOldest();
                if (this.getConnectionCount() >= this.properties_.getMaxConnections()) {
                    throw new ConnectionPoolException(1);
                }
            }
        }
        boolean bl3 = this.properties_.isThreadUsed();
        PoolItem poolItem = new PoolItem(this.systemName_, this.userID_, aS400ConnectionPoolAuthentication, bl2, locale, n, bl, bl3, socketProperties, n2);
        poolItem.setInUse(true);
        this.connectionList_.addElement(poolItem);
        if (connectionPoolEventSupport != null) {
            ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 1);
            connectionPoolEventSupport.fireConnectionCreatedEvent(connectionPoolEvent);
        }
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_CREATED", new String[]{this.systemName_, this.userID_}));
        }
        return poolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolItem findElement(AS400 aS400) {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = 0; i < n; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (!poolItem.getAS400Object().equals(aS400)) continue;
                return poolItem;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveConnectionCount() {
        int n = 0;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n2 = this.connectionList_.size();
            for (int i = 0; i < n2; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (!poolItem.isInUse()) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableConnectionCount() {
        int n = 0;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n2 = this.connectionList_.size();
            for (int i = 0; i < n2; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (poolItem.isInUse()) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolItem getConnection(boolean bl, ConnectionPoolEventSupport connectionPoolEventSupport, Locale locale, AS400ConnectionPoolAuthentication aS400ConnectionPoolAuthentication, SocketProperties socketProperties, int n) throws AS400SecurityException, IOException, ConnectionPoolException {
        PoolItem poolItem = null;
        boolean bl2 = this.properties_.isPretestConnections();
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n2 = this.connectionList_.size();
            for (int i = 0; i < n2; ++i) {
                PoolItem poolItem2 = (PoolItem)this.connectionList_.elementAt(i);
                if (poolItem2.isInUse()) continue;
                if (bl && poolItem2.getAS400Object() instanceof SecureAS400 && (poolItem2.getLocale() == null && locale == null || locale != null && poolItem2.getLocale() != null && poolItem2.getLocale().equals(locale))) {
                    if (bl2 && !this.isConnectionAlive(poolItem2)) continue;
                    poolItem = poolItem2;
                    break;
                }
                if (bl || poolItem2.getAS400Object() instanceof SecureAS400 || (poolItem2.getLocale() != null || locale != null) && (locale == null || poolItem2.getLocale() == null || !poolItem2.getLocale().equals(locale)) || bl2 && !this.isConnectionAlive(poolItem2)) continue;
                poolItem = poolItem2;
                break;
            }
            if (poolItem != null) {
                PoolItem poolItem3 = poolItem;
                synchronized (poolItem3) {
                    poolItem.setInUse(true);
                }
            }
        }
        if (poolItem == null) {
            poolItem = this.createNewConnection(0, false, bl, connectionPoolEventSupport, locale, aS400ConnectionPoolAuthentication, socketProperties, n);
        }
        return poolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PoolItem getConnection(int n, boolean bl, ConnectionPoolEventSupport connectionPoolEventSupport, Locale locale, AS400ConnectionPoolAuthentication aS400ConnectionPoolAuthentication, SocketProperties socketProperties, int n2) throws AS400SecurityException, IOException, ConnectionPoolException {
        PoolItem poolItem = null;
        boolean bl2 = this.properties_.isPretestConnections();
        Vector vector = this.connectionList_;
        synchronized (vector) {
            PoolItem poolItem2;
            int n3;
            int n4 = this.connectionList_.size();
            for (n3 = 0; n3 < n4; ++n3) {
                poolItem2 = (PoolItem)this.connectionList_.elementAt(n3);
                if (poolItem2.isInUse()) continue;
                if (bl && poolItem2.getAS400Object() instanceof SecureAS400 && poolItem2.getAS400Object().isConnected(n) && (poolItem2.getLocale() == null && locale == null || locale != null && poolItem2.getLocale() != null && poolItem2.getLocale().equals(locale))) {
                    if (bl2 && !this.isConnectionAlive(poolItem2)) continue;
                    if (Trace.traceOn_) {
                        this.log(3, "Using already connected connection");
                    }
                    poolItem = poolItem2;
                    break;
                }
                if (bl || poolItem2.getAS400Object() instanceof SecureAS400 || !poolItem2.getAS400Object().isConnected(n) || (poolItem2.getLocale() != null || locale != null) && (locale == null || poolItem2.getLocale() == null || !poolItem2.getLocale().equals(locale)) || bl2 && !this.isConnectionAlive(poolItem2)) continue;
                if (Trace.traceOn_) {
                    this.log(3, "Using already connected connection");
                }
                poolItem = poolItem2;
                break;
            }
            if (poolItem == null) {
                for (n3 = 0; n3 < n4; ++n3) {
                    poolItem2 = (PoolItem)this.connectionList_.elementAt(n3);
                    if (poolItem2.isInUse()) continue;
                    if (bl && poolItem2.getAS400Object() instanceof SecureAS400 && (poolItem2.getLocale() == null && locale == null || locale != null && poolItem2.getLocale().equals(locale))) {
                        if (bl2 && !this.isConnectionAlive(poolItem2)) continue;
                        if (Trace.traceOn_) {
                            this.log(3, "Must not have found a suitable connection, using first available");
                        }
                        poolItem = poolItem2;
                        break;
                    }
                    if (bl || poolItem2.getAS400Object() instanceof SecureAS400 || (poolItem2.getLocale() != null || locale != null) && (locale == null || !poolItem2.getLocale().equals(locale)) || bl2 && !this.isConnectionAlive(poolItem2)) continue;
                    if (Trace.traceOn_) {
                        this.log(3, "Must not have found a suitable connection, using first available.");
                    }
                    poolItem = poolItem2;
                    break;
                }
            }
            if (poolItem != null) {
                PoolItem poolItem3 = poolItem;
                synchronized (poolItem3) {
                    if (!poolItem.getAS400Object().isConnected(n)) {
                        poolItem.getAS400Object().connectService(n);
                    }
                    poolItem.setInUse(true);
                }
            }
        }
        if (poolItem == null) {
            poolItem = this.createNewConnection(n, true, bl, connectionPoolEventSupport, locale, aS400ConnectionPoolAuthentication, socketProperties, n2);
        }
        return poolItem;
    }

    public int getConnectionCount() {
        return this.connectionList_.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasConnectedConnection() {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = 0; i < n; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (!poolItem.getAS400Object().isConnected()) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean isConnectionAlive(PoolItem poolItem) {
        if (poolItem.isFailedPretest()) {
            return false;
        }
        if (poolItem.getAS400Object().isConnectionAlive()) {
            return true;
        }
        poolItem.setFailedPretest();
        return false;
    }

    private final void log(String string) {
        if (Trace.traceOn_) {
            Trace.log(3, string);
        }
        if (this.log_ != null) {
            this.log_.log(string);
        }
    }

    private final void log(int n, String string) {
        if (Trace.traceOn_ && Trace.isTraceOn(n)) {
            Trace.log(n, string);
            if (this.log_ != null) {
                this.log_.log(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExpiredConnections(ConnectionPoolEventSupport connectionPoolEventSupport) throws AS400SecurityException, IOException {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = n - 1; i >= 0; --i) {
                ConnectionPoolEvent connectionPoolEvent;
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (poolItem.isInUse()) {
                    if (this.properties_.getMaxUseTime() < 0L || poolItem.getInUseTime() < this.properties_.getMaxUseTime()) continue;
                    if (this.log_ != null || Trace.traceOn_) {
                        this.log(ResourceBundleLoader.getText(EXPIRED_MAX_USE_TIME, new String[]{this.systemName_, this.userID_}));
                    }
                    if (Trace.traceOn_) {
                        this.log(4, "Disconnecting pooled connection (currently in use) because it has exceeded the maximum use time limit of " + this.properties_.getMaxUseTime() + " milliseconds.");
                    }
                    poolItem.getAS400Object().disconnectAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (connectionPoolEventSupport == null) continue;
                    connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                    connectionPoolEventSupport.fireConnectionExpiredEvent(connectionPoolEvent);
                    continue;
                }
                if (poolItem.isFailedPretest()) {
                    if (this.log_ != null || Trace.traceOn_) {
                        this.log(ResourceBundleLoader.getText(EXPIRED_FAILED_PRETEST, new String[]{this.systemName_, this.userID_}));
                    }
                    if (Trace.traceOn_) {
                        this.log(1, "Disconnecting pooled connection (not currently in use) because it has failed a validation pretest.");
                    }
                    poolItem.getAS400Object().disconnectAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (connectionPoolEventSupport == null) continue;
                    connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                    connectionPoolEventSupport.fireConnectionExpiredEvent(connectionPoolEvent);
                    continue;
                }
                if (this.properties_.getMaxInactivity() >= 0L && poolItem.getInactivityTime() >= this.properties_.getMaxInactivity()) {
                    if (this.log_ != null || Trace.traceOn_) {
                        this.log(ResourceBundleLoader.getText(EXPIRED_INACTIVE, new String[]{this.systemName_, this.userID_}));
                    }
                    if (Trace.traceOn_) {
                        this.log(1, "Disconnecting pooled connection (not currently in use) because it has exceeded the maximum inactivity time limit of " + this.properties_.getMaxInactivity() + " milliseconds.");
                    }
                    poolItem.getAS400Object().disconnectAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (connectionPoolEventSupport == null) continue;
                    connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                    connectionPoolEventSupport.fireConnectionExpiredEvent(connectionPoolEvent);
                    continue;
                }
                if (this.properties_.getMaxUseCount() >= 0 && poolItem.getUseCount() >= this.properties_.getMaxUseCount()) {
                    if (this.log_ != null || Trace.traceOn_) {
                        this.log(ResourceBundleLoader.getText(EXPIRED_MAX_USE_COUNT, new String[]{this.systemName_, this.userID_}));
                    }
                    if (Trace.traceOn_) {
                        this.log(1, "Disconnecting pooled connection (not currently in use) because it has exceeded the maximum use count of " + this.properties_.getMaxUseCount());
                    }
                    poolItem.getAS400Object().disconnectAllServices();
                    this.connectionList_.removeElementAt(i);
                    if (connectionPoolEventSupport == null) continue;
                    connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                    connectionPoolEventSupport.fireConnectionExpiredEvent(connectionPoolEvent);
                    continue;
                }
                if (this.properties_.getMaxLifetime() < 0L || poolItem.getLifeSpan() < this.properties_.getMaxLifetime()) continue;
                if (this.log_ != null || Trace.traceOn_) {
                    this.log(ResourceBundleLoader.getText(EXPIRED_MAX_LIFETIME, new String[]{this.systemName_, this.userID_}));
                }
                if (Trace.traceOn_) {
                    this.log(1, "Disconnecting pooled connection (not currently in use) because it has exceeded the maximum lifetime limit of " + this.properties_.getMaxLifetime() + " milliseconds.");
                }
                poolItem.getAS400Object().disconnectAllServices();
                this.connectionList_.removeElementAt(i);
                if (connectionPoolEventSupport == null) continue;
                connectionPoolEvent = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                connectionPoolEventSupport.fireConnectionExpiredEvent(connectionPoolEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeIfExpired(PoolItem poolItem, ConnectionPoolEventSupport connectionPoolEventSupport) {
        if (this.connectionList_.isEmpty()) {
            return false;
        }
        boolean bl = false;
        String string = null;
        Serializable serializable = this.connectionList_;
        synchronized (serializable) {
            string = this.checkConnectionExpiration(poolItem);
            if (string != NOT_EXPIRED) {
                this.connectionList_.removeElement(poolItem);
                bl = true;
            }
        }
        if (bl) {
            if ((this.log_ != null || Trace.traceOn_) && string != null) {
                this.log(ResourceBundleLoader.getText(string, new String[]{this.systemName_, this.userID_}));
            }
            if (connectionPoolEventSupport != null) {
                serializable = new ConnectionPoolEvent(poolItem.getAS400Object(), 4);
                connectionPoolEventSupport.fireConnectionExpiredEvent((ConnectionPoolEvent)serializable);
            }
            if (Trace.traceOn_) {
                this.log(1, "Disconnecting pooled connection (not currently in use) because it has expired.");
            }
            poolItem.getAS400Object().disconnectAllServices();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeUnusedElements() {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            if (this.connectionList_.size() > 0) {
                int n = this.connectionList_.size();
                if (n == 0) {
                    return false;
                }
                for (int i = n - 1; i >= 0; --i) {
                    PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                    if (poolItem.isInUse()) continue;
                    if (Trace.traceOn_) {
                        this.log(1, "Disconnecting pooled connection (not currently in use) because removeFromPool() was called.");
                    }
                    poolItem.getAS400Object().disconnectAllServices();
                    this.connectionList_.removeElementAt(i);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeElement(AS400 aS400) {
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n = this.connectionList_.size();
            for (int i = 0; i < n; ++i) {
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(i);
                if (!poolItem.getAS400Object().equals(aS400)) continue;
                this.connectionList_.removeElement(poolItem);
                return;
            }
        }
    }

    void setLog(Log log) {
        this.log_ = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutDownOldest() {
        if (this.log_ != null || Trace.traceOn_) {
            this.log(ResourceBundleLoader.getText("CL_REMOLD", new String[]{this.systemName_, this.userID_}));
        }
        int n = 0;
        Vector vector = this.connectionList_;
        synchronized (vector) {
            int n2 = this.getConnectionCount() - this.properties_.getMaxConnections() + 1;
            for (int i = 0; i < n2; ++i) {
                n = 0;
                if (this.connectionList_.size() <= 0) continue;
                long l = 0L;
                int n3 = this.connectionList_.size();
                for (int j = 0; j < n3; ++j) {
                    PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(j);
                    if (poolItem.isInUse() || poolItem.getInactivityTime() <= l && n != 0) continue;
                    n = j;
                    l = poolItem.getInactivityTime();
                }
                PoolItem poolItem = (PoolItem)this.connectionList_.elementAt(n);
                if (poolItem.isInUse()) continue;
                if (Trace.traceOn_) {
                    this.log(1, "Disconnecting pooled connection (not currently in use) during removal of oldest unallocated connections.");
                }
                poolItem.getAS400Object().disconnectAllServices();
                this.connectionList_.removeElementAt(n);
                if (this.log_ == null && !Trace.traceOn_) continue;
                this.log(ResourceBundleLoader.getText("CL_REMOLDCOMP", new String[]{this.systemName_, this.userID_}));
            }
        }
    }
}

