/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.dds;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import miworkplace.common.model.Tasklist;
import miworkplace.ui.api.IOutlinePageProvider;
import miworkplace.ui.editor.FormatLine;
import miworkplace.ui.editor.FormatLineListener;
import miworkplace.ui.editor.FormatLineProvider;
import miworkplace.ui.editor.IAstProvider;
import miworkplace.ui.editor.ISourceViewerExtension;
import miworkplace.ui.editor.RemoteEditor;
import miworkplace.ui.editor.dds.DdsFormatLineListener;
import miworkplace.ui.editor.dds.DdsOutlinePage;
import miworkplace.ui.editor.dds.DdsSourceViewerConfiguration;
import miworkplace.ui.editor.dds.TasklistAdapter;
import miworkplace.ui.editor.dds.ast.Ast;
import miworkplace.ui.editor.dds.text.PartitionScanner;
import miworkplace.ui.editor.dds.text.PartitionTypes;
import miworkplace.ui.editor.dds.text.SourceModelReconcileStrategy;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.event.Event;

public class DdsEditor
extends RemoteEditor
implements IOutlinePageProvider {
    private Ast ast;
    private DdsOutlinePage outlinePage;
    private TasklistAdapter tasklistAdapter;

    @Inject
    public DdsEditor(MPart part, IResourcePool imagePool) {
        super(part, imagePool);
    }

    @PostConstruct
    public void initialize() {
        this.createTaskListAdapter();
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        IEclipseContext additionalContext = EclipseContextFactory.create((String)this.memberPath);
        additionalContext.set("memberPath", (Object)this.memberPath);
        additionalContext.set("inputUri", (Object)this.inputUri);
        additionalContext.set(RemoteEditor.class, (Object)this);
        SourceModelReconcileStrategy strategy = (SourceModelReconcileStrategy)ContextInjectionFactory.make(SourceModelReconcileStrategy.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        IEclipseContext sourceViewerContext = this.context.createChild();
        sourceViewerContext.set(SourceModelReconcileStrategy.class, (Object)strategy);
        return (SourceViewerConfiguration)ContextInjectionFactory.make(DdsSourceViewerConfiguration.class, (IEclipseContext)sourceViewerContext);
    }

    protected void createTaskListAdapter() {
        IEclipseContext additionalContext = EclipseContextFactory.create((String)this.memberPath);
        additionalContext.set("memberPath", (Object)this.memberPath);
        additionalContext.set("inputUri", (Object)this.inputUri);
        additionalContext.set(RemoteEditor.class, (Object)this);
        this.tasklistAdapter = (TasklistAdapter)ContextInjectionFactory.make(TasklistAdapter.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        PartitionScanner scanner = new PartitionScanner();
        return new FastPartitioner((IPartitionTokenScanner)scanner, PartitionTypes.PARTITION_TYPES);
    }

    public Control getOutlinePage(Composite parent) {
        if (this.outlinePage == null) {
            this.buildOutlinePage(parent);
        }
        return this.outlinePage.getControl();
    }

    private void buildOutlinePage(Composite parent) {
        IEclipseContext pageContext = this.context.createChild();
        pageContext.set(Composite.class, (Object)parent);
        pageContext.set("connection", (Object)this.connectionName);
        pageContext.set("inputUri", (Object)this.inputUri);
        this.outlinePage = (DdsOutlinePage)ContextInjectionFactory.make(DdsOutlinePage.class, (IEclipseContext)pageContext);
    }

    protected boolean supportFormatLines() {
        return true;
    }

    protected FormatLineListener createFormatLineListener(ISourceViewerExtension editorExtension, FormatLineProvider formatLineProvider, FormatLine formatLine) {
        IEclipseContext formatLineContext = this.context.createChild();
        formatLineContext.set(ISourceViewerExtension.class, (Object)this);
        formatLineContext.set(FormatLine.class, (Object)formatLine);
        formatLineContext.set("inputUri", (Object)this.inputUri);
        DdsFormatLineListener formatLineListener = (DdsFormatLineListener)((Object)ContextInjectionFactory.make(DdsFormatLineListener.class, (IEclipseContext)formatLineContext));
        return formatLineListener;
    }

    protected void registerContextMenu() {
        this.menuService.registerContextMenu((Object)this.getViewer().getTextWidget(), "miworkplace.ui.editor.dds.popupmenu");
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter == Tasklist.class) {
            return this.tasklistAdapter.getAdapter(adapter);
        }
        if (adapter == IAstProvider.class) {
            return this.ast;
        }
        Object adaptedObject = super.getAdapter(adapter);
        if (adaptedObject != null) {
            return adaptedObject;
        }
        return null;
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        String astInputUri = event.getProperty("inputUri").toString();
        Object eventData = event.getProperty("org.eclipse.e4.data");
        if (this.inputUri.equals(astInputUri)) {
            this.ast = eventData != null && eventData instanceof Ast ? (Ast)eventData : null;
        }
    }
}

