/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl.ast;

import miworkplace.ui.editor.cl.ast.AbstractToken;
import miworkplace.ui.editor.cl.ast.Statement;
import org.apache.commons.lang3.StringUtils;

public class Variable {
    private Statement statement;
    private AbstractToken name;
    private AbstractToken typeToken;
    private Type type;
    private AbstractToken lengthToken;
    private Integer length;
    private AbstractToken decPosToken;
    private Integer decimalPositions;

    public void setName(AbstractToken token) {
        this.name = token;
    }

    public AbstractToken getName() {
        return this.name;
    }

    public String toString() {
        return this.name != null ? this.name.value : null;
    }

    public Type getType() {
        return this.type;
    }

    public AbstractToken getTypeToken() {
        return this.typeToken;
    }

    public void setTypeToken(AbstractToken token) {
        this.typeToken = token;
        if (token == null) {
            this.type = null;
            return;
        }
        if ("*CHAR".equalsIgnoreCase(token.value)) {
            this.type = Type.Character;
            this.length = this.length == null ? 5000 : this.length;
        } else if ("*INT".equalsIgnoreCase(token.value)) {
            this.type = Type.Integer;
            this.length = this.length == null ? 4 : this.length;
        } else if ("*UINT".equalsIgnoreCase(token.value)) {
            this.type = Type.UnsignedInteger;
            this.length = this.length == null ? 4 : this.length;
        } else if ("*LGL".equalsIgnoreCase(token.value)) {
            this.type = Type.Boolean;
            this.length = this.length == null ? 1 : this.length;
        } else if ("*PTR".equalsIgnoreCase(token.value)) {
            this.type = Type.Pointer;
        } else if ("*DEC".equalsIgnoreCase(token.value)) {
            this.type = Type.Decimal;
            this.length = this.length == null ? 15 : this.length;
            this.decimalPositions = this.decimalPositions == null ? 9 : this.decimalPositions;
        }
    }

    public Integer getLength() {
        return this.length;
    }

    public AbstractToken getLengthToken() {
        return this.lengthToken;
    }

    public void setLengthToken(AbstractToken token) {
        this.lengthToken = token;
        if (StringUtils.isNumeric((CharSequence)token.value)) {
            this.length = Integer.parseInt(token.value);
        }
    }

    public void setDecimalPositionToken(AbstractToken token) {
        this.decPosToken = token;
        if (StringUtils.isNumeric((CharSequence)token.value)) {
            this.decimalPositions = Integer.parseInt(token.value);
        }
    }

    public Integer getDecimalPositions() {
        return this.decimalPositions;
    }

    public AbstractToken getDecPosToken() {
        return this.decPosToken;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public static enum Type {
        Character,
        Integer,
        UnsignedInteger,
        Boolean,
        Decimal,
        Pointer;

    }
}

