/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import miworkplace.ui.editor.cl.ast.AbstractToken;
import miworkplace.ui.editor.cl.ast.Statement;

public class Subroutine {
    private LinkedList<Statement> statements = new LinkedList();
    private String name;
    private AbstractToken nameToken;

    public void addStatement(Statement st) {
        this.statements.add(st);
    }

    public void addStatements(List<Statement> statements) {
        this.statements.addAll(statements);
    }

    public List<Statement> list() {
        return Collections.unmodifiableList(this.statements);
    }

    public String getName() {
        return this.name;
    }

    public AbstractToken getNameToken() {
        return this.nameToken;
    }

    public void setNameToken(AbstractToken nameToken) {
        this.nameToken = nameToken;
        if (nameToken != null) {
            this.name = nameToken.value;
        }
    }

    public AbstractToken getStart() {
        if (this.statements.isEmpty()) {
            return null;
        }
        return this.statements.getFirst().list().get(0);
    }

    public AbstractToken getEnd() {
        if (this.statements.isEmpty()) {
            return null;
        }
        List<AbstractToken> tokens = this.statements.getLast().list();
        return tokens.get(tokens.size() - 1);
    }

    public String toString() {
        return this.name;
    }
}

