/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.text;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.services.api.Index;
import miworkplace.services.api.IndexStore;
import miworkplace.ui.editor.ILEDocsProvider;
import miworkplace.ui.editor.include.IIncludeService;
import miworkplace.ui.editor.include.IncludeData;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Constant;
import miworkplace.ui.editor.rpg.ast.DataStructure;
import miworkplace.ui.editor.rpg.ast.Include;
import miworkplace.ui.editor.rpg.ast.Parameter;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.ProcedureInterface;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.editor.rpg.ast.Token;
import miworkplace.ui.editor.rpg.ast.Variable;
import miworkplace.ui.editor.rpg.text.DescriptionBuilder;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class RpgTextHover
implements ITextHover {
    @Inject
    private IndexStore indexStore;
    @Inject
    private LogService logger;
    @Inject
    @Named(value="inputUri")
    private String inputUri;
    @Inject
    private ILEDocsProvider iledocsProvider;
    @Inject
    private IIncludeService includeService;
    private DescriptionBuilder descriptionBuilder = new DescriptionBuilder();
    private String ifsPath;
    private String connectionName;
    private Ast ast;

    @PostConstruct
    public void postConstruct() {
        this.ifsPath = EditorInputUriUtil.getMemberPath((String)this.inputUri);
        this.connectionName = EditorInputUriUtil.getConnectionName((String)this.inputUri);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.ast == null) {
            return null;
        }
        try {
            Index index = this.indexStore.get(this.connectionName, this.ifsPath);
            Object value = index.get(hoverRegion.getOffset());
            if (value != null) {
                ProcedureInterface pi;
                Procedure scope = this.ast.getScope(hoverRegion.getOffset());
                Token token = (Token)value;
                String tokenValue = token.value;
                if (token.value.contains(".")) {
                    String[] dsParts = token.value.split("\\.", 2);
                    tokenValue = dsParts[0];
                }
                Object symbol = null;
                if (scope == null) {
                    symbol = this.ast.getSymbol(tokenValue);
                } else {
                    symbol = scope.getSymbol(tokenValue);
                    if (symbol == null) {
                        symbol = this.ast.getSymbol(tokenValue);
                        scope = null;
                    }
                }
                if (symbol == null && scope != null && (pi = scope.getProcedureInterface()) != null) {
                    for (Parameter parameter : pi.getParameters()) {
                        if (!(parameter instanceof Variable) || !((Variable)parameter).getName().equalsIgnoreCase(tokenValue)) continue;
                        symbol = parameter;
                        break;
                    }
                }
                if (symbol == null) {
                    for (Include include : this.ast.listIncludes()) {
                        Ast ast;
                        IncludeData includeData = this.includeService.getIncludeData(this.connectionName, this.ifsPath, include.getFileUnquoted());
                        if (includeData != null && includeData.getAst() instanceof Ast && (symbol = (ast = (Ast)includeData.getAst()).getSymbol(tokenValue)) != null) break;
                    }
                }
                if (symbol != null) {
                    String info = this.composeInfo(symbol, scope);
                    return info;
                }
            }
        }
        catch (Exception e) {
            this.logger.log(2, "Error on determining hover info for " + hoverRegion.getOffset(), (Throwable)e);
        }
        return null;
    }

    private String composeInfo(Object symbol, Procedure scope) {
        if (symbol instanceof Constant) {
            Constant constant = (Constant)symbol;
            return this.descriptionBuilder.build(constant, this.ast, scope, this.iledocsProvider.getConstant(this.connectionName, this.ifsPath, constant.name.value, this.getQualifiedIncludePaths(this.ast)));
        }
        if (symbol instanceof Variable) {
            Variable variable = (Variable)symbol;
            return this.descriptionBuilder.build(variable, this.ast, scope, this.iledocsProvider.getVariable(this.connectionName, this.ifsPath, variable.getName(), this.getQualifiedIncludePaths(this.ast)));
        }
        if (symbol instanceof DataStructure) {
            DataStructure ds = (DataStructure)symbol;
            return this.descriptionBuilder.build(ds, this.ast, scope, this.iledocsProvider.getVariable(this.connectionName, this.ifsPath, ds.getName(), this.getQualifiedIncludePaths(this.ast)));
        }
        if (symbol instanceof Prototype) {
            Prototype pr = (Prototype)symbol;
            return this.descriptionBuilder.build(pr, scope, this.iledocsProvider.getProcedure(this.connectionName, this.ifsPath, pr.getName(), this.getQualifiedIncludePaths(this.ast)));
        }
        if (symbol instanceof Procedure) {
            Procedure p = (Procedure)symbol;
            return this.descriptionBuilder.build(p, this.iledocsProvider.getProcedure(this.connectionName, this.ifsPath, p.getName(), this.getQualifiedIncludePaths(this.ast)));
        }
        return null;
    }

    private List<String> getQualifiedIncludePaths(Ast ast) {
        if (ast == null) {
            return Collections.emptyList();
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (Include include : ast.listIncludes()) {
            if (!StringUtils.isNotEmpty((CharSequence)include.getQualifiedPath())) continue;
            paths.add(include.getQualifiedPath());
        }
        return paths;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        String astInputUri;
        if (event.containsProperty("inputUri") && this.inputUri.equals(astInputUri = event.getProperty("inputUri").toString())) {
            Object value = event.getProperty("org.eclipse.e4.data");
            this.ast = value != null && value instanceof Ast ? (Ast)value : null;
        }
    }
}

