/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.pref;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import miworkplace.common.Constants;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.rpg.pref.IncludePathPreferenceNode;
import miworkplace.ui.pref.api.IPreferenceNode;
import miworkplace.ui.pref.api.IPreferenceProvider;
import miworkplace.ui.pref.api.IPreferencesService;
import miworkplace.ui.pref.api.Preference;
import miworkplace.ui.pref.api.PreferenceNode;
import miworkplace.ui.pref.api.SelectionPreference;

public class EditorPreferenceProvider
implements IPreferenceProvider {
    private List<IPreferenceNode> preferenceNodes = new LinkedList<IPreferenceNode>();
    private IPreferencesService service;

    void activate() {
        this.preferenceNodes.add((IPreferenceNode)new IncludePathPreferenceNode());
        this.preferenceNodes.add(this.buildContentAssistPreferences());
        if (this.service != null) {
            for (IPreferenceNode n : this.preferenceNodes) {
                this.service.add(n);
            }
        }
    }

    private IPreferenceNode buildContentAssistPreferences() {
        PreferenceNode node = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.editor.content.assist").setParentId("miworkplace.ui.editor").setName(Messages.editor_pref_content_assist);
        HashSet<Object> preferences = new HashSet<Object>();
        Preference preference = new Preference();
        preference.setId("miworkplace.ui.editor.content.assist.convert.case");
        preference.setType(Boolean.class);
        preference.setName(Messages.editor_pref_content_assist_convert_case);
        preference.setValue(Boolean.FALSE.toString());
        preference.setOrder(Integer.valueOf(1));
        preferences.add(preference);
        SelectionPreference casePreference = new SelectionPreference();
        casePreference.setId("miworkplace.ui.editor.content.assist.case");
        casePreference.setType(Set.class);
        casePreference.setName(Messages.editor_pref_content_assist_case);
        casePreference.setDescription(Messages.editor_pref_content_assist_case_ttt);
        casePreference.setValue(Constants.ContentAssistCase.lowercase.name());
        casePreference.addSuggestion(Constants.ContentAssistCase.uppercase.name());
        casePreference.addSuggestion(Constants.ContentAssistCase.lowercase.name());
        casePreference.setOrder(Integer.valueOf(2));
        preferences.add(casePreference);
        node.setPreferences(preferences);
        return node;
    }

    public void bindPreferenceService(IPreferencesService service) {
        this.service = service;
        if (!this.preferenceNodes.isEmpty()) {
            for (IPreferenceNode n : this.preferenceNodes) {
                service.add(n);
            }
        }
    }

    public void unbindPreferenceService(IPreferencesService service) {
        this.service = null;
    }
}

