/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.editor.IIncludePathResolver;
import miworkplace.ui.editor.IRpgEditor;
import miworkplace.ui.util.MemberLoader;
import miworkplace.ui.util.ObjectLoader;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.osgi.service.log.LogService;

public class OpenIncludeHandler {
    private final String OPEN_MEMBER_COMMAND_ID = "miworkplace.ui.command.openSourceMember";
    private final String OPEN_STREAM_FILE_COMMAND_ID = "miworkplace.ui.command.ifs.open";
    @Inject
    private LogService logger;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private EPartService partService;
    @Inject
    private IEclipseContext context;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    private IIncludePathResolver includePathResolver;
    private Pattern includePattern = Pattern.compile("\\s*\\/(include|copy)\\s.*", 2);

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        Object content = part.getObject();
        if (content != null && content instanceof IRemoteEditor && content instanceof IRpgEditor) {
            IRemoteEditor editor = (IRemoteEditor)part.getObject();
            IRpgEditor rpgEditor = (IRpgEditor)part.getObject();
            ISourceViewer viewer = editor.getViewer();
            Point selectedRange = viewer.getSelectedRange();
            IDocument document = editor.getDocument();
            try {
                IRegion lineInfo = document.getLineInformationOfOffset(selectedRange.x);
                String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                if (rpgEditor.isFreeSyntax()) {
                    Matcher m = this.includePattern.matcher(line);
                    return m.matches();
                }
                if (lineInfo.getLength() > 12) {
                    Matcher m = this.includePattern.matcher(line.substring(6));
                    return m.matches();
                }
            }
            catch (Exception e) {
                this.logger.log(1, "Could not determine if open include action could be enabled.", (Throwable)e);
            }
        }
        return false;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        Object content = part.getObject();
        if (content != null && content instanceof IRemoteEditor && content instanceof IRpgEditor) {
            IRemoteEditor editor = (IRemoteEditor)part.getObject();
            IRpgEditor rpgEditor = (IRpgEditor)part.getObject();
            ISourceViewer viewer = editor.getViewer();
            Point selectedRange = viewer.getSelectedRange();
            IDocument document = editor.getDocument();
            try {
                String[] incDirPaths;
                IRegion lineInfo = document.getLineInformationOfOffset(selectedRange.x);
                String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                this.logger.log(4, "Trying opening include file parsed from this line: " + line);
                String includePath = null;
                if (rpgEditor.isFreeSyntax()) {
                    includePath = this.parseIncludeValueForIncludePath(line);
                } else if (lineInfo.getLength() > 12) {
                    includePath = this.parseIncludeValueForIncludePath(line.substring(6));
                } else {
                    throw new RuntimeException(Messages.editor_handler_openinc_nopath + line);
                }
                this.logger.log(4, "Extracted this include path: " + includePath);
                if (includePath == null) {
                    throw new RuntimeException(Messages.editor_handler_openinc_nopath + line);
                }
                IRemoteObject sourceObject = this.getSourceObject(editor);
                String resolvedPath = this.includePathResolver.resolvePath(includePath, sourceObject, incDirPaths = this.applicationPreferences.get("miworkplace.ui.editor.include.path", "").split(":"));
                if (resolvedPath == null) {
                    Notifier.error((String)Messages.editor_handler_openinc_title, (String)Messages.editor_handler_openinc_invalidpath);
                } else if (resolvedPath.toUpperCase().startsWith("/QSYS.LIB")) {
                    this.logger.log(3, "Include path " + includePath + "not found as a stream file.");
                    this.openMember(sourceObject.getConnection(), resolvedPath);
                } else {
                    this.loadDirectory(sourceObject.getConnection(), resolvedPath);
                    this.logger.log(4, "Found a matching stream file at " + resolvedPath);
                    String includeWorkspacePath = this.resolveToWorkspaceStoreResource(sourceObject, resolvedPath);
                    this.openStreamFile(sourceObject.getConnection(), includeWorkspacePath);
                }
            }
            catch (Exception e) {
                this.logger.log(1, "Could not execute open include action.", (Throwable)e);
                Notifier.error((String)Messages.editor_handler_openinc_title, (String)Messages.editor_handler_openinc_error);
            }
        }
    }

    private String resolveToWorkspaceStoreResource(IRemoteObject sourceObject, String includeFilePath) {
        IConnection connection = sourceObject.getConnection();
        String[] filenames = includeFilePath.split("/");
        String path = "/";
        int i = 1;
        while (i < filenames.length) {
            List files = this.workspaceStore.getStreamFiles(connection, path);
            for (IRemoteObject file : files) {
                if (!file.getName().equalsIgnoreCase(filenames[i])) continue;
                path = file.getPath();
                break;
            }
            ++i;
        }
        return path;
    }

    private IRemoteObject getSourceObject(IRemoteEditor editor) {
        IRemoteObject remoteObject;
        String inputUri = editor.getInputUri();
        String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
        IConnection connection = this.connectionManager.get(connectionName);
        String memberPath = EditorInputUriUtil.getMemberPath((String)inputUri);
        IRemoteObject member = remoteObject = this.workspaceStore.get(connection, memberPath);
        return member;
    }

    private String parseIncludeValueForIncludePath(String path) {
        String includeValue = null;
        if ((path = path.trim()).indexOf(" ") == -1) {
            return null;
        }
        if ((path = path.substring(path.indexOf(" ") + 1).trim()).startsWith("'")) {
            int x = path.indexOf("'", 1);
            if (x > 0) {
                includeValue = path.substring(1, x);
            }
        } else if (path.startsWith("\"")) {
            int x = path.indexOf("\"", 1);
            if (x > 0) {
                includeValue = path.substring(1, x);
            }
        } else if (path.indexOf("//") >= 0) {
            int x = path.indexOf("//");
            includeValue = path.substring(0, x).trim();
        } else {
            includeValue = path;
        }
        if (includeValue != null) {
            includeValue = includeValue.trim();
        }
        return StringUtils.strip((String)includeValue, (String)";");
    }

    private void openMember(IConnection connection, String memberPath) {
        this.loadPath(connection, memberPath);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("miworkplace.ui.editor.command.parameter.connection", connection.getName());
        parameters.put("miworkplace.ui.editor.command.parameter.selection", memberPath);
        ParameterizedCommand command = this.commandService.createCommand("miworkplace.ui.command.openSourceMember", parameters);
        if (!command.getCommand().isDefined()) {
            this.logger.log(1, "Command miworkplace.ui.command.openSourceMember is not available. Could not open member " + memberPath + ".");
            return;
        }
        if (!this.handlerService.canExecute(command)) {
            this.logger.log(1, "Open Member Handler cannot execute for member " + memberPath + ".");
        } else {
            IEclipseContext handlerContext = this.context.createChild(this.getClass().getName());
            handlerContext.set(IConnectionManager.class, (Object)this.connectionManager);
            handlerContext.set(IConnection.class, (Object)connection);
            handlerContext.set("memberPath", (Object)memberPath);
            handlerContext.set(LogService.class, (Object)this.logger);
            handlerContext.set(EPartService.class, (Object)this.partService);
            this.handlerService.executeHandler(command, handlerContext);
            handlerContext.dispose();
        }
    }

    private void loadPath(IConnection connection, String memberPath) {
        String filePath;
        IRemoteObject sourceFile;
        if (this.workspaceStore.get(connection, memberPath) != null) {
            return;
        }
        QSYSObjectPathName path = new QSYSObjectPathName(memberPath);
        String libraryPath = "/QSYS.LIB/" + path.getLibraryName() + ".LIB";
        IRemoteObject library = this.workspaceStore.get(connection, libraryPath);
        if (library == null) {
            List libraries = this.workspaceStore.getLibraries(connection);
            for (IRemoteObject l : libraries) {
                if (!l.getName().equals(path.getLibraryName())) continue;
                this.workspaceStore.remove(library);
                break;
            }
            this.workspaceStore.addLibrary(connection, path.getLibraryName());
            library = this.workspaceStore.getLibrary(connection, path.getLibraryName());
        }
        if ((sourceFile = this.workspaceStore.get(connection, filePath = "/QSYS.LIB/" + path.getLibraryName() + ".LIB/" + path.getObjectName() + ".FILE")) == null || !library.areChildrenLoaded()) {
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.library", (Object)library);
            ObjectLoader loader = (ObjectLoader)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                throw new RuntimeException(String.format(Messages.editor_handler_openinc_loadfileerror, path.getObjectName(), status.getMessage()));
            }
        }
        if (this.workspaceStore.get(connection, memberPath) == null) {
            IRemoteObject file = this.workspaceStore.get(connection, filePath);
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.file", (Object)file);
            MemberLoader loader = (MemberLoader)ContextInjectionFactory.make(MemberLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                throw new RuntimeException(String.format(Messages.editor_handler_openinc_loadmbrerror, path.getObjectName(), status.getMessage()));
            }
        }
    }

    private void openStreamFile(IConnection connection, String path) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("miworkplace.ui.editor.command.parameter.connection", connection.getName());
        parameters.put("miworkplace.ui.editor.command.parameter.selection", path);
        ParameterizedCommand command = this.commandService.createCommand("miworkplace.ui.command.ifs.open", parameters);
        if (!command.getCommand().isDefined()) {
            this.logger.log(1, "Command miworkplace.ui.command.ifs.open is not available. Could not open stream file " + path + ".");
            return;
        }
        if (!this.handlerService.canExecute(command)) {
            this.logger.log(1, "Open Stream File Handler cannot execute for stream file " + path + ".");
        } else {
            IEclipseContext handlerContext = this.context.createChild(this.getClass().getName());
            handlerContext.set(IConnectionManager.class, (Object)this.connectionManager);
            handlerContext.set(IConnection.class, (Object)connection);
            handlerContext.set(LogService.class, (Object)this.logger);
            handlerContext.set(EPartService.class, (Object)this.partService);
            this.handlerService.executeHandler(command, handlerContext);
            handlerContext.dispose();
        }
    }

    private void loadDirectory(IConnection connection, String path) {
        if (this.workspaceStore.get(connection, path) != null) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new RuntimeException(Messages.editor_handler_openinc_abspath);
        }
        WorkspaceUtil.load((IConnection)connection, (String)path);
    }
}

