/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.fixed;

import miworkplace.ui.editor.IToggleCommentAdapter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.graphics.Point;

public class ToggleCommentAdapter
implements IToggleCommentAdapter {
    public void toggleComment(TextViewer viewer) throws Exception {
        IRewriteTarget rewriteTarget = viewer.getRewriteTarget();
        IDocument document = viewer.getDocument();
        Point selectedRange = viewer.getSelectedRange();
        int startOffet = selectedRange.x;
        int endOffset = selectedRange.x + selectedRange.y;
        int startLine = document.getLineOfOffset(startOffet);
        int endLine = document.getLineOfOffset(endOffset);
        rewriteTarget.beginCompoundChange();
        try {
            ToggleOperation op = this.determineToggleOperation(document, startLine, endLine);
            int line = startLine;
            do {
                IRegion lineInformation = document.getLineInformation(line);
                String lineText = document.get(lineInformation.getOffset(), lineInformation.getLength());
                String newLine = null;
                newLine = op == ToggleOperation.comment ? this.commentLine(lineText) : this.uncomment(lineText);
                if (newLine == null) continue;
                document.replace(lineInformation.getOffset(), lineInformation.getLength(), newLine);
            } while (++line <= endLine);
        }
        finally {
            rewriteTarget.endCompoundChange();
        }
    }

    private String uncomment(String lineText) {
        if (lineText.length() < 6) {
            return lineText;
        }
        StringBuilder sb = new StringBuilder(lineText);
        if (sb.charAt(6) == '*') {
            sb.deleteCharAt(6);
        } else {
            int x = sb.indexOf("//", 6);
            if (x == 6) {
                sb.delete(5, 8);
                if (sb.charAt(5) == ' ') {
                    sb.deleteCharAt(5);
                }
            } else {
                sb.deleteCharAt(x);
                sb.deleteCharAt(x);
            }
        }
        return sb.toString();
    }

    private String commentLine(String lineText) {
        StringBuilder sb = new StringBuilder(lineText);
        if (sb.length() < 5) {
            sb.append(StringUtils.repeat((char)' ', (int)(5 - sb.length())));
        }
        sb.insert(5, " // ");
        return sb.toString();
    }

    private ToggleOperation determineToggleOperation(IDocument document, int startLine, int endLine) throws Exception {
        ToggleOperation op = null;
        int line = startLine;
        do {
            IRegion lineInformation;
            String lineText;
            op = (lineText = document.get((lineInformation = document.getLineInformation(line)).getOffset(), lineInformation.getLength())).length() < 7 ? ToggleOperation.comment : (lineText.charAt(6) == '*' ? (op == null || op == ToggleOperation.uncomment ? ToggleOperation.uncomment : op) : (lineText.substring(6).trim().startsWith("//") ? (op == null || op == ToggleOperation.uncomment ? ToggleOperation.uncomment : op) : ToggleOperation.comment));
        } while (++line <= endLine);
        return op == null ? ToggleOperation.comment : op;
    }

    private static enum ToggleOperation {
        comment,
        uncomment;

    }
}

