/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.contentassist;

import java.util.Iterator;
import miworkplace.ui.editor.AbstractCompletionProposal;
import miworkplace.ui.editor.rpg.ast.DataStructure;
import miworkplace.ui.editor.rpg.ast.Parameter;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.editor.rpg.ast.Variable;
import miworkplace.ui.editor.rpg.text.DescriptionBuilder;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class FreePrototypeCompletionProposal
extends AbstractCompletionProposal {
    private Prototype prototype;
    private Image icon;
    private DescriptionBuilder descriptionBuilder = new DescriptionBuilder();

    public FreePrototypeCompletionProposal(Prototype prototype, Image icon) {
        super(prototype.getName());
        this.prototype = prototype;
        this.icon = icon;
    }

    public FreePrototypeCompletionProposal(Prototype prototype, Image icon, String description) {
        super(prototype.getName(), description);
        this.prototype = prototype;
        this.icon = icon;
    }

    public String getDisplayString() {
        return this.prototype.getName();
    }

    public Image getImage() {
        return this.icon;
    }

    protected String getApplyString() {
        return this.prototype.getName() + "()";
    }

    public StyledString getStyledDisplayString() {
        return new StyledString(this.composeDisplayString());
    }

    protected int getCursorPosition() {
        return super.getCursorPosition() - 1;
    }

    private String composeDisplayString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.prototype.getName());
        sb.append("(");
        if (this.prototype.getParameters() != null && !this.prototype.getParameters().isEmpty()) {
            Iterator iterator = this.prototype.getParameters().iterator();
            while (iterator.hasNext()) {
                Parameter parameter = (Parameter)iterator.next();
                if (parameter instanceof Variable) {
                    String declaration = this.descriptionBuilder.buildVariableType((Variable)parameter);
                    if (StringUtils.isNotBlank((CharSequence)declaration)) {
                        sb.append(declaration);
                        sb.append(" ");
                        sb.append(StringUtils.defaultString((String)((Variable)parameter).getName()));
                    }
                } else if (parameter instanceof DataStructure) {
                    DataStructure ds = (DataStructure)parameter;
                    if (ds.getLike() != null) {
                        sb.append(ds.getLike());
                        sb.append(" ");
                    }
                    if (StringUtils.isNotBlank((CharSequence)ds.getName())) {
                        sb.append(ds.getName());
                    }
                }
                if (!iterator.hasNext()) continue;
                sb.append(" : ");
            }
        }
        sb.append(")");
        if (this.prototype.getReturnValue() != null) {
            Object returnValue = this.prototype.getReturnValue();
            if (returnValue instanceof Variable) {
                sb.append(" : " + this.descriptionBuilder.buildVariableType((Variable)returnValue));
            } else if (returnValue instanceof DataStructure && ((DataStructure)returnValue).getLike() != null) {
                sb.append(" : " + ((DataStructure)returnValue).getLike());
            }
        }
        return sb.toString();
    }
}

