/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import miworkplace.ast.rpg.AST;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.Task;
import miworkplace.common.model.Tasklist;
import miworkplace.ui.api.IEditor;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.osgi.service.event.Event;

public class TasklistAdapter
implements IAdaptable {
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    private IEditor editor;
    private String memberPath;
    private Object ast;

    @PostConstruct
    private void postConstruct() {
        this.memberPath = EditorInputUriUtil.getMemberPath((String)this.editor.getInputUri());
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        if (event.containsProperty("inputUri")) {
            String astInputUri = event.getProperty("inputUri").toString();
            if (this.editor.getInputUri().equals(astInputUri)) {
                this.ast = event.getProperty("org.eclipse.e4.data");
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Tasklist.class && this.ast != null) {
            Tasklist tasklist = new Tasklist();
            tasklist.editorUri = this.editor.getInputUri();
            if (this.ast instanceof AST) {
                this.buildTaskList(tasklist);
            } else {
                this.buildFreeTaskList(tasklist);
            }
            return tasklist;
        }
        return null;
    }

    private void buildFreeTaskList(Tasklist tasklist) {
        boolean caseSensitive = this.applicationPreferences.getBoolean("miworkplace.ui.editor.tasktags.casesensitive", false);
        String taskTags = this.applicationPreferences.get("miworkplace.ui.editor.tasktags", "TODO,FIXME");
        if (StringUtils.isBlank((CharSequence)taskTags)) {
            tasklist.tasks = new Task[0];
            return;
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        ArrayList<String> quotedTags = new ArrayList<String>();
        String[] stringArray = taskTags.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String taskTag = stringArray[n2];
            quotedTags.add(Pattern.quote(taskTag));
            ++n2;
        }
        Pattern pattern = caseSensitive ? Pattern.compile(".*\\/\\/\\s*(" + StringUtils.join(quotedTags, (String)"|") + ").*", 64) : Pattern.compile(".*\\/\\/\\s*(" + StringUtils.join(quotedTags, (String)"|") + ").*", 66);
        String[] lines = this.editor.getDocument().get().split("\n");
        int i = 1;
        String[] stringArray2 = lines;
        int n3 = lines.length;
        int n4 = 0;
        while (n4 < n3) {
            String line = stringArray2[n4];
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                int end = matcher.end(1);
                if (line.length() == end) {
                    tasks.add(new Task(line.substring(end).trim(), this.memberPath, this.editor.getInputUri(), i));
                } else {
                    char followingChar = line.charAt(end);
                    if (followingChar == ' ' || followingChar == ':') {
                        Task task = new Task(line.substring(end).trim(), this.memberPath, this.editor.getInputUri(), i);
                        tasks.add(task);
                    }
                }
            }
            ++i;
            ++n4;
        }
        tasklist.tasks = tasks.toArray(new Task[tasks.size()]);
    }

    private void buildTaskList(Tasklist tasklist) {
        boolean caseSensitive = this.applicationPreferences.getBoolean("miworkplace.ui.editor.tasktags.casesensitive", false);
        String taskTags = this.applicationPreferences.get("miworkplace.ui.editor.tasktags", "TODO,FIXME");
        if (StringUtils.isBlank((CharSequence)taskTags)) {
            tasklist.tasks = new Task[0];
            return;
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        ArrayList<String> quotedTags = new ArrayList<String>();
        String[] stringArray = taskTags.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String taskTag = stringArray[n2];
            quotedTags.add(Pattern.quote(taskTag));
            ++n2;
        }
        Pattern freePattern = caseSensitive ? Pattern.compile("........*\\/\\/\\s*(" + StringUtils.join(quotedTags, (String)"|") + ").*", 64) : Pattern.compile("........*\\/\\/\\s*(" + StringUtils.join(quotedTags, (String)"|") + ").*", 66);
        Pattern fixedPattern = caseSensitive ? Pattern.compile("......\\*\\s*(" + StringUtils.join(quotedTags, (String)"|") + ").*", 64) : Pattern.compile("......\\**\\s*(" + StringUtils.join(quotedTags, (String)"|") + ").*", 66);
        String[] lines = this.editor.getDocument().get().split("\n");
        int i = 1;
        String[] stringArray2 = lines;
        int n3 = lines.length;
        int n4 = 0;
        while (n4 < n3) {
            String line = stringArray2[n4];
            Matcher matchedMatcher = null;
            Matcher freeMatcher = freePattern.matcher(line);
            Matcher fixedMatcher = fixedPattern.matcher(line);
            if (freeMatcher.matches()) {
                matchedMatcher = freeMatcher;
            } else if (fixedMatcher.matches()) {
                matchedMatcher = fixedMatcher;
            }
            if (matchedMatcher != null) {
                int end = matchedMatcher.end(1);
                if (line.length() == end) {
                    tasks.add(new Task(line.substring(end).trim(), this.memberPath, this.editor.getInputUri(), i));
                } else {
                    char followingChar = line.charAt(end);
                    if (followingChar == ' ' || followingChar == ':') {
                        Task task = new Task(line.substring(end).trim(), this.memberPath, this.editor.getInputUri(), i);
                        tasks.add(task);
                    }
                }
            }
            ++i;
            ++n4;
        }
        tasklist.tasks = tasks.toArray(new Task[tasks.size()]);
    }
}

