/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import miworkplace.ast.rpg.AST;
import miworkplace.ast.rpg.Procedure;
import miworkplace.common.model.Tasklist;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.IEditor;
import miworkplace.ui.api.IOutlinePageProvider;
import miworkplace.ui.editor.AstProvider;
import miworkplace.ui.editor.CursorPositionChangedListener;
import miworkplace.ui.editor.DocumentBoundaryFinder;
import miworkplace.ui.editor.DoubleClickStrategy;
import miworkplace.ui.editor.FormatLine;
import miworkplace.ui.editor.FormatLineListener;
import miworkplace.ui.editor.FormatLineProvider;
import miworkplace.ui.editor.IRpgEditor;
import miworkplace.ui.editor.ISourceViewerExtension;
import miworkplace.ui.editor.IToggleCommentAdapter;
import miworkplace.ui.editor.IToggleCommentSupport;
import miworkplace.ui.editor.RpgWordBoundaryFinder;
import miworkplace.ui.editor.WordBoundaryFinder;
import miworkplace.ui.editor.ifs.StreamFileEditor;
import miworkplace.ui.editor.rpg.RpgCursorPositionChangedListener;
import miworkplace.ui.editor.rpg.RpgFormatLineListener;
import miworkplace.ui.editor.rpg.RpgOutlinePage;
import miworkplace.ui.editor.rpg.RpgSourceViewerConfiguration;
import miworkplace.ui.editor.rpg.TasklistAdapter;
import miworkplace.ui.editor.rpg.free.ToggleCommentAdapter;
import miworkplace.ui.editor.rpg.text.RPGPartitionScanner;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.event.Event;

public class RpgStreamFileEditor
extends StreamFileEditor
implements IOutlinePageProvider,
IRpgEditor,
IToggleCommentSupport {
    private Object ast;
    private RpgOutlinePage outlinePage;
    private IToggleCommentAdapter toggleCommentAdapter;
    private TasklistAdapter tasklistAdapter;

    @Inject
    public RpgStreamFileEditor(MPart part, IResourcePool imagePool) {
        super(part, imagePool);
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        IEclipseContext sourceViewerContext = this.context.createChild();
        sourceViewerContext.set("memberPath", (Object)this.memberPath);
        sourceViewerContext.set("inputUri", (Object)this.inputUri);
        return (SourceViewerConfiguration)ContextInjectionFactory.make(RpgSourceViewerConfiguration.class, (IEclipseContext)sourceViewerContext);
    }

    protected void createTaskListAdapter() {
        IEclipseContext tasklistContext = this.context.createChild();
        tasklistContext.set("memberPath", (Object)this.memberPath);
        tasklistContext.set("inputUri", (Object)this.inputUri);
        tasklistContext.set(IEditor.class, (Object)this);
        this.tasklistAdapter = (TasklistAdapter)ContextInjectionFactory.make(TasklistAdapter.class, (IEclipseContext)this.context, (IEclipseContext)tasklistContext);
    }

    protected CursorPositionChangedListener createCursorPositionChangedListener() {
        return new RpgCursorPositionChangedListener(this.eventBroker, (ITextViewer)this.getViewer(), (AstProvider)this);
    }

    @PostConstruct
    public void initialize() {
        DocumentBoundaryFinder boundaryFinder = new DocumentBoundaryFinder((WordBoundaryFinder)new RpgWordBoundaryFinder());
        DoubleClickStrategy doubleClickStrategy = new DoubleClickStrategy(boundaryFinder);
        this.getViewer().setTextDoubleClickStrategy((ITextDoubleClickStrategy)doubleClickStrategy, "free_partition");
        this.getViewer().setTextDoubleClickStrategy((ITextDoubleClickStrategy)doubleClickStrategy, "__dftl_partition_content_type");
        this.createTaskListAdapter();
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new RPGPartitionScanner(), RPGPartitionScanner.PARTITION_TYPES);
    }

    protected FormatLineListener createFormatLineListener(ISourceViewerExtension editorExtension, FormatLineProvider formatLineProvider, FormatLine formatLine) {
        return new RpgFormatLineListener(editorExtension, formatLineProvider, formatLine);
    }

    protected boolean supportFormatLines() {
        return true;
    }

    public Object getAst() {
        return this.ast;
    }

    protected void registerContextMenu() {
        this.menuService.registerContextMenu((Object)this.getViewer().getTextWidget(), "miworkplace.ui.editor.rpg.partdescriptor.stmf.popupmenu");
    }

    public Control getOutlinePage(Composite parent) {
        if (this.outlinePage == null) {
            this.buildOutlinePage(parent);
        }
        return this.outlinePage.getControl();
    }

    private void buildOutlinePage(Composite parent) {
        IEclipseContext pageContext = this.context.createChild();
        pageContext.set(Composite.class, (Object)parent);
        this.outlinePage = (RpgOutlinePage)ContextInjectionFactory.make(RpgOutlinePage.class, (IEclipseContext)pageContext);
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        String astInputUri;
        if (event.containsProperty("inputUri") && this.inputUri.equals(astInputUri = event.getProperty("inputUri").toString())) {
            this.ast = event.getProperty("org.eclipse.e4.data");
            if (this.ast != null) {
                this.toggleCommentAdapter = this.ast instanceof AST ? new miworkplace.ui.editor.rpg.fixed.ToggleCommentAdapter() : new ToggleCommentAdapter();
            }
        }
    }

    @Focus
    public void onFocus() {
        this.getViewer().getControl().setFocus();
        if (this.stackLayout.topControl == this.defaultComposite) {
            this.cursorPositionChangedListener.sendPositionUpdate();
        }
        this.eventBroker.post("miworkplace/ui/editor/focus/gained", (Object)this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter == Tasklist.class) {
            return this.tasklistAdapter.getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public void highlight(Object obj) {
        if (obj instanceof Procedure) {
            Procedure procedure = (Procedure)obj;
            IDocument document = this.getDocument();
            try {
                int startLineOffset = document.getLineOffset(procedure.getStartLine() - 1);
                int endLineOffset = document.getLineOffset(procedure.getEndLine() - 1);
                if (startLineOffset == endLineOffset) {
                    int lineLength = document.getLineLength(procedure.getStartLine() - 1);
                    this.highlightCodeRange(startLineOffset, lineLength);
                } else {
                    int endLineLength = document.getLineLength(procedure.getEndLine() - 1);
                    int endLineEndOffset = endLineOffset + endLineLength;
                    int selectionLength = endLineEndOffset - startLineOffset;
                    this.highlightCodeRange(startLineOffset, selectionLength);
                }
            }
            catch (BadLocationException e) {
                this.logger.error("Could not determine code range for highlighting procedure.", (Throwable)e);
            }
        }
    }

    public void toggleComment() {
        try {
            this.toggleCommentAdapter.toggleComment((TextViewer)this.getViewer());
        }
        catch (Exception e) {
            this.logger.error("Could not toggle comment for " + this.inputUri, (Throwable)e);
            Notifier.error((String)Messages.editor_rpg_rpgeditor_toggle_title, (String)Messages.editor_rpg_rpgeditor_toggle_error);
        }
    }

    public boolean isFreeSyntax() {
        IDocument document = this.getDocument();
        if (document.getLength() >= 6) {
            try {
                return document.get(0, 6).equals("**FREE");
            }
            catch (BadLocationException e) {
                this.logger.error("Could not determine if **FREE syntax.", (Throwable)e);
            }
        }
        return false;
    }
}

