/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import miworkplace.ui.editor.DefaultSourceViewerConfiguration;
import miworkplace.ui.editor.ILEDocsCompletionProcessor;
import miworkplace.ui.editor.rpg.contentassist.FreeCompletionProcessor;
import miworkplace.ui.editor.rpg.text.DefaultScanner;
import miworkplace.ui.editor.rpg.text.FreeScanner;
import miworkplace.ui.editor.rpg.text.MultiLineScanner;
import miworkplace.ui.editor.rpg.text.RPGPartitionScanner;
import miworkplace.ui.editor.rpg.text.RpgTextHover;
import miworkplace.ui.editor.rpg.text.SingleLineScanner;
import miworkplace.ui.editor.rpg.text.SourceModelReconcileStrategy;
import miworkplace.ui.themes.Colors;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;

public class RpgSourceViewerConfiguration
extends DefaultSourceViewerConfiguration {
    @Inject
    private IEclipseContext context;
    private SourceModelReconcileStrategy sourceModelReconcileStrategy = null;
    private Map<String, String> resolvedIncludePaths = new HashMap<String, String>();

    @PostConstruct
    public void postConstruct(IEclipseContext context) {
        IEclipseContext strategyContext = context.createChild();
        strategyContext.set("resolvedIncludePaths", this.resolvedIncludePaths);
        this.sourceModelReconcileStrategy = (SourceModelReconcileStrategy)ContextInjectionFactory.make(SourceModelReconcileStrategy.class, (IEclipseContext)strategyContext);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new DefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)ContextInjectionFactory.make(SingleLineScanner.class, (IEclipseContext)this.context));
        reconciler.setDamager((IPresentationDamager)dr, "singleComment_partition");
        reconciler.setRepairer((IPresentationRepairer)dr, "singleComment_partition");
        dr = new DefaultDamagerRepairer((ITokenScanner)ContextInjectionFactory.make(MultiLineScanner.class, (IEclipseContext)this.context));
        reconciler.setDamager((IPresentationDamager)dr, "iledocs_partition");
        reconciler.setRepairer((IPresentationRepairer)dr, "iledocs_partition");
        dr = new DefaultDamagerRepairer((ITokenScanner)new FreeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "free_partition");
        reconciler.setRepairer((IPresentationRepairer)dr, "free_partition");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        FreeCompletionProcessor completionProcessor = (FreeCompletionProcessor)ContextInjectionFactory.make(FreeCompletionProcessor.class, (IEclipseContext)this.context);
        ContentAssistant ca = new ContentAssistant();
        ca.enableColoredLabels(true);
        ca.enableAutoInsert(true);
        ca.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "free_partition");
        ca.setContentAssistProcessor((IContentAssistProcessor)ContextInjectionFactory.make(ILEDocsCompletionProcessor.class, (IEclipseContext)this.context), "iledocs_partition");
        ca.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__dftl_partition_content_type");
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        ca.setProposalSelectorForeground(Colors.instance().get(Colors.ColorDefinition.DefaultFont));
        ca.setProposalSelectorBackground(Colors.instance().get(Colors.ColorDefinition.DefaultBackground));
        return ca;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy()};
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return RPGPartitionScanner.PARTITION_TYPES;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return new MonoReconciler((IReconcilingStrategy)this.sourceModelReconcileStrategy, false);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        IEclipseContext childContext = this.context.createChild();
        childContext.set("resolvedIncludePaths", this.resolvedIncludePaths);
        return (ITextHover)ContextInjectionFactory.make(RpgTextHover.class, (IEclipseContext)childContext);
    }
}

