/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg;

import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.RecordFormat;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.LinkedList;
import java.util.List;
import miworkplace.ast.rpg.AST;
import miworkplace.ast.rpg.PositionalAbstractProgramFragment;
import miworkplace.ast.rpg.token.control.Keyword;
import miworkplace.ast.rpg.tokenizer.Line;
import miworkplace.ast.rpg.tokenizer.LineType;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.IRpgEditor;
import miworkplace.ui.editor.RemoteEditor;
import miworkplace.ui.editor.rpg.OutlineCategories;
import miworkplace.ui.editor.rpg.ast.AbstractVariable;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Constant;
import miworkplace.ui.editor.rpg.ast.ControlFlow;
import miworkplace.ui.editor.rpg.ast.ControlOption;
import miworkplace.ui.editor.rpg.ast.DataStructure;
import miworkplace.ui.editor.rpg.ast.Element;
import miworkplace.ui.editor.rpg.ast.File;
import miworkplace.ui.editor.rpg.ast.Include;
import miworkplace.ui.editor.rpg.ast.Module;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.editor.rpg.ast.Statement;
import miworkplace.ui.editor.rpg.ast.Subroutine;
import miworkplace.ui.editor.rpg.ast.Token;
import miworkplace.ui.editor.rpg.ast.Variable;
import miworkplace.ui.editor.rpg.fixed.OutlineContentProvider;
import miworkplace.ui.editor.rpg.text.DescriptionBuilder;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class RpgOutlinePage {
    @Inject
    private IEclipseContext context;
    @Inject
    private LogService logger;
    private IResourcePool imagePool;
    private DescriptionBuilder descriptionBuilder = new DescriptionBuilder();
    private String inputUri;
    private TreeViewer viewer;
    private StackLayout defaultLayout;
    private Composite noOutline;
    private Composite defaultComposite;
    private Integer pepLine;

    @Inject
    public RpgOutlinePage(Composite parent, @Named(value="e4ActivePart") MPart part, ESelectionService selectionService, IResourcePool imagePool) {
        this.imagePool = imagePool;
        final RemoteEditor editor = (RemoteEditor)part.getObject();
        this.inputUri = editor.getInputUri();
        this.defaultComposite = new Composite(parent, 0);
        this.defaultLayout = new StackLayout();
        this.defaultComposite.setLayout((Layout)this.defaultLayout);
        this.noOutline = this.buildNoOutline(this.defaultComposite);
        this.viewer = new TreeViewer(this.defaultComposite, 768);
        this.viewer.setContentProvider((IContentProvider)new VirtualContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.viewer.setComparator((ViewerComparator)new OutlineSorter());
        this.viewer.expandAll();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                if (selection.getFirstElement() == null) {
                    return;
                }
                Object element = selection.getFirstElement();
                try {
                    if (element instanceof miworkplace.ast.rpg.Procedure) {
                        ((IRpgEditor)editor).highlight(selection.getFirstElement());
                    } else if (element instanceof Element) {
                        Statement statement = ((Element)element).getFirst();
                        this.highlightLine(editor, statement);
                    } else if (element instanceof PositionalAbstractProgramFragment) {
                        PositionalAbstractProgramFragment papf = (PositionalAbstractProgramFragment)element;
                        this.highlightLine(editor, papf.getStartLine() - 1);
                    } else if (element instanceof miworkplace.ast.rpg.tokenizer.Token) {
                        miworkplace.ast.rpg.tokenizer.Token token = (miworkplace.ast.rpg.tokenizer.Token)element;
                        this.highlightLine(editor, token.getLineNumber() - 1);
                    } else if (element instanceof RecordFormat) {
                        TreePath path = selection.getPathsFor(element)[0];
                        int i = 0;
                        while (i < path.getSegmentCount()) {
                            if (path.getSegment(i) == element) {
                                File file = (File)path.getSegment(i - 1);
                                this.highlightLine(editor, file.getStatement());
                            }
                            ++i;
                        }
                    } else if (element instanceof FieldDescription) {
                        TreePath path = selection.getPathsFor(element)[0];
                        int i = 0;
                        while (i < path.getSegmentCount()) {
                            if (path.getSegment(i) == element) {
                                File file = (File)path.getSegment(i - 2);
                                this.highlightLine(editor, file.getStatement());
                            }
                            ++i;
                        }
                    } else if (OutlineCategories.PEP.equals(element)) {
                        this.highlightLine(editor, RpgOutlinePage.this.pepLine);
                    }
                }
                catch (BadLocationException e) {
                    RpgOutlinePage.this.logger.log(1, "Error on selecting element in RPG outline for " + RpgOutlinePage.this.inputUri, (Throwable)e);
                }
            }

            private void highlightLine(RemoteEditor editor2, Statement statement) throws BadLocationException {
                Token firstToken = (Token)statement.list().get(1);
                int line = firstToken.line;
                this.highlightLine(editor2, line);
            }

            private void highlightLine(RemoteEditor editor2, int line) throws BadLocationException {
                int length = editor2.getDocument().getLineLength(line);
                int lineOffset = editor2.getDocument().getLineOffset(line);
                editor2.highlightCodeRange(lineOffset, length);
            }
        });
        this.determineVisibleStackComponent();
    }

    public Integer determineProgramEntryPoint(Ast ast) {
        ControlOption co = ast.getControlOption("nomain");
        if (co != null) {
            return null;
        }
        co = ast.getControlOption("main");
        if (co != null && ast instanceof Module) {
            String mainProcedureName = co.getFirst();
            Module module = (Module)ast;
            List procedures = module.listProcedures();
            for (Procedure procedure : procedures) {
                if (!procedure.getName().equalsIgnoreCase(mainProcedureName)) continue;
                return procedure.getFirst().getFirstLine();
            }
        }
        for (Statement statement : ast.getStatements()) {
            String value = statement.getFirstToken().value.toLowerCase();
            if (value.startsWith("/") || value.startsWith("**free") || value.startsWith("dcl-") || value.startsWith("ctl-opt") || value.startsWith("end-")) continue;
            return statement.getFirstLine();
        }
        return null;
    }

    public Integer determineProgramEntryPoint(AST ast) {
        int numberLines = ast.getNumberOfLines();
        if (ast.getControlKeyword(Keyword.Keywords.NO_MAIN_PROCEDURE).length > 0) {
            return null;
        }
        int i = 1;
        while (i <= numberLines) {
            LineType lineType = ast.getLineType(i);
            if (LineType.Calculation.equals((Object)lineType)) {
                return i - 1;
            }
            if (LineType.FreeForm.equals((Object)lineType)) {
                String lineData;
                Line line = ast.getLineAt(i);
                String string = lineData = line == null || line.getData() == null ? "" : line.getData().trim();
                if (!(lineData.startsWith("/") || lineData.isEmpty() || lineData.startsWith("dcl-") || lineData.startsWith("ctl-opt") || lineData.startsWith("end-"))) {
                    return i - 1;
                }
            }
            ++i;
        }
        return null;
    }

    private Composite buildNoOutline(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.editor_rpg_outline_notavail);
        return form;
    }

    private void determineVisibleStackComponent() {
        if (this.viewer.getInput() != null) {
            this.defaultLayout.topControl = ((ITreeContentProvider)this.viewer.getContentProvider()).hasChildren(this.viewer.getInput()) ? this.viewer.getControl() : this.noOutline;
        }
        this.defaultComposite.layout(true, true);
    }

    @Inject
    @Optional
    public void notifiedAstRebuild(@UIEventTopic(value="miworkplace/editor/reconciled") Event event) {
        block8: {
            if (event.containsProperty("inputUri")) {
                String astInputUri = event.getProperty("inputUri").toString();
                String astMemberPath = event.getProperty("memberPath").toString();
                this.logger.log(4, "Receiving event for rebuilt AST for " + astMemberPath);
                if (this.viewer.getControl().isDisposed()) {
                    return;
                }
                try {
                    try {
                        this.viewer.getControl().setRedraw(false);
                        if (!this.inputUri.equals(astInputUri)) break block8;
                        TreePath[] expandedElements = this.viewer.getExpandedTreePaths();
                        boolean viewerVisible = this.viewer.getControl().isVisible();
                        Object value = event.getProperty("org.eclipse.e4.data");
                        this.viewer.setInput(value);
                        if (this.viewer == null || value == null) break block8;
                        if (viewerVisible) {
                            this.viewer.setExpandedTreePaths(expandedElements);
                            break block8;
                        }
                        this.viewer.expandToLevel((Object)OutlineCategories.Files, 1);
                        this.viewer.expandToLevel((Object)OutlineCategories.Procedures, 1);
                        this.viewer.expandToLevel((Object)OutlineCategories.Subroutines, 1);
                    }
                    catch (Exception exception) {
                        this.viewer.getControl().setRedraw(true);
                    }
                }
                finally {
                    this.viewer.getControl().setRedraw(true);
                }
            }
        }
    }

    @Inject
    @Optional
    public void notifiedRefresh(@UIEventTopic(value="miworkplace/ui/outline/refresh") Event event) {
        this.viewer.refresh();
    }

    public Control getControl() {
        return this.defaultComposite;
    }

    class OutlineLabelProvider
    extends StyledCellLabelProvider {
        OutlineLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object obj = cell.getElement();
            if (obj instanceof OutlineCategories) {
                OutlineCategories cat = (OutlineCategories)((Object)obj);
                switch (cat) {
                    case Files: {
                        cell.setText(Messages.editor_rpg_outline_files);
                        break;
                    }
                    case Includes: {
                        cell.setText(Messages.editor_rpg_outline_includes);
                        break;
                    }
                    case Prototypes: {
                        cell.setText(Messages.editor_rpg_outline_proto);
                        break;
                    }
                    case Constants: {
                        cell.setText(Messages.editor_rpg_outline_const);
                        break;
                    }
                    case Variables: {
                        cell.setText(Messages.editor_rpg_outline_vars);
                        break;
                    }
                    case Procedures: {
                        cell.setText(Messages.editor_rpg_outline_procs);
                        break;
                    }
                    case Subroutines: {
                        cell.setText(Messages.editor_rpg_outline_subs);
                        break;
                    }
                    case PEP: {
                        cell.setText(Messages.editor_rpg_outline_pep);
                        break;
                    }
                }
            } else if (obj instanceof RecordFormat) {
                cell.setText(((RecordFormat)obj).getName());
            } else if (obj instanceof Procedure) {
                this.labelProcedure(cell, (Procedure)obj);
            } else if (obj instanceof Variable) {
                this.labelVariable(cell, (Variable)obj);
            } else if (obj instanceof ControlFlow) {
                this.labelControlFlow(cell, (ControlFlow)obj);
            } else if (obj instanceof DataStructure) {
                this.labelDataStructure(cell, (DataStructure)obj);
            } else if (obj instanceof FieldDescription) {
                this.labelFieldDescription(cell, (FieldDescription)obj);
            } else {
                cell.setText(obj.toString());
            }
            cell.setImage(this.getImage(obj));
            super.update(cell);
        }

        private void labelFieldDescription(ViewerCell cell, FieldDescription fd) {
            StringBuilder sb = new StringBuilder();
            sb.append(fd.getFieldName());
            String type = RpgOutlinePage.this.descriptionBuilder.buildFieldTypeLabel(fd);
            if (type == null) {
                cell.setText(sb.toString());
            } else {
                sb.append(" : ");
                sb.append(type);
                cell.setText(sb.toString());
                StyleRange range = new StyleRange();
                range.start = fd.getFieldName().length();
                range.length = sb.length() - range.start;
                range.foreground = RpgOutlinePage.this.imagePool.getColorUnchecked("COLOR_OUTLINE_TYPE");
                LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
                styleRanges.add(range);
                cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
            }
        }

        private void labelDataStructure(ViewerCell cell, DataStructure ds) {
            Object text = ds.getName();
            if (ds.getArraySize() != null) {
                text = (String)text + " [" + ds.getArraySize() + "]";
            }
            cell.setText((String)text);
            if (((String)text).length() > ds.getName().length()) {
                StyleRange range = new StyleRange();
                range.start = ds.getName().length();
                range.length = ((String)text).length() - range.start;
                range.foreground = RpgOutlinePage.this.imagePool.getColorUnchecked("COLOR_OUTLINE_TYPE");
                LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
                styleRanges.add(range);
                cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
            }
        }

        private void labelControlFlow(ViewerCell cell, ControlFlow v) {
            String part1 = v.getStart().line + 1 + " -> ";
            String text = part1 + v.getStatement().toString();
            cell.setText(text);
            StyleRange range = new StyleRange();
            range.start = part1.length();
            range.length = text.length() - range.start;
            range.foreground = RpgOutlinePage.this.imagePool.getColorUnchecked("COLOR_OUTLINE_TYPE");
            LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
            styleRanges.add(range);
            cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
        }

        private void labelVariable(ViewerCell cell, Variable v) {
            String text = v.getName() + " : " + RpgOutlinePage.this.descriptionBuilder.buildVariableType(v);
            cell.setText(text);
            if (text.length() > v.getName().length()) {
                StyleRange range = new StyleRange();
                range.start = v.getName().length();
                range.length = text.length() - range.start;
                range.foreground = RpgOutlinePage.this.imagePool.getColorUnchecked("COLOR_OUTLINE_TYPE");
                LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
                styleRanges.add(range);
                cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
            }
        }

        private void labelProcedure(ViewerCell cell, Procedure proc) {
            Object text = proc.getName();
            cell.setText((String)text);
            if (proc.getProcedureInterface() != null && proc.getProcedureInterface().getReturnValue() != null) {
                DataStructure ds;
                Object value = proc.getProcedureInterface().getReturnValue();
                if (value instanceof Variable) {
                    text = (String)text + " : " + RpgOutlinePage.this.descriptionBuilder.buildVariableType((Variable)value);
                } else if (value instanceof DataStructure && (ds = (DataStructure)value).getLike() != null) {
                    text = (String)text + " : " + ((DataStructure)value).getLike();
                    if (ds.getArraySize() != null) {
                        text = (String)text + " [" + ds.getArraySize() + "]";
                    }
                }
                cell.setText((String)text);
                if (((String)text).length() > proc.getName().length()) {
                    StyleRange range = new StyleRange();
                    range.start = proc.getName().length();
                    range.length = ((String)text).length() - range.start;
                    range.foreground = RpgOutlinePage.this.imagePool.getColorUnchecked("COLOR_OUTLINE_TYPE");
                    LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
                    styleRanges.add(range);
                    cell.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
                }
            }
        }

        private Image getImage(Object obj) {
            if (obj instanceof miworkplace.ast.rpg.Procedure) {
                if (((miworkplace.ast.rpg.Procedure)obj).isExported()) {
                    return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROC_EXPORTED");
                }
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROC_PRIVATE");
            }
            if (obj instanceof miworkplace.ast.rpg.Prototype) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROTOTYPE");
            }
            if (obj.equals((Object)OutlineCategories.PEP)) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PEP");
            }
            if (obj.equals((Object)OutlineCategories.Prototypes)) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROTOTYPE");
            }
            if (obj.equals((Object)OutlineCategories.Procedures)) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROC_PRIVATE");
            }
            if (obj.equals((Object)OutlineCategories.Variables)) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_VARIABLE");
            }
            if (obj.equals((Object)OutlineCategories.Subroutines)) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_SUBROUTINE");
            }
            if (obj.equals((Object)OutlineCategories.Files)) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_FILE");
            }
            if (obj.equals((Object)OutlineCategories.Includes)) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_INCLUDE");
            }
            if (obj instanceof Prototype) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROTOTYPE");
            }
            if (obj instanceof Procedure) {
                if (((Procedure)obj).isExported()) {
                    return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROC_EXPORTED");
                }
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_PROC_PRIVATE");
            }
            if (obj instanceof Constant) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_CONSTANT");
            }
            if (obj instanceof Variable) {
                Boolean exported = ((Variable)obj).getExported();
                if (exported != null && exported.booleanValue()) {
                    return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_VARIABLE_EXPORTED");
                }
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_VARIABLE");
            }
            if (obj instanceof DataStructure) {
                Boolean exported = ((AbstractVariable)obj).getExported();
                if (exported != null && exported.booleanValue()) {
                    return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_DATA_STRUCTURE_EXPORTED");
                }
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_DATA_STRUCTURE");
            }
            if (obj instanceof File) {
                File file = (File)obj;
                if (file.getType() == File.Type.Workstation) {
                    return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_WORKSTATION");
                }
                if (file.getType() == File.Type.Printer) {
                    return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_PRINT");
                }
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_FILE");
            }
            if (obj instanceof RecordFormat) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_RECORDFORMAT");
            }
            if (obj instanceof FieldDescription) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_VARIABLE");
            }
            if (obj instanceof Include) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_INCLUDE");
            }
            if (obj instanceof Subroutine) {
                return RpgOutlinePage.this.imagePool.getImageUnchecked("IMAGE_OUTLINE_SUBROUTINE");
            }
            return null;
        }
    }

    class OutlineSorter
    extends ViewerComparator {
        OutlineSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Variable) {
                Variable var = (Variable)e1;
                if (((Variable)e1).getStatement() != null && !var.getStatement().toString().trim().toUpperCase().startsWith("DCL")) {
                    return 0;
                }
            }
            return super.compare(viewer, e1, e2);
        }

        public int category(Object element) {
            try {
                if (element instanceof OutlineCategories) {
                    return ((OutlineCategories)((Object)element)).ordinal();
                }
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    class VirtualContentProvider
    implements ITreeContentProvider {
        private ITreeContentProvider current;
        private final Object[] noObjects = new Object[0];

        VirtualContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                RpgOutlinePage.this.defaultLayout.topControl = RpgOutlinePage.this.noOutline;
            } else {
                if (newInput instanceof Ast) {
                    RpgOutlinePage.this.pepLine = RpgOutlinePage.this.determineProgramEntryPoint((Ast)newInput);
                    IEclipseContext outlineContext = RpgOutlinePage.this.context.createChild();
                    outlineContext.set("inputUri", (Object)RpgOutlinePage.this.inputUri);
                    outlineContext.set("pepLine", (Object)RpgOutlinePage.this.pepLine);
                    this.current = (ITreeContentProvider)ContextInjectionFactory.make(miworkplace.ui.editor.rpg.free.OutlineContentProvider.class, (IEclipseContext)outlineContext);
                } else if (newInput instanceof AST) {
                    RpgOutlinePage.this.pepLine = RpgOutlinePage.this.determineProgramEntryPoint((AST)newInput);
                    IEclipseContext outlineContext = RpgOutlinePage.this.context.createChild();
                    outlineContext.set("inputUri", (Object)RpgOutlinePage.this.inputUri);
                    outlineContext.set("pepLine", (Object)RpgOutlinePage.this.pepLine);
                    this.current = (ITreeContentProvider)ContextInjectionFactory.make(OutlineContentProvider.class, (IEclipseContext)outlineContext);
                } else {
                    this.current = null;
                }
                if (this.current != null) {
                    this.current.inputChanged(viewer, oldInput, newInput);
                    RpgOutlinePage.this.defaultLayout.topControl = this.current.getChildren(newInput).length == 0 ? RpgOutlinePage.this.noOutline : viewer.getControl();
                    RpgOutlinePage.this.defaultComposite.layout(true);
                }
            }
        }

        public Object[] getElements(Object inputElement) {
            if (this.current == null) {
                return this.noObjects;
            }
            return this.current.getElements(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (this.current == null) {
                return this.noObjects;
            }
            return this.current.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            if (this.current == null) {
                return null;
            }
            return this.current.getParent(element);
        }

        public boolean hasChildren(Object element) {
            if (this.current == null) {
                return false;
            }
            return this.current.hasChildren(element);
        }

        public void dispose() {
            if (this.current != null) {
                this.current.dispose();
            }
        }
    }
}

