/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import miworkplace.ui.editor.include.IIncludeService;
import miworkplace.ui.editor.include.IncludeData;
import miworkplace.ui.editor.rpg.ast.AbstractVariable;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Comment;
import miworkplace.ui.editor.rpg.ast.Constant;
import miworkplace.ui.editor.rpg.ast.ControlOption;
import miworkplace.ui.editor.rpg.ast.File;
import miworkplace.ui.editor.rpg.ast.Include;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.editor.rpg.ast.Statement;
import miworkplace.ui.editor.rpg.ast.Subroutine;
import miworkplace.ui.editor.rpg.ast.Token;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.osgi.service.event.Event;

public class ResolvedAst
extends Ast {
    @Inject
    @Named(value="ifsPath")
    private String ifsPath;
    @Inject
    @Named(value="connection")
    private String connectionName;
    @Inject
    private IIncludeService includeService;
    private Ast ast;
    private IncludeData[] includes;

    public ResolvedAst() {
        super(new ArrayList());
    }

    private void buildIncludeData(Ast ast) {
        ArrayList<IncludeData> includeList = new ArrayList<IncludeData>();
        for (Include include : ast.listIncludes()) {
            IncludeData includeData = this.includeService.getIncludeData(this.connectionName, this.ifsPath, include.getFileUnquoted());
            if (includeData == null || !(includeData.getAst() instanceof Ast)) continue;
            includeList.add(includeData);
        }
        this.includes = includeList.toArray(new IncludeData[includeList.size()]);
    }

    public boolean isDeclared(Object symbol) {
        if (this.ast == null) {
            return false;
        }
        boolean declared = this.ast.isDeclared(symbol);
        if (declared) {
            return true;
        }
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            declared = ((Ast)include.getAst()).isDeclared(symbol);
            if (declared) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Object getSymbol(String name) {
        if (this.ast == null) {
            return null;
        }
        Object symbol = this.ast.getSymbol(name);
        if (symbol != null) {
            return symbol;
        }
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            symbol = ((Ast)include.getAst()).getSymbol(name);
            if (symbol != null) {
                return symbol;
            }
            ++n2;
        }
        return null;
    }

    public Procedure getScope(int offset) {
        if (this.ast == null) {
            return null;
        }
        return this.ast.getScope(offset);
    }

    public List<Comment> listComments() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        ArrayList<Comment> comments = new ArrayList<Comment>();
        comments.addAll(this.ast.listComments());
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            comments.addAll(((Ast)include.getAst()).listComments());
            ++n2;
        }
        return comments;
    }

    public List<Constant> listConstants() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        ArrayList<Constant> constants = new ArrayList<Constant>();
        constants.addAll(this.ast.listConstants());
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            constants.addAll(((Ast)include.getAst()).listConstants());
            ++n2;
        }
        return constants;
    }

    public List<ControlOption> listControlOptions() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        ArrayList<ControlOption> options = new ArrayList<ControlOption>();
        options.addAll(this.ast.listControlOptions());
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            options.addAll(((Ast)include.getAst()).listControlOptions());
            ++n2;
        }
        return options;
    }

    public List<File> listFiles() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(this.ast.listFiles());
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            files.addAll(((Ast)include.getAst()).listFiles());
            ++n2;
        }
        return files;
    }

    public List<Include> listIncludes() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        ArrayList<Include> includes = new ArrayList<Include>();
        includes.addAll(this.ast.listIncludes());
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            includes.addAll(((Ast)include.getAst()).listIncludes());
            ++n2;
        }
        return includes;
    }

    public List<Prototype> listPrototypes() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        ArrayList<Prototype> prototoypes = new ArrayList<Prototype>();
        prototoypes.addAll(this.ast.listPrototypes());
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            prototoypes.addAll(((Ast)include.getAst()).listPrototypes());
            ++n2;
        }
        return prototoypes;
    }

    public List<Statement> getStatements() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        return this.ast.getStatements();
    }

    public List<Subroutine> listSubroutines() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        ArrayList<Subroutine> subroutines = new ArrayList<Subroutine>();
        subroutines.addAll(this.ast.listSubroutines());
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            subroutines.addAll(((Ast)include.getAst()).listSubroutines());
            ++n2;
        }
        return subroutines;
    }

    public List<Token> listTokens() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        return this.ast.listTokens();
    }

    public List<AbstractVariable> listVariables() {
        if (this.ast == null) {
            Collections.emptyList();
        }
        ArrayList<AbstractVariable> variables = new ArrayList<AbstractVariable>();
        variables.addAll(this.ast.listVariables());
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            variables.addAll(((Ast)include.getAst()).listVariables());
            ++n2;
        }
        return variables;
    }

    public ControlOption getControlOption(String name) {
        if (this.ast == null) {
            return null;
        }
        ControlOption option = this.ast.getControlOption(name);
        if (option != null) {
            return option;
        }
        IncludeData[] includeDataArray = this.includes;
        int n = this.includes.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeData include = includeDataArray[n2];
            option = ((Ast)include.getAst()).getControlOption(name);
            if (option != null) {
                return option;
            }
            ++n2;
        }
        return null;
    }

    public Ast getAst() {
        return this.ast;
    }

    public void setAst(Ast ast) {
        this.ast = ast;
        if (ast == null) {
            this.includes = new IncludeData[0];
        } else {
            this.buildIncludeData(ast);
        }
    }

    @Inject
    @Optional
    public void notifiedIncludeAdded(@UIEventTopic(value="miworkplace/ui/editor/include/added") Event event) {
        String includePath = event.getProperty("path").toString();
        if (this.ast != null) {
            for (Include include : this.ast.listIncludes()) {
                if (!include.getFileUnquoted().equals(includePath)) continue;
                this.buildIncludeData(this.ast);
                break;
            }
        }
    }
}

