/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.jackson.core;

import java.util.Arrays;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtil {
    private static Exception checkException(Exception exception) {
        if (exception == null) {
            return new Exception("unknown exception");
        }
        return exception;
    }

    public static JSONObject getErrorResult(String message, String method) {
        JSONObject result = new JSONObject();
        try {
            result.put("message", (Object)message);
            result.put("method", (Object)method);
            result.put("severity", (Object)"ERROR");
        }
        catch (JSONException jSONException) {}
        return result;
    }

    public static JSONObject getExceptionResult(String message, String method, Exception exception) {
        exception = JSONUtil.checkException(exception);
        JSONObject result = new JSONObject();
        try {
            result.put("message", (Object)message);
            result.put("method", (Object)method);
            result.put("severity", (Object)"ERROR");
            result.put("stacktrace", (Object)(String.valueOf(exception.getMessage()) + "\n\r" + Arrays.toString(exception.getStackTrace())));
        }
        catch (JSONException jSONException) {}
        return result;
    }

    public static JSONObject getOkResult(String message, String method) {
        JSONObject resultOK = new JSONObject();
        try {
            resultOK.put("message", (Object)message);
            resultOK.put("method", (Object)method);
            resultOK.put("severity", (Object)"OK");
        }
        catch (JSONException jSONException) {}
        return resultOK;
    }

    public static JSONObject merge(JSONObject mainNode, JSONObject updateNode) {
        Iterator fieldNames = updateNode.keys();
        while (fieldNames.hasNext()) {
            String fieldName = fieldNames.next().toString();
            try {
                mainNode.put(fieldName, updateNode.get(fieldName));
            }
            catch (JSONException jSONException) {
                return mainNode;
            }
        }
        return mainNode;
    }

    public static JSONObject signoffSuccess() {
        JSONObject result = JSONUtil.getOkResult("Signoff success", "logout");
        return result;
    }

    public static JSONObject signonError(Exception exception) {
        exception = JSONUtil.checkException(exception);
        JSONObject SignonError = new JSONObject();
        try {
            SignonError.put("message", (Object)exception.getMessage());
            SignonError.put("method", (Object)"login");
            SignonError.put("severity", (Object)"ERROR");
            SignonError.put("stacktrace", (Object)(String.valueOf(exception.getMessage()) + "\n\r" + Arrays.toString(exception.getStackTrace())));
        }
        catch (JSONException jSONException) {}
        return SignonError;
    }

    public static JSONObject signonSuccess(String sessionId) {
        JSONObject result = JSONUtil.getOkResult("Signon success", "login");
        try {
            result.put("session", (Object)sessionId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static interface KEY {
        public static final String ACCORDANCE_COUNT = "ACC_";
        public static final String APPLICATION = "APPC";
        public static final String CHANGE_DATE = "CHGD";
        public static final String CHANGE_TIME = "CHGT";
        public static final String DESCRIPTION = "SORD";
        public static final String DEVELOPMENT_EXIT_COUNT = "DEX_";
        public static final String DISABLED = "DISI";
        public static final String DISTRIBUTED_USERID = "USRI";
        public static final String ENVIRONMENT_CODE = "PDLC";
        public static final String EXPECTED_COMPLETION_DATE = "ECDT";
        public static final String EXPECTED_DEV_END_DATE = "EDDT";
        public static final String EXPECTED_NUMBER_OF_HOURS = "EPH_";
        public static final String EXPECTED_START_DATE = "ESDT";
        public static final String FIX_STATUS = "FIXS";
        public static final String FIX_TYPE = "FIXT";
        public static final String FIXNUMBER = "FIX_";
        public static final String FREE_USER_SPACE = "FREE";
        public static final String HOST = "HOST";
        public static final String INCOME_DATE = "INDT";
        public static final String INCOME_TIME = "INTM";
        public static final String MESSAGE = "message";
        public static final String METHOD = "method";
        public static final String NUMBER_OF_RATIFICATION_GRPS = "NAC_";
        public static final String PASSWORD = "password";
        public static final String PATH_CODE = "PATH";
        public static final String PRIORITY_NUMERIC = "PRIN";
        public static final String PRODUCT_ID = "product_id";
        public static final String PROGRAMMER = "PGMR";
        public static final String RATIFICATION_COUNT = "ACC_";
        public static final String REALIZED_COMPLETION_DATE = "RCDT";
        public static final String REALIZED_DEV_END_DATE = "RDDT";
        public static final String REALIZED_NUMBER_OF_HOURS = "ERH_";
        public static final String REALIZED_START_DATE = "RSDT";
        public static final String REASON_CODE = "REAC";
        public static final String REJECTED_INDICATOR = "REJI";
        public static final String RELEASE = "RLS_";
        public static final String REQUEST_TYPE = "ERRT";
        public static final String REQUESTED_COMPLETION_DATE = "WCDT";
        public static final String REQUESTNUMBER = "ERR_";
        public static final String REQUESTUMBER = "ERR_";
        public static final String RESULT = "result";
        public static final String SEQUENCE = "SEQ_";
        public static final String SESSION_KEY = "session";
        public static final String SEVERITY = "severity";
        public static final String SHORT_FIX_DESCRIPTION = "SHFD";
        public static final String SHORT_REQUEST_DESCRIPTION = "SHED";
        public static final String STACKTRACE = "stacktrace";
        public static final String TELEPHONE_NUMBER = "TEL_";
        public static final String URL_TO_ITEM = "itemurl";
        public static final String URL_TO_PRODUCT = "URL2";
        public static final String USER = "USID";
        public static final String USER_ADDRESS_DISTRIBUTION = "ADDR";
        public static final String USER2 = "USI2";
        public static final String USERNAME = "username";
        public static final String UUID = "UUID";
    }

    public static interface METHOD {
        public static final String LOGIN = "login";
        public static final String LOGOUT = "logout";
    }

    public static interface SERVICE {
        public static final String LOGINSERVICE = "loginservice";
        public static final String TASK = "taskservice";
        public static final String WORKMANAGEMENTSERVICE = "workmanagementservice";
    }

    public static interface SEVERITY {
        public static final String ERROR = "ERROR";
        public static final String INFO = "INFO";
        public static final String OK = "OK";
        public static final String WARNING = "WARNING";
    }
}

