/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.pref.validation;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.pref.api.IValidator;
import miworkplace.ui.pref.api.ValidationException;

public class StringValidator
implements IValidator {
    private List<String> values = new LinkedList<String>();

    public StringValidator() {
    }

    public StringValidator(String value) {
        this.values.add(value);
    }

    public StringValidator(Collection<String> values) {
        values.addAll(values);
    }

    public void add(String compareValue) {
        this.values.add(compareValue);
    }

    @Override
    public void validate(String value) throws ValidationException {
        if (value == null) {
            if (!this.values.contains("")) {
                throw new ValidationException(Messages.pref_val_empty);
            }
        } else if (!this.values.contains(value)) {
            if (this.values.size() == 1) {
                throw new ValidationException(String.format(Messages.pref_val_notequal, value, this.values.get(0)));
            }
            throw new ValidationException(String.format(Messages.pref_val_notinrange, value));
        }
    }
}

