/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.connection.impl;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JPing;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobDescription;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SecureAS400;
import com.remainsoftware.common.util.ServiceUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.MiWorkplaceTraceException;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.connection.impl.DefaultConnectionUtilities;
import miworkplace.i18n.Messages;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class Connection
implements IConnection,
Serializable {
    private static final long serialVersionUID = 454784982704285405L;
    private int systemVersion;
    private String name;
    private String systemName;
    private String username;
    private transient String fPassword;
    private String objectLibrary;
    private String jobDescription;
    private boolean showAllLibraries = false;
    private boolean showLibraryList = true;
    private Set<String> listedLibraries = new HashSet<String>();
    private boolean replaceUserLibraryList = false;
    private List<String> customUserLibraries = new LinkedList<String>();
    private AS400 system;
    private EventAdmin eventAdmin;
    private Debug logger = Debug.getInstance();
    private boolean fShouldBeConnected;
    private List<Job> fCommandJobs = new ArrayList<Job>();
    private boolean fSecure;

    public Connection(String name, String systemName, boolean secure) {
        this.name = name;
        this.systemName = systemName;
        this.fSecure = secure;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSystemName(String hostname) {
        this.systemName = hostname;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public synchronized void connect(String password) throws Exception {
        this.fPassword = password;
        this.internal_connect(password);
        this.fShouldBeConnected = true;
        this.setSystemVersion(Integer.valueOf(String.valueOf(this.system.getVersion()) + String.valueOf(this.system.getRelease()) + String.valueOf(this.system.getModification())));
    }

    private void internal_connect(String password) throws Exception {
        if (this.system != null) {
            this.resetConnection();
        }
        this.system = this.username == null ? (this.isSecure() ? new SecureAS400(this.systemName) : new AS400(this.systemName)) : (this.isSecure() ? new SecureAS400(this.systemName, this.username) : new AS400(this.systemName, this.username));
        if (!this.system.arePropertiesFrozen()) {
            if (this.system.getSystemName().isEmpty()) {
                this.system.setSystemName(this.getSystemName());
            }
            if (this.system.getUserId().isEmpty() || !this.system.getUserId().equals(this.username)) {
                this.system.setUserId(this.getUsername());
            }
            if (password != null) {
                this.system.setPassword(password);
            } else if (this.fPassword != null) {
                this.system.setPassword(this.fPassword);
            } else {
                throw new Exception("No password provided.");
            }
        }
        this.system.setGuiAvailable(false);
        this.initConnection();
        if (!this.system.isConnected()) {
            this.logger.warning("Connection failed", (Throwable)new MiWorkplaceTraceException());
            return;
        }
        this.logger.debug((Option)miworkplace.connection.debug.Option.connection, "Connected!");
        this.connectedHandler();
    }

    private void initConnection() {
        this.logger.traceEntry((Option)miworkplace.connection.debug.Option.connection, new Object[]{"Start initConnection"});
        try {
            this.system.connectService(2);
            for (Job job : this.fCommandJobs.subList(0, this.fCommandJobs.size())) {
                this.logger.debug((Option)miworkplace.connection.debug.Option.connection, MessageFormat.format("Ending job {0}/{1}/{2}", job.getNumber(), this.getUsername(), this.getName()));
                try {
                    job.end(0);
                }
                catch (Exception e) {
                    this.logger.debug((Option)miworkplace.connection.debug.Option.connection, "Could not end job. It could be already ended.", (Throwable)e);
                }
                this.fCommandJobs.remove(job);
            }
            this.fCommandJobs.addAll(Arrays.asList(this.system.getJobs(2)));
        }
        catch (Exception e) {
            this.logger.error((Option)miworkplace.connection.debug.Option.connection, "Connection could not be initialized. Check network connection.", (Throwable)e);
        }
        this.logger.traceExit((Option)miworkplace.connection.debug.Option.connection, (Object)"End initConnection");
    }

    private void connectedHandler() throws Exception {
        if (this.customUserLibraries != null && !this.customUserLibraries.isEmpty() || this.jobDescription != null) {
            List<String> userLibraryList = this.assembleLibraryList(this.isReplaceUserLibraryList(), this.customUserLibraries, this.getJobDescriptionLibraries(this.jobDescription));
            this.setUserLibraryList(userLibraryList);
        }
        if (this.system.isConnected()) {
            this.postEvent("miworkplace/connection/connected");
        }
    }

    private List<String> assembleLibraryList(boolean replace, List<String> customUserLibraries, List<String> jobDescriptionLibraries) throws Exception {
        ArrayList<String> libraries = new ArrayList<String>();
        if (!replace) {
            Job job = this.system.getJobs(2)[0];
            String[] userLibraryList = job.getUserLibraryList();
            libraries.addAll(Arrays.asList(userLibraryList));
        }
        if (customUserLibraries != null) {
            for (String library : customUserLibraries) {
                if (libraries.contains(library)) continue;
                libraries.add(library);
            }
        }
        if (jobDescriptionLibraries != null) {
            for (String library : jobDescriptionLibraries) {
                if (libraries.contains(library)) continue;
                libraries.add(library);
            }
        }
        return libraries;
    }

    private List<String> getJobDescriptionLibraries(String jobDescription) throws Exception {
        ArrayList<String> libraries = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)jobDescription) && this.system.isConnected()) {
            QSYSObjectPathName path;
            if (jobDescription.contains("/")) {
                String[] parts = jobDescription.split("/");
                path = new QSYSObjectPathName(parts[0], parts[1], "JOBD");
            } else {
                path = new QSYSObjectPathName("%LIBL%", jobDescription, "JOBD");
            }
            ObjectDescription objd = new ObjectDescription(this.system, path);
            if (objd.exists()) {
                JobDescription jobd = new JobDescription(this.system, path);
                String[] initialLibraryList = jobd.getInitialLibraryList();
                if (initialLibraryList != null) {
                    libraries.addAll(Arrays.asList(initialLibraryList));
                }
            } else {
                this.logger.warning(MessageFormat.format("The job description {0} does not exist and is ignored.", jobDescription), (Throwable)new MiWorkplaceTraceException());
            }
        }
        return libraries;
    }

    public boolean isConnected() {
        if (this.system == null) {
            return false;
        }
        if (this.fShouldBeConnected && !this.system.isConnected()) {
            try {
                if (this.logger.isOn((Option)miworkplace.connection.debug.Option.connection)) {
                    this.logger.debug((Option)miworkplace.connection.debug.Option.connection, "System disconnected. Trying to reconnect...", (Throwable)new MiWorkplaceTraceException());
                }
                this.internal_connect(this.fPassword);
            }
            catch (Exception e) {
                this.logger.error("System cannot be connected. " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return this.system.isConnected();
    }

    public synchronized void disconnect() throws Exception {
        this.fShouldBeConnected = false;
        this.fPassword = null;
        this.sendEvent("miworkplace/connection/disconnect");
        this.resetConnection();
        if (this.system == null || !this.system.isConnected()) {
            this.postEvent("miworkplace/connection/disconnected");
        }
    }

    private void resetConnection() {
        if (this.system != null) {
            this.system.resetAllServices();
            this.system = null;
        }
    }

    public AS400 getSystem() {
        this.isConnected();
        return this.system;
    }

    public void setPassword(String pass) {
        this.fPassword = pass;
    }

    public String toString() {
        return this.getName();
    }

    private void postEvent(String topic) {
        if (this.eventAdmin == null) {
            return;
        }
        HashMap<String, Connection> map = new HashMap<String, Connection>();
        map.put("org.eclipse.e4.data", this);
        Event event = new Event(topic, map);
        this.getEventAdmin().postEvent(event);
    }

    private void sendEvent(String topic) {
        if (this.eventAdmin == null) {
            return;
        }
        HashMap<String, Connection> map = new HashMap<String, Connection>();
        map.put("org.eclipse.e4.data", this);
        Event event = new Event(topic, map);
        this.getEventAdmin().sendEvent(event);
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public int getSystemVersion() {
        return this.systemVersion;
    }

    private void setSystemVersion(int systemVersion) {
        this.systemVersion = systemVersion;
    }

    public boolean showLibraryList() {
        return this.showLibraryList;
    }

    public void setShowLibraryList(boolean value) {
        if (value != this.showLibraryList) {
            this.showLibraryList = value;
        }
    }

    public Set<String> getListedLibraries() {
        return Collections.unmodifiableSet(this.listedLibraries);
    }

    public void setListedLibraries(Set<String> libraries) {
        if (libraries != null) {
            this.listedLibraries.clear();
            this.listedLibraries.addAll(libraries);
            this.postEvent("miworkplace/connection/libraries/changed");
        }
    }

    public void addListedLibrary(String library) {
        if (!this.listedLibraries.contains(library)) {
            this.listedLibraries.add(library);
        }
    }

    public void removeListedLibrary(String library) {
        if (this.listedLibraries.contains(library)) {
            this.listedLibraries.remove(library);
        }
    }

    public boolean showAllLibraries() {
        return this.showAllLibraries;
    }

    public void setShowAllLibraries(boolean value) {
        if (value != this.showAllLibraries) {
            this.showAllLibraries = value;
            if (this.eventAdmin != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("org.eclipse.e4.data", this);
                map.put("property", "showAllLibraries");
                Event event = new Event("miworkplace/connection/changed", map);
                this.getEventAdmin().postEvent(event);
            }
        }
    }

    public boolean isReplaceUserLibraryList() {
        return this.replaceUserLibraryList;
    }

    public void setReplaceUserLibraryList(boolean replaceUserLibraryList) {
        this.replaceUserLibraryList = replaceUserLibraryList;
    }

    public List<String> getCustomUserLibraries() {
        return this.customUserLibraries;
    }

    public void setCustomUserLibraries(List<String> customUserLibraries) {
        this.customUserLibraries = customUserLibraries;
    }

    void addLibraryToLibraryList(String library) {
        library = library.toUpperCase();
        Job[] jobs = this.getSystem().getJobs(2);
        try {
            String[] userLibraryList = jobs[0].getUserLibraryList();
            if (userLibraryList != null) {
                String[] stringArray = userLibraryList;
                int n = userLibraryList.length;
                int n2 = 0;
                while (n2 < n) {
                    String lib = stringArray[n2];
                    if (lib.equals(library)) {
                        return;
                    }
                    ++n2;
                }
            }
            this.executeRemoteCommand("ADDLIBLE " + library + " *LAST");
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Messages.conn_addlib_error, library), e);
        }
    }

    public void setUserLibraryList(List<String> libraries) throws Exception {
        if (libraries == null || libraries.isEmpty()) {
            return;
        }
        StringBuilder command = new StringBuilder("CHGLIBL LIBL(");
        for (String lib : libraries) {
            command.append(lib);
            command.append(" ");
        }
        command.append(")");
        this.executeRemoteCommand(command.toString());
    }

    private void executeRemoteCommand(String command) {
        this.getConnectionUtil().executeRemoteCommand(this, command);
    }

    private IConnectionUtilities getConnectionUtil() {
        IConnectionUtilities connectionUtilities = (IConnectionUtilities)ServiceUtils.getOSGiService(this.getClass(), IConnectionUtilities.class);
        if (connectionUtilities == null) {
            Exception e = new Exception("IConnectionUtilities Service is null, which should be impossible.");
            this.logger.error(e.getMessage(), (Throwable)e);
            return new DefaultConnectionUtilities();
        }
        return connectionUtilities;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public String getObjectLibrary() {
        return this.objectLibrary;
    }

    public void setObjectLibrary(String objectLibrary) {
        this.objectLibrary = objectLibrary;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.systemName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.systemName, other.systemName);
    }

    public synchronized boolean ping() {
        try {
            boolean ping = new AS400JPing(this.getSystemName()).ping(2);
            if (!ping) {
                this.logger.debug((Option)miworkplace.connection.debug.Option.connection, "Ping failed. Trying to reconnect.");
                this.isConnected();
                ping = new AS400JPing(this.getSystemName()).ping(2);
                if (!ping) {
                    this.logger.debug((Option)miworkplace.connection.debug.Option.connection, "Ping failed again. Check your network connection.");
                }
            }
            return ping;
        }
        catch (Exception e) {
            this.logger.debug((Option)miworkplace.connection.debug.Option.connection, "Connection keep alive failed ping.", (Throwable)e);
            return false;
        }
    }

    public boolean isSecure() {
        return this.fSecure;
    }

    public void setSecure(boolean secure) {
        this.fSecure = secure;
    }
}

