/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spinner;

import com.ibm.spinner.DateChangedEvent;
import com.ibm.spinner.DateChangedListener;
import com.ibm.spinner.TimeSpinner;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

class DateModel
implements DateChangedListener {
    private transient Vector dateChangedListeners = new Vector();
    GregorianCalendar gCalendar = new GregorianCalendar();
    DateFormat dateFormat = DateFormat.getDateInstance();
    TimeZone zone;

    public DateModel() {
        TimeZone timeZone = TimeZone.getDefault();
        this.setTimeZone(timeZone);
    }

    public synchronized void addDateChangedListener(DateChangedListener dateChangedListener) {
        this.dateChangedListeners.addElement(dateChangedListener);
    }

    public void dateChanged(DateChangedEvent dateChangedEvent) {
        int n = this.gCalendar.get(1);
        int n2 = this.gCalendar.get(2);
        int n3 = this.gCalendar.get(5);
        this.gCalendar.setTime(((TimeSpinner)dateChangedEvent.getSource()).getDate());
        this.setDateByFields(n, n2, n3);
    }

    protected void fireDateChangedEvent() {
        Vector vector;
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        this.dateFormat.format(this.gCalendar.getTime(), stringBuffer, fieldPosition);
        DateChangedEvent dateChangedEvent = new DateChangedEvent(this, 20000, stringBuffer.toString(), this.getDate(), this.getSQLDate());
        DateModel dateModel = this;
        synchronized (dateModel) {
            vector = (Vector)this.dateChangedListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((DateChangedListener)vector.elementAt(n)).dateChanged(dateChangedEvent);
            ++n;
        }
    }

    public Calendar getCalendar() {
        return this.gCalendar;
    }

    public Date getDate() {
        return this.gCalendar.getTime();
    }

    public int getFieldValue(int n) {
        return this.gCalendar.get(n);
    }

    public java.sql.Date getSQLDate() {
        Date date = this.gCalendar.getTime();
        return new java.sql.Date(date.getTime());
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public synchronized void removeDateChangedListener(DateChangedListener dateChangedListener) {
        this.dateChangedListeners.removeElement(dateChangedListener);
    }

    public void setCalendar(Calendar calendar) {
        this.gCalendar = (GregorianCalendar)calendar.clone();
        this.fireDateChangedEvent();
    }

    public void setDate(Date date) {
        this.gCalendar.setTime(date);
    }

    public void setDateByFields(int n, int n2, int n3) {
        this.gCalendar.set(n, n2, n3);
        this.gCalendar.setTime(this.gCalendar.getTime());
        this.fireDateChangedEvent();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
        ((Calendar)this.gCalendar).setTimeZone(timeZone);
        this.gCalendar.setTime(this.gCalendar.getTime());
        this.dateFormat.setTimeZone(timeZone);
    }
}

