/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import java.awt.Toolkit;
import javax.swing.JComboBox;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class TextDocument
extends PlainDocument {
    private int m_maxLength;
    private JComboBox m_comboBox;

    public TextDocument(int n) {
        this.m_maxLength = n;
        this.m_comboBox = null;
    }

    public TextDocument(int n, JComboBox jComboBox) {
        this.m_maxLength = n;
        this.m_comboBox = jComboBox;
        if (this.m_comboBox == null) {
            return;
        }
        AbstractDocument abstractDocument = (AbstractDocument)((JTextComponent)this.m_comboBox.getEditor().getEditorComponent()).getDocument();
        this.setDocumentProperties(abstractDocument.getDocumentProperties());
        try {
            this.insertString(0, abstractDocument.getText(0, abstractDocument.getLength()), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public TextDocument(int n, JTextComponent jTextComponent) {
        this.m_maxLength = n;
        if (jTextComponent == null) {
            return;
        }
        AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
        this.setDocumentProperties(abstractDocument.getDocumentProperties());
        try {
            this.insertString(0, abstractDocument.getText(0, abstractDocument.getLength()), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            return;
        }
        Segment segment = new Segment();
        this.getText(0, this.getLength(), segment);
        String string2 = segment.toString();
        string2 = string2.substring(0, n) + string + string2.substring(n, string2.length());
        string2 = string2.toUpperCase();
        if (this.m_comboBox != null) {
            int n2 = this.m_comboBox.getItemCount();
            String string3 = null;
            Object object = null;
            for (int i = 0; i < n2; ++i) {
                object = this.m_comboBox.getItemAt(i);
                string3 = object.toString();
                string3 = string3.toUpperCase();
                if (string2.length() > string3.length() || !string2.equals(string3.substring(0, string2.length()))) continue;
                super.insertString(n, string, attributeSet);
                return;
            }
        }
        if (this.getLength() + string.length() <= this.m_maxLength || this.m_maxLength == 0) {
            super.insertString(n, string, attributeSet);
            return;
        }
        if (this.getLength() < this.m_maxLength) {
            String string4 = string.substring(0, this.m_maxLength - this.getLength());
            super.insertString(n, string4, attributeSet);
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public int getMaxLength() {
        return this.m_maxLength;
    }

    public void setMaxLength(int n) {
        this.m_maxLength = n;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

