/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ShortFormatter
extends DataFormatter {
    short m_minValue;
    short m_maxValue;

    public ShortFormatter(short s, short s2) {
        this.m_minValue = s;
        this.m_maxValue = s2;
    }

    public Object parse(String string) throws IllegalUserDataException {
        String string2 = string.trim();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setParseIntegerOnly(true);
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormat.parse(string2, parsePosition);
        if (number == null || parsePosition.getIndex() < string2.length()) {
            String string3 = m_loader.getString("valueNotANumber");
            Object[] objectArray = new Object[]{string2};
            throw new IllegalUserDataException(MessageFormat.format(string3, objectArray));
        }
        Short s = new Short(number.shortValue());
        Long l = new Long(number.longValue());
        if (l < -32768L || l > 32767L || s < this.m_minValue || s > this.m_maxValue) {
            String string4 = m_loader.getString("valueOutOfRange");
            Object[] objectArray = new Object[]{string2, new Short(this.m_minValue), new Short(this.m_maxValue)};
            throw new IllegalUserDataException(MessageFormat.format(string4, objectArray));
        }
        return s;
    }

    public String format(short s) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        return numberFormat.format(s);
    }

    public String format(Object object) {
        if (object != null) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (Short.class.isAssignableFrom(object.getClass())) {
                return numberFormat.format(((Short)object).intValue());
            }
            String string = m_loader.getString("badFormatObjectType");
            Object[] objectArray = new Object[]{"ShortFormatter", new String(object.getClass().getName()), "Short"};
            String string2 = MessageFormat.format(string, objectArray);
            throw new IllegalArgumentException(string2);
        }
        throw new IllegalArgumentException(m_loader.getString("nullFormatObject"));
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

