/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.DataFormatter;
import com.ibm.as400.ui.framework.java.IllegalUserDataException;
import com.ibm.as400.ui.framework.java.TimeFormatter;

class RequiredDataFormatter
extends DataFormatter {
    protected DataFormatter m_formatter;
    protected boolean m_required = true;

    public RequiredDataFormatter(DataFormatter dataFormatter, boolean bl) {
        if (dataFormatter == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullParseArgument"));
        }
        this.m_formatter = dataFormatter;
        this.m_required = bl;
    }

    public void setFormatter(DataFormatter dataFormatter) {
        if (dataFormatter == null) {
            throw new IllegalArgumentException(SystemResourceFinder.format("nullParseArgument"));
        }
        this.m_formatter = dataFormatter;
    }

    public DataFormatter getFormatter() {
        return this.m_formatter;
    }

    public void setRequired(boolean bl) {
        this.m_required = bl;
    }

    public boolean getRequired() {
        return this.m_required;
    }

    public String format(Object object) {
        return this.m_formatter.format(object);
    }

    public Object parse(String string) throws IllegalUserDataException {
        if (string == null) {
            if (this.m_required) {
                throw new IllegalUserDataException(SystemResourceFinder.format("nullParseArgument"));
            }
            return null;
        }
        string.trim();
        if (string.length() < 1) {
            if (this.m_required) {
                throw new IllegalUserDataException(SystemResourceFinder.format("nonBlankRequired"));
            }
            return new String("");
        }
        return this.m_formatter.parse(string);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        TimeFormatter timeFormatter = new TimeFormatter();
        RequiredDataFormatter requiredDataFormatter = new RequiredDataFormatter(timeFormatter, true);
        RequiredDataFormatter requiredDataFormatter2 = new RequiredDataFormatter(timeFormatter, false);
        String[] stringArray2 = new String[4];
        boolean[] blArray = new boolean[4];
        String[] stringArray3 = new String[4];
        stringArray2[0] = "8:17 am";
        blArray[0] = true;
        stringArray3[0] = "Req=true, good value provided";
        stringArray2[1] = "8:17";
        blArray[1] = false;
        stringArray3[1] = "no am";
        stringArray2[2] = null;
        blArray[2] = false;
        stringArray3[2] = "Req=true, but field is null";
        stringArray2[3] = "";
        blArray[3] = false;
        stringArray3[3] = "Req=true, but field is empty";
        System.out.println("Testing RequiredDataFormatter set for Required:");
        for (n = 0; n < stringArray2.length; ++n) {
            if (blArray[n]) {
                System.out.println("Should be valid:" + stringArray3[n]);
            } else {
                System.out.println("Should throw exception:  " + stringArray3[n]);
            }
            try {
                object = requiredDataFormatter.parse(stringArray2[n]);
                System.out.println("   " + object + " is a valid time.");
                if (blArray[n]) continue;
                System.out.println(">>>> Warning! The previous test case succeeded! It should have thrown an exception. <<<< ");
                continue;
            }
            catch (IllegalUserDataException illegalUserDataException) {
                System.out.println("    exception: " + illegalUserDataException.getMessage());
                if (!blArray[n]) continue;
                System.out.println(">>>> Warning! The previous test case failed! It should have been valid. <<<< ");
            }
        }
        stringArray2[2] = null;
        blArray[2] = true;
        stringArray3[2] = "Req=false, field is empty";
        stringArray2[3] = "";
        blArray[3] = true;
        stringArray3[3] = "Req=false, field is empty";
        System.out.println("Testing RequiredDataFormatter set for Not required:");
        for (n = 0; n < stringArray2.length; ++n) {
            if (blArray[n]) {
                System.out.println("Should be valid:" + stringArray3[n]);
            } else {
                System.out.println("Should throw exception:  " + stringArray3[n]);
            }
            try {
                object = requiredDataFormatter2.parse(stringArray2[n]);
                System.out.println("   " + object + " is a valid time.");
                if (blArray[n]) continue;
                System.out.println(">>>> Warning! The previous test case succeeded! It should have thrown an exception. <<<< ");
                continue;
            }
            catch (IllegalUserDataException illegalUserDataException) {
                System.out.println("    exception: " + illegalUserDataException.getMessage());
                if (!blArray[n]) continue;
                System.out.println(">>>> Warning! The previous test case failed! It should have been valid. <<<< ");
            }
        }
    }
}

