/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework;

import com.ibm.as400.ui.framework.AbortException;
import com.ibm.as400.ui.framework.ChoiceDescriptor;
import com.ibm.as400.ui.framework.ColumnDescriptor;
import com.ibm.as400.ui.framework.ComponentDescriptor;
import com.ibm.as400.ui.framework.FrameworkDefaults;
import com.ibm.as400.ui.framework.HandlerTask;
import com.ibm.as400.ui.framework.ItemDescriptor;
import com.ibm.as400.ui.framework.NodeDescriptor;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.PanelDefinitionsDescriptor;
import com.ibm.as400.ui.framework.PanelDescriptor;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.PulldownDescriptor;
import com.ibm.as400.ui.framework.ResourceLoader;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.ToolBarDescriptor;
import com.ibm.as400.ui.framework.XMLDeckPaneDefinition;
import com.ibm.as400.ui.framework.XMLSAXErrorHandler;
import com.ibm.as400.ui.framework.XMLSplitPaneDefinition;
import com.ibm.as400.ui.framework.XMLTabbedPaneDefinition;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLPanelDefinition
implements Serializable,
DocumentHandler {
    private transient String m_baseName;
    private transient Locale m_locale;
    private transient String m_panelName;
    private transient ResourceBundle m_bundle;
    private transient String m_documentName;
    private transient String m_sxml = null;
    private static transient boolean m_bElementTrace = false;
    private transient PDMLSpecificationException m_pdmlException;
    private PanelDefinitionsDescriptor m_panelDefinitions = new PanelDefinitionsDescriptor();
    private PanelDescriptor m_panelDescriptor = new PanelDescriptor();
    private Vector m_componentDescriptors = new Vector();
    private Vector m_pulldownDescriptors;
    private ToolBarDescriptor m_toolBarDescriptor;
    private String m_chars = "";
    private Stack m_stack = null;
    private transient InputStream m_isPDML = null;
    static final long serialVersionUID = 5730592853909293323L;
    private boolean found = false;
    private ComponentDescriptor m_curTree;
    private boolean inButtonGroup = false;
    private ComponentDescriptor curButtonGroup;
    private boolean inSubPane = false;

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        m_bElementTrace = true;
        if (stringArray.length == 2) {
            XMLPanelDefinition xMLPanelDefinition;
            try {
                xMLPanelDefinition = new XMLPanelDefinition(stringArray[0], null, stringArray[1]);
            }
            catch (ParseException parseException) {
                parseException.reportErrors();
                return;
            }
            catch (PDMLSpecificationException pDMLSpecificationException) {
                pDMLSpecificationException.reportErrors();
                return;
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println(missingResourceException);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            xMLPanelDefinition.dump();
        } else {
            System.out.println("Arguments are: <resource bundle name> <panel name>");
        }
    }

    public static Object getParser(Object object, XMLSAXErrorHandler xMLSAXErrorHandler) throws ParseException {
        Object var2_2 = null;
        try {
            Class<?> clazz = Class.forName("org.apache.xerces.parsers.SAXParser");
            Constructor<?> constructor = clazz.getConstructor(null);
            var2_2 = constructor.newInstance(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            XMLPanelDefinition.debug("ClassNotFoundException received");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            XMLPanelDefinition.debug("NoSuchMethodException received");
        }
        catch (InstantiationException instantiationException) {
            XMLPanelDefinition.debug("InstantiationException received");
        }
        catch (IllegalAccessException illegalAccessException) {
            XMLPanelDefinition.debug("IllegalAccessException received");
        }
        catch (InvocationTargetException invocationTargetException) {
            XMLPanelDefinition.debug("InvocationTargetException received");
        }
        XMLPanelDefinition.introspectMethod(var2_2, "setFeature", new Object[]{"http://xml.org/sax/features/validation", new Boolean(true)});
        XMLPanelDefinition.introspectMethod(var2_2, "setFeature", new Object[]{"http://xml.org/sax/features/namespaces", new Boolean(false)});
        XMLPanelDefinition.introspectMethod(var2_2, "setDocumentHandler", new Object[]{object}, new Class[]{DocumentHandler.class});
        XMLPanelDefinition.introspectMethod(var2_2, "setErrorHandler", new Object[]{xMLSAXErrorHandler}, new Class[]{ErrorHandler.class});
        return var2_2;
    }

    public static void introspectMethod(Object object, String string, Object[] objectArray) throws ParseException {
        XMLPanelDefinition.debug("introspectMethod(0) -- attempting to invoke method: " + string);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] instanceof Boolean ? Boolean.TYPE : objectArray[i].getClass();
        }
        XMLPanelDefinition.introspectMethod(object, string, objectArray, classArray, null);
    }

    public static void introspectMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws ParseException {
        XMLPanelDefinition.debug("introspectMethod(3) -- attempting to invoke method: " + string);
        XMLPanelDefinition.introspectMethod(object, string, objectArray, classArray, null);
    }

    public static void introspectMethod(Object object, String string, Object[] objectArray, Class[] classArray, String string2) throws ParseException {
        XMLPanelDefinition.debug("introspectMethod(1) -- attempting to invoke method: " + string);
        for (int i = 0; i < objectArray.length; ++i) {
            XMLPanelDefinition.debug("   parm#" + i + ": " + objectArray[i]);
        }
        try {
            Method method = object.getClass().getMethod(string, classArray);
            method.invoke(object, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            XMLPanelDefinition.debug("NoSuchMethodException " + noSuchMethodException);
            throw new ParseException("NoSuchMethodException received while introspecting method: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            XMLPanelDefinition.debug("IllegalAccessException " + illegalAccessException);
            throw new ParseException("IllegalAccessException received while introspecting method: " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            XMLPanelDefinition.debug("InvocationTargetException " + invocationTargetException);
            XMLPanelDefinition.debug("TargetException " + invocationTargetException.getTargetException());
            if (invocationTargetException.getTargetException() instanceof AbortException) {
                XMLPanelDefinition.debug("In special condition for 1.4.1 jre.");
            }
            if (invocationTargetException.getTargetException() instanceof SAXException) {
                SAXException sAXException = (SAXException)invocationTargetException.getTargetException();
                Exception exception = sAXException.getException();
                if (exception != null) {
                    if (!(exception instanceof AbortException)) {
                        throw (RuntimeException)exception;
                    }
                }
                ParseException parseException = new ParseException(SystemResourceFinder.format("failedToParse", new Object[]{string2}));
                parseException.addMessage(sAXException.getMessage());
                throw parseException;
            }
            if (invocationTargetException.getTargetException() instanceof IOException) {
                IOException iOException = (IOException)invocationTargetException.getTargetException();
                throw new ParseException("InvocationTargetException(IOException) received while introspecting method: " + string);
            }
            throw new ParseException("InvocationTargetException(other) received while introspecting method: " + string);
        }
        catch (Exception exception) {
            XMLPanelDefinition.debug("Exception " + exception);
            throw new ParseException("Exception received while introspecting method: " + string);
        }
    }

    public XMLPanelDefinition(String string, Locale locale, String string2) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale = ResourceLoader.getOpNavLocale(locale);
        this.m_panelName = string2;
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = FrameworkDefaults.m_resourceMode == 1 ? (locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string)) : SystemResourceFinder.getUncachedBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLPanelDefinition(String string, Locale locale) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale = ResourceLoader.getOpNavLocale(locale);
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLPanelDefinition(String string, ResourceBundle resourceBundle, String string2, String string3, PanelDefinitionsDescriptor panelDefinitionsDescriptor) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_bundle = resourceBundle;
        this.m_panelName = string2;
        this.m_documentName = this.addLocale(this.m_baseName, panelDefinitionsDescriptor.m_localeString) + ".pdml";
        this.m_panelDefinitions = panelDefinitionsDescriptor;
        this.m_sxml = string3;
        this.parseXML(true);
    }

    public XMLPanelDefinition(String string) {
        this.m_panelName = string;
        this.m_panelDescriptor.m_name = string;
    }

    public PanelDefinitionsDescriptor getPanelDefinitions() {
        return this.m_panelDefinitions;
    }

    public PanelDescriptor getPanel() {
        return this.m_panelDescriptor;
    }

    public Vector getPanelComponents() {
        return this.m_componentDescriptors;
    }

    public void setPanelDefinitions(PanelDefinitionsDescriptor panelDefinitionsDescriptor) {
        this.m_panelDefinitions = panelDefinitionsDescriptor;
    }

    public void setPanel(PanelDescriptor panelDescriptor) {
        this.m_panelDescriptor = panelDescriptor;
    }

    public void setPanelComponents(Vector vector) {
        this.m_componentDescriptors = vector;
    }

    public Vector getPanelMenuBar() {
        return this.m_pulldownDescriptors;
    }

    public ToolBarDescriptor getPanelToolBar() {
        return this.m_toolBarDescriptor;
    }

    public void discardComponent(ComponentDescriptor componentDescriptor) {
        this.m_componentDescriptors.removeElement(componentDescriptor);
    }

    public String toString() {
        return this.getClass().getName() + "[baseName=" + this.m_baseName + ",locale=" + this.m_locale + ",panelName=" + this.m_panelName + "]";
    }

    private String addLocale(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string2.trim().length() == 0) {
            return string;
        }
        return string + "_" + string2;
    }

    public void dump() {
        System.out.println(this.m_panelDefinitions);
        System.out.println(this.m_panelDescriptor);
        Enumeration enumeration = this.m_componentDescriptors.elements();
        while (enumeration.hasMoreElements()) {
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)enumeration.nextElement();
            System.out.println(componentDescriptor);
        }
    }

    private void parseXML(boolean bl) throws MissingResourceException, IOException, ParseException {
        InputStream inputStream = SystemResourceFinder.getPDMLHeader();
        this.m_isPDML = !bl ? SystemResourceFinder.getPDMLDocument(this.m_baseName, this.m_locale) : new BufferedInputStream(new FileInputStream(this.m_sxml));
        this.m_documentName = this.m_baseName + SystemResourceFinder.getLastDocumentLocale() + ".pdml";
        XMLSAXErrorHandler xMLSAXErrorHandler = new XMLSAXErrorHandler(this.m_documentName, SystemResourceFinder.getHeaderLineCount());
        Object object = XMLPanelDefinition.getParser(this, xMLSAXErrorHandler);
        SequenceInputStream sequenceInputStream = new SequenceInputStream(inputStream, this.m_isPDML);
        InputSource inputSource = new InputSource(sequenceInputStream);
        XMLPanelDefinition.introspectMethod(object, "parse", new Object[]{inputSource}, new Class[]{inputSource.getClass()}, this.m_baseName);
        ParseException parseException = xMLSAXErrorHandler.getException();
        if (parseException != null) {
            throw parseException;
        }
    }

    private void checkMnemonic(ComponentDescriptor componentDescriptor) {
        String string = "";
        int n = componentDescriptor.m_title.indexOf(37);
        while (n != -1 && n < componentDescriptor.m_title.length() - 1) {
            if (componentDescriptor.m_title.charAt(n + 1) != '%') {
                componentDescriptor.m_mnemonic = componentDescriptor.m_title.charAt(n + 1);
                componentDescriptor.m_title = string = string + componentDescriptor.m_title.substring(0, n) + componentDescriptor.m_title.substring(n + 1);
                string = "";
                break;
            }
            if (n + 1 >= componentDescriptor.m_title.length()) break;
            string = string + componentDescriptor.m_title.substring(0, n + 1);
            componentDescriptor.m_title = componentDescriptor.m_title.substring(n + 2);
            n = componentDescriptor.m_title.indexOf(37);
        }
        if (!string.equals("")) {
            componentDescriptor.m_title = string + componentDescriptor.m_title;
        }
    }

    private String removeMnemonic(String string) {
        String string2 = "";
        int n = string.indexOf(37);
        while (n != -1 && n < string.length() - 1) {
            if (string.charAt(n + 1) != '%') {
                string = string2 = string2 + string.substring(0, n) + string.substring(n + 1);
                string2 = "";
                break;
            }
            if (n + 1 >= string.length()) break;
            string2 = string2 + string.substring(0, n + 1);
            string = string.substring(n + 2);
            n = string.indexOf(37);
        }
        if (!string2.equals("")) {
            string = string2 + string;
        }
        return string;
    }

    private void getComponents(String string, HandlerTask handlerTask) {
        String[] stringArray = this.parseCommaSeparatedList(string);
        handlerTask.setComponents(stringArray);
    }

    private String[] parseCommaSeparatedList(String string) {
        String[] stringArray;
        Vector<Object> vector = new Vector<Object>();
        int n = string.indexOf(44);
        while (n != -1) {
            stringArray = string.substring(0, n).trim();
            vector.addElement(stringArray);
            string = string.substring(n + 1).trim();
            n = string.indexOf(44);
        }
        vector.addElement(string);
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private void processError(String string) {
        if (this.m_pdmlException == null) {
            Object[] objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        this.m_pdmlException.addMessage(string);
    }

    private void processError(Throwable throwable) {
    }

    private void processError(Throwable throwable, String string) {
        Object[] objectArray;
        if (this.m_pdmlException == null) {
            objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        if (throwable instanceof NumberFormatException) {
            objectArray = new Object[]{throwable.getMessage(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("valueNotNumeric", objectArray));
        } else {
            objectArray = new Object[]{throwable.toString(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("unknownValidationError", objectArray));
        }
    }

    public void startDocument() {
        this.m_stack = new Stack();
    }

    public void endDocument() {
        if (this.m_panelDescriptor.m_name == null) {
            if (this.m_locale == null) {
                Object[] objectArray = new Object[]{this.m_panelName, this.m_baseName};
                throw new MissingResourceException(SystemResourceFinder.format("panelNotFound", objectArray), this.m_baseName, this.m_panelName);
            }
            Object[] objectArray = new Object[]{this.m_panelName, new String(this.m_baseName + "_" + this.m_locale)};
            throw new MissingResourceException(SystemResourceFinder.format("panelNotFound", objectArray), this.m_baseName + "_" + this.m_locale, this.m_panelName);
        }
        this.m_stack = null;
    }

    public void startElement(String string, AttributeList attributeList) {
        if (this.found) {
            XMLPanelDefinition.debug("startElement <" + string + ">");
        }
        if (!this.found) {
            if (string.equalsIgnoreCase("PDML")) {
                this.m_panelDefinitions.m_baseName = this.m_baseName;
                XMLPanelDefinition.debug("Base name: " + this.m_panelDefinitions.m_baseName);
                this.m_panelDefinitions.m_locale = this.m_locale;
                this.m_panelDefinitions.m_localeString = SystemResourceFinder.getLastDocumentLocale();
                XMLPanelDefinition.debug("Locale string: " + this.m_panelDefinitions.m_localeString);
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    Object[] objectArray;
                    String string2 = attributeList.getName(i);
                    String string3 = attributeList.getValue(i).trim();
                    if (string2.equalsIgnoreCase("VERSION")) {
                        this.m_panelDefinitions.m_version = string3;
                        XMLPanelDefinition.debug("Version: " + this.m_panelDefinitions.m_version);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("SOURCE")) {
                        this.m_panelDefinitions.m_source = string3.toUpperCase();
                        XMLPanelDefinition.debug("Source: " + this.m_panelDefinitions.m_source);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("BASESCREENSIZE")) continue;
                    String string4 = string3;
                    int n = string4.indexOf(120);
                    if (n == -1) {
                        XMLPanelDefinition.debug("Base Screen Size '" + string4 + "' invalid");
                        objectArray = new Object[]{string4, string2.toString()};
                        this.processError(SystemResourceFinder.format("baseScreenSizeNotValid", objectArray));
                        continue;
                    }
                    objectArray = string4.substring(0, n).trim();
                    String string5 = string4.substring(n + 1).trim();
                    try {
                        int n2 = Integer.parseInt((String)objectArray);
                        int n3 = Integer.parseInt(string5);
                        this.m_panelDefinitions.m_baseScreenSize.setSize(n2, n3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        XMLPanelDefinition.debug("Base Screen Size '" + string4 + "' invalid");
                        this.processError(numberFormatException, string2 + "= " + string3);
                        continue;
                    }
                    XMLPanelDefinition.debug("Storing base screen size: " + string4);
                }
            } else if (string.equalsIgnoreCase("PANEL")) {
                try {
                    this.getPanelDefinitions().m_eclipsePluginID = this.m_bundle.getString("@EclipsePluginID");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string6 = attributeList.getName(i);
                    String string7 = attributeList.getValue(i).trim();
                    XMLPanelDefinition.debug("        attr <" + string6 + "> value <" + string7 + ">");
                    if (string6.equalsIgnoreCase("NAME")) {
                        if (string7 == null || !string7.equals(this.m_panelName)) continue;
                        this.found = true;
                        this.m_panelDescriptor.m_name = string7;
                        this.m_stack.push(this.m_panelDescriptor);
                        continue;
                    }
                    if (!string6.equalsIgnoreCase("SCROLL")) continue;
                    this.m_panelDescriptor.m_scroll = string7.equalsIgnoreCase("yes");
                }
            }
        } else {
            if (this.inSubPane) {
                return;
            }
            if (string.equalsIgnoreCase("TITLE") || string.equalsIgnoreCase("LOCATION") || string.equalsIgnoreCase("SIZE") || string.equalsIgnoreCase("DATACLASS") || string.equalsIgnoreCase("ATTRIBUTE") || string.equalsIgnoreCase("ACTIVATE") || string.equalsIgnoreCase("BASESCREENSIZE") || string.equalsIgnoreCase("ACTION") || string.equalsIgnoreCase("DOUBLECLICK") || string.equalsIgnoreCase("STYLE") || string.equalsIgnoreCase("DEFAULTWIDTH") || string.equalsIgnoreCase("MINVALUE") || string.equalsIgnoreCase("MAXVALUE") || string.equalsIgnoreCase("MAJORTICKS") || string.equalsIgnoreCase("MINORTICKS") || string.equalsIgnoreCase("ADJUST") || string.equalsIgnoreCase("ENABLE") || string.equalsIgnoreCase("DISABLE") || string.equalsIgnoreCase("SHOW") || string.equalsIgnoreCase("HIDE") || string.equalsIgnoreCase("REFRESH") || string.equalsIgnoreCase("DISPLAY") || string.equalsIgnoreCase("MANAGERCLASS") || string.equalsIgnoreCase("FLYOVER") || string.equalsIgnoreCase("HELPALIAS") || string.equalsIgnoreCase("HELPLINK") || string.equalsIgnoreCase("ITEMLINK") || string.equalsIgnoreCase("SEPARATOR") || string.equalsIgnoreCase("RENDERER") || string.equalsIgnoreCase("EDITOR") || string.equalsIgnoreCase("MENU") || string.equalsIgnoreCase("MENUITEM") || string.equalsIgnoreCase("PAGE") || string.equalsIgnoreCase("PANE") || string.equalsIgnoreCase("EXPANDEDICON")) {
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("ICON")) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string8 = attributeList.getName(i);
                    String string9 = attributeList.getValue(i).trim();
                    if (string8.equalsIgnoreCase("POSITION")) {
                        if (!(this.m_stack.peek() instanceof ComponentDescriptor)) continue;
                        ((ComponentDescriptor)this.m_stack.peek()).m_iconPosition = string9;
                        continue;
                    }
                    if (!string8.equalsIgnoreCase("VPOSITION") || !(this.m_stack.peek() instanceof ComponentDescriptor)) continue;
                    ((ComponentDescriptor)this.m_stack.peek()).m_vIconPosition = string9;
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("FORMAT")) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    ComponentDescriptor componentDescriptor;
                    String string10 = attributeList.getName(i);
                    String string11 = attributeList.getValue(i).trim();
                    if (!string10.equalsIgnoreCase("REQUIRED")) continue;
                    if (this.m_stack.peek() instanceof ComponentDescriptor) {
                        ((ComponentDescriptor)this.m_stack.peek()).m_required = string11.equalsIgnoreCase("YES");
                        continue;
                    }
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                    componentDescriptor.m_required = string11.equalsIgnoreCase("YES");
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("SHORT")) {
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                }
                catch (ClassCastException classCastException) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                }
                componentDescriptor.m_format = "SHORT";
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string12 = attributeList.getName(i);
                    String string13 = attributeList.getValue(i).trim();
                    if (string12.equalsIgnoreCase("REQUIRED")) {
                        componentDescriptor.m_required = string13.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string12.equalsIgnoreCase("MINVALUE")) {
                        try {
                            componentDescriptor.m_shortMinValue = Short.valueOf(string13);
                        }
                        catch (NumberFormatException numberFormatException) {
                            XMLPanelDefinition.debug("Component short minvalue '" + string13 + "' invalid");
                            this.processError(numberFormatException, string12 + "= " + string13);
                        }
                        continue;
                    }
                    if (!string12.equalsIgnoreCase("MAXVALUE")) continue;
                    try {
                        componentDescriptor.m_shortMaxValue = Short.valueOf(string13);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        XMLPanelDefinition.debug("Component short maxvalue '" + string13 + "' invalid");
                        this.processError(numberFormatException, string12 + "= " + string13);
                    }
                }
                XMLPanelDefinition.debug("Storing short range: " + componentDescriptor.m_shortMinValue + " - " + componentDescriptor.m_shortMaxValue);
                if (componentDescriptor.m_shortMinValue > componentDescriptor.m_shortMaxValue) {
                    XMLPanelDefinition.debug("Component short range excludes all values");
                    Object[] objectArray = new Object[]{Short.toString(componentDescriptor.m_shortMinValue), Short.toString(componentDescriptor.m_shortMaxValue), string};
                    this.processError(SystemResourceFinder.format("minMaxReversed", objectArray));
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("INTEGER")) {
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                }
                catch (ClassCastException classCastException) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                }
                componentDescriptor.m_format = "INTEGER";
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string14 = attributeList.getName(i);
                    String string15 = attributeList.getValue(i).trim();
                    if (string14.equalsIgnoreCase("REQUIRED")) {
                        componentDescriptor.m_required = string15.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string14.equalsIgnoreCase("MINVALUE")) {
                        try {
                            componentDescriptor.m_intMinValue = Integer.valueOf(string15);
                        }
                        catch (NumberFormatException numberFormatException) {
                            XMLPanelDefinition.debug("Component short minvalue '" + string15 + "' invalid");
                            this.processError(numberFormatException, string14 + "= " + string15);
                        }
                        continue;
                    }
                    if (!string14.equalsIgnoreCase("MAXVALUE")) continue;
                    try {
                        componentDescriptor.m_intMaxValue = Integer.valueOf(string15);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        XMLPanelDefinition.debug("Component short maxvalue '" + string15 + "' invalid");
                        this.processError(numberFormatException, string14 + "= " + string15);
                    }
                }
                XMLPanelDefinition.debug("Storing integer range: " + componentDescriptor.m_intMinValue + " - " + componentDescriptor.m_intMaxValue);
                if (componentDescriptor.m_intMinValue > componentDescriptor.m_intMaxValue) {
                    XMLPanelDefinition.debug("Component short range excludes all values");
                    Object[] objectArray = new Object[]{Integer.toString(componentDescriptor.m_intMinValue), Integer.toString(componentDescriptor.m_intMaxValue), string};
                    this.processError(SystemResourceFinder.format("minMaxReversed", objectArray));
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("LONG")) {
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                }
                catch (ClassCastException classCastException) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                }
                componentDescriptor.m_format = "LONG";
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string16 = attributeList.getName(i);
                    String string17 = attributeList.getValue(i).trim();
                    if (string16.equalsIgnoreCase("REQUIRED")) {
                        componentDescriptor.m_required = string17.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string16.equalsIgnoreCase("MINVALUE")) {
                        try {
                            componentDescriptor.m_longMinValue = Long.valueOf(string17);
                        }
                        catch (NumberFormatException numberFormatException) {
                            XMLPanelDefinition.debug("Component long minvalue '" + string17 + "' invalid");
                            this.processError(numberFormatException, string16 + "= " + string17);
                        }
                        continue;
                    }
                    if (!string16.equalsIgnoreCase("MAXVALUE")) continue;
                    try {
                        componentDescriptor.m_longMaxValue = Long.valueOf(string17);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        XMLPanelDefinition.debug("Component long maxvalue '" + string17 + "' invalid");
                        this.processError(numberFormatException, string16 + "= " + string17);
                    }
                }
                XMLPanelDefinition.debug("Storing long range: " + componentDescriptor.m_longMinValue + " - " + componentDescriptor.m_longMaxValue);
                if (componentDescriptor.m_longMinValue > componentDescriptor.m_longMaxValue) {
                    XMLPanelDefinition.debug("Component long range excludes all values");
                    Object[] objectArray = new Object[]{Long.toString(componentDescriptor.m_longMinValue), Long.toString(componentDescriptor.m_longMaxValue), string};
                    this.processError(SystemResourceFinder.format("minMaxReversed", objectArray));
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("FLOAT")) {
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                }
                catch (ClassCastException classCastException) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                }
                componentDescriptor.m_format = "FLOAT";
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string18 = attributeList.getName(i);
                    String string19 = attributeList.getValue(i).trim();
                    if (string18.equalsIgnoreCase("REQUIRED")) {
                        componentDescriptor.m_required = string19.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string18.equalsIgnoreCase("MINVALUE")) {
                        try {
                            componentDescriptor.m_floatMinValue = Float.valueOf(string19).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            XMLPanelDefinition.debug("Component float minvalue '" + string19 + "' invalid");
                            this.processError(numberFormatException, string18 + "= " + string19);
                        }
                        continue;
                    }
                    if (!string18.equalsIgnoreCase("MAXVALUE")) continue;
                    try {
                        componentDescriptor.m_floatMaxValue = Float.valueOf(string19).floatValue();
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        XMLPanelDefinition.debug("Component float maxvalue '" + string19 + "' invalid");
                        this.processError(numberFormatException, string18 + "= " + string19);
                    }
                }
                XMLPanelDefinition.debug("Storing float range: " + componentDescriptor.m_floatMinValue + " - " + componentDescriptor.m_floatMaxValue);
                if (componentDescriptor.m_floatMinValue > componentDescriptor.m_floatMaxValue) {
                    XMLPanelDefinition.debug("Component float range excludes all values");
                    Object[] objectArray = new Object[]{Double.toString(componentDescriptor.m_floatMinValue), Double.toString(componentDescriptor.m_floatMaxValue), string};
                    this.processError(SystemResourceFinder.format("minMaxReversed", objectArray));
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("STRING")) {
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                }
                catch (ClassCastException classCastException) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                }
                componentDescriptor.m_format = "STRING";
                boolean bl = false;
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string20 = attributeList.getName(i);
                    String string21 = attributeList.getValue(i).trim();
                    if (string20.equalsIgnoreCase("REQUIRED")) {
                        componentDescriptor.m_required = string21.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string20.equalsIgnoreCase("MINLENGTH")) {
                        bl = true;
                        try {
                            componentDescriptor.m_minLength = Integer.parseInt(string21);
                        }
                        catch (NumberFormatException numberFormatException) {
                            XMLPanelDefinition.debug("Component string min length '" + string21 + "' invalid");
                            this.processError(numberFormatException, string20 + "= " + string21);
                        }
                        continue;
                    }
                    if (!string20.equalsIgnoreCase("MAXLENGTH")) continue;
                    bl = true;
                    try {
                        componentDescriptor.m_maxLength = Integer.parseInt(string21);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        XMLPanelDefinition.debug("Component string max length '" + string20.toString() + "' invalid");
                        this.processError(numberFormatException, string20 + "= " + string21);
                    }
                }
                XMLPanelDefinition.debug("Storing string length: " + componentDescriptor.m_minLength + "-" + componentDescriptor.m_maxLength);
                if (componentDescriptor.m_minLength > componentDescriptor.m_maxLength) {
                    XMLPanelDefinition.debug("Component string length range excludes all values");
                    Object[] objectArray = new Object[]{Integer.toString(componentDescriptor.m_minLength), Integer.toString(componentDescriptor.m_maxLength), string};
                    this.processError(SystemResourceFinder.format("minMaxLengthReversed", objectArray));
                }
                if (!bl) {
                    XMLPanelDefinition.debug("MINLENGTH or MAXLENGTH is required.");
                    Object[] objectArray = new Object[]{string};
                    this.processError(SystemResourceFinder.format("minMaxLengthMissing", objectArray));
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("PERCENT")) {
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                }
                catch (ClassCastException classCastException) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                }
                componentDescriptor.m_format = "PERCENT";
                boolean bl = false;
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string22 = attributeList.getName(i);
                    String string23 = attributeList.getValue(i).trim();
                    if (string22.equalsIgnoreCase("REQUIRED")) {
                        componentDescriptor.m_required = string23.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string22.equalsIgnoreCase("MINFRACTIONDIGITS")) {
                        try {
                            componentDescriptor.m_minFractionDigits = Integer.valueOf(string23);
                        }
                        catch (NumberFormatException numberFormatException) {
                            XMLPanelDefinition.debug("Component percent minfractiondigits '" + string23 + "' invalid");
                            this.processError(numberFormatException, string22 + "= " + string23);
                        }
                        continue;
                    }
                    if (!string22.equalsIgnoreCase("MAXVALUE")) continue;
                    try {
                        componentDescriptor.m_maxFractionDigits = Integer.valueOf(string23);
                        bl = true;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        XMLPanelDefinition.debug("Component percent maxfractiondigits '" + string23 + "' invalid");
                        this.processError(numberFormatException, string22 + "= " + string23);
                    }
                }
                if (!bl && componentDescriptor.m_minFractionDigits > componentDescriptor.m_maxFractionDigits) {
                    componentDescriptor.m_maxFractionDigits = componentDescriptor.m_minFractionDigits;
                }
                XMLPanelDefinition.debug("Storing percent fraction digits: " + componentDescriptor.m_minFractionDigits + "-" + componentDescriptor.m_maxFractionDigits);
                if (componentDescriptor.m_minFractionDigits > componentDescriptor.m_maxFractionDigits) {
                    Object[] objectArray = new Object[]{Integer.toString(componentDescriptor.m_minFractionDigits), Integer.toString(componentDescriptor.m_maxFractionDigits), string};
                    this.processError(SystemResourceFinder.format("minMaxReversed", objectArray));
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("NUMERIC")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                componentDescriptor.m_spinType = "NUMERIC";
                componentDescriptor.m_minValue = 0;
                componentDescriptor.m_maxValue = 100;
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string24 = attributeList.getName(i);
                    String string25 = attributeList.getValue(i).trim();
                    if (string24.equalsIgnoreCase("MIN")) {
                        try {
                            componentDescriptor.m_minValue = Integer.valueOf(string25);
                        }
                        catch (NumberFormatException numberFormatException) {
                            XMLPanelDefinition.debug("Component spin minvalue '" + string25 + "' invalid");
                            this.processError(numberFormatException, string24 + "= " + string25);
                        }
                        continue;
                    }
                    if (string24.equalsIgnoreCase("MAX")) {
                        try {
                            componentDescriptor.m_maxValue = Integer.valueOf(string25);
                        }
                        catch (NumberFormatException numberFormatException) {
                            XMLPanelDefinition.debug("Component spin maxvalue '" + string25 + "' invalid");
                            this.processError(numberFormatException, string24 + "= " + string25);
                        }
                        continue;
                    }
                    if (string24.equalsIgnoreCase("INITIALIZE")) {
                        try {
                            componentDescriptor.m_intInitial = Integer.valueOf(string25);
                        }
                        catch (NumberFormatException numberFormatException) {
                            XMLPanelDefinition.debug("Component spin initial value '" + string25 + "' invalid");
                            this.processError(numberFormatException, string24 + "= " + string25);
                        }
                        continue;
                    }
                    if (!string24.equalsIgnoreCase("INCREMENT")) continue;
                    try {
                        componentDescriptor.m_increment = Integer.valueOf(string25);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        XMLPanelDefinition.debug("Component spin increment '" + string25 + "' invalid");
                        this.processError(numberFormatException, string24 + "= " + string25);
                    }
                }
                XMLPanelDefinition.debug("Storing numeric spin info:  initial[" + componentDescriptor.m_intInitial + "] min[" + componentDescriptor.m_minValue + "] max[" + componentDescriptor.m_maxValue + "] increment[" + componentDescriptor.m_increment + "]");
                if (componentDescriptor.m_minValue > componentDescriptor.m_maxValue) {
                    XMLPanelDefinition.debug("Spin minimum greater than maximum");
                    Object[] objectArray = new Object[]{Integer.toString(componentDescriptor.m_minValue), Integer.toString(componentDescriptor.m_maxValue), string};
                    this.processError(SystemResourceFinder.format("minMaxReversed", objectArray));
                }
                if (componentDescriptor.m_intInitial > componentDescriptor.m_maxValue || componentDescriptor.m_intInitial < componentDescriptor.m_minValue) {
                    XMLPanelDefinition.debug("Spin initial value outside of min - max range");
                    Object[] objectArray = new Object[]{Integer.toString(componentDescriptor.m_intInitial), Integer.toString(componentDescriptor.m_minValue), Integer.toString(componentDescriptor.m_maxValue), string};
                    this.processError(SystemResourceFinder.format("initialValueOutOfRange", objectArray));
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("DATE")) {
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                }
                catch (ClassCastException classCastException) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                }
                if (componentDescriptor.m_element != null && componentDescriptor.m_element.equalsIgnoreCase("SPINNER")) {
                    componentDescriptor.m_spinType = "DATE";
                    componentDescriptor.m_incrementCaret = 1;
                    componentDescriptor.m_spinFormatStyle = 2;
                    boolean bl = false;
                    Calendar calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(1950, 0, 1, 0, 0, 0);
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.clear();
                    calendar2.set(1950, 0, 1, 0, 0, 0);
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.clear();
                    calendar3.set(2050, 11, 31, 0, 0, 0);
                    for (int i = 0; i < attributeList.getLength(); ++i) {
                        Object[] objectArray;
                        String string26 = attributeList.getName(i);
                        String string27 = attributeList.getValue(i).trim();
                        if (string26.equalsIgnoreCase("REQUIRED")) {
                            componentDescriptor.m_required = string27.equalsIgnoreCase("YES");
                            continue;
                        }
                        if (string26.equalsIgnoreCase("MINDATE")) {
                            calendar2 = this.getCalDate(calendar2, string27, string);
                            continue;
                        }
                        if (string26.equalsIgnoreCase("MAXDATE")) {
                            calendar3 = this.getCalDate(calendar3, string27, string);
                            continue;
                        }
                        if (string26.equalsIgnoreCase("INITIALIZE")) {
                            calendar = this.getCalDate(calendar, string27, string);
                            bl = true;
                            continue;
                        }
                        if (string26.equalsIgnoreCase("INCREMENTCARET")) {
                            if (string27.equalsIgnoreCase("YEAR")) {
                                componentDescriptor.m_incrementCaret = 1;
                                continue;
                            }
                            if (string27.equalsIgnoreCase("MONTH")) {
                                componentDescriptor.m_incrementCaret = 2;
                                continue;
                            }
                            if (string27.equalsIgnoreCase("DATE")) {
                                componentDescriptor.m_incrementCaret = 5;
                                continue;
                            }
                            XMLPanelDefinition.debug("Bad date spin caret value '" + string27 + "'");
                            objectArray = new Object[]{string27, string};
                            this.processError(SystemResourceFinder.format("badDateCaret", objectArray));
                            continue;
                        }
                        if (!string26.equalsIgnoreCase("STYLE")) continue;
                        if (string27.equalsIgnoreCase("SHORT")) {
                            componentDescriptor.m_spinFormatStyle = 3;
                            continue;
                        }
                        if (string27.equalsIgnoreCase("MEDIUM")) {
                            componentDescriptor.m_spinFormatStyle = 2;
                            continue;
                        }
                        if (string27.equalsIgnoreCase("LONG")) {
                            componentDescriptor.m_spinFormatStyle = 1;
                            continue;
                        }
                        if (string27.equalsIgnoreCase("FULL")) {
                            componentDescriptor.m_spinFormatStyle = 0;
                            continue;
                        }
                        XMLPanelDefinition.debug("Bad date/time style value '" + string27 + "'");
                        objectArray = new Object[]{string27, string};
                        this.processError(SystemResourceFinder.format("badDateTimeStyleFormat", objectArray));
                    }
                    if (!bl) {
                        calendar.set(1, calendar2.get(1));
                        calendar.set(2, calendar2.get(2));
                        calendar.set(5, calendar2.get(5));
                    }
                    XMLPanelDefinition.debug("Storing date spin info:  initial[" + calendar + "] min[" + calendar2 + "] max[" + calendar3 + "]");
                    this.CheckCalendar(calendar2, calendar3, calendar, 1, 2, 5, "-", string);
                    componentDescriptor.m_calInitYear = calendar.get(1);
                    componentDescriptor.m_calInitMonth = calendar.get(2);
                    componentDescriptor.m_calInitDate = calendar.get(5);
                    componentDescriptor.m_calMinYear = calendar2.get(1);
                    componentDescriptor.m_calMinMonth = calendar2.get(2);
                    componentDescriptor.m_calMinDate = calendar2.get(5);
                    componentDescriptor.m_calMaxYear = calendar3.get(1);
                    componentDescriptor.m_calMaxMonth = calendar3.get(2);
                    componentDescriptor.m_calMaxDate = calendar3.get(5);
                } else {
                    componentDescriptor.m_format = string.toUpperCase();
                    for (int i = 0; i < attributeList.getLength(); ++i) {
                        String string28 = attributeList.getName(i);
                        String string29 = attributeList.getValue(i).trim();
                        if (string28.equalsIgnoreCase("STYLE")) {
                            if (string29.equalsIgnoreCase("SHORT")) {
                                componentDescriptor.m_dateTimeStyle = 3;
                                continue;
                            }
                            if (string29.equalsIgnoreCase("MEDIUM")) {
                                componentDescriptor.m_dateTimeStyle = 2;
                                continue;
                            }
                            if (string29.equalsIgnoreCase("LONG")) {
                                componentDescriptor.m_dateTimeStyle = 1;
                                continue;
                            }
                            if (string29.equalsIgnoreCase("FULL")) {
                                componentDescriptor.m_dateTimeStyle = 0;
                                continue;
                            }
                            componentDescriptor.m_dateTimeStyle = 2;
                            continue;
                        }
                        if (!string28.equalsIgnoreCase("REQUIRED")) continue;
                        componentDescriptor.m_required = string29.equalsIgnoreCase("YES");
                        XMLPanelDefinition.debug("Storing date/time required: " + componentDescriptor.m_required);
                    }
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("TIME")) {
                ComponentDescriptor componentDescriptor = null;
                try {
                    componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                }
                catch (ClassCastException classCastException) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                }
                if (componentDescriptor.m_element != null && componentDescriptor.m_element.equalsIgnoreCase("SPINNER")) {
                    componentDescriptor.m_spinType = "TIME";
                    componentDescriptor.m_incrementCaret = 10;
                    componentDescriptor.m_spinFormatStyle = 2;
                    boolean bl = false;
                    Calendar calendar = Calendar.getInstance();
                    calendar.clear();
                    calendar.set(2000, 0, 1, 0, 0, 0);
                    Calendar calendar4 = Calendar.getInstance();
                    calendar4.clear();
                    calendar4.set(2000, 0, 1, 0, 0, 0);
                    Calendar calendar5 = Calendar.getInstance();
                    calendar5.clear();
                    calendar5.set(2000, 0, 1, 23, 59, 59);
                    for (int i = 0; i < attributeList.getLength(); ++i) {
                        Object[] objectArray;
                        String string30 = attributeList.getName(i);
                        String string31 = attributeList.getValue(i).trim();
                        if (string30.equalsIgnoreCase("REQUIRED")) {
                            componentDescriptor.m_required = string31.equalsIgnoreCase("YES");
                            continue;
                        }
                        if (string30.equalsIgnoreCase("MINTIME")) {
                            calendar4 = this.getCalTime(calendar4, string31, string);
                            continue;
                        }
                        if (string30.equalsIgnoreCase("MAXTIME")) {
                            calendar5 = this.getCalTime(calendar5, string31, string);
                            continue;
                        }
                        if (string30.equalsIgnoreCase("INITIALIZE")) {
                            calendar = this.getCalTime(calendar, string31, string);
                            bl = true;
                            continue;
                        }
                        if (string30.equalsIgnoreCase("INCREMENTCARET")) {
                            if (string31.equalsIgnoreCase("HOUR")) {
                                componentDescriptor.m_incrementCaret = 10;
                                continue;
                            }
                            if (string31.equalsIgnoreCase("MINUTE")) {
                                componentDescriptor.m_incrementCaret = 12;
                                continue;
                            }
                            if (string31.equalsIgnoreCase("SECOND")) {
                                componentDescriptor.m_incrementCaret = 13;
                                continue;
                            }
                            XMLPanelDefinition.debug("Bad date spin caret value '" + string31 + "'");
                            objectArray = new Object[]{string31, string};
                            this.processError(SystemResourceFinder.format("badTimeCaret", objectArray));
                            continue;
                        }
                        if (!string30.equalsIgnoreCase("STYLE")) continue;
                        if (string31.equalsIgnoreCase("SHORT")) {
                            componentDescriptor.m_spinFormatStyle = 3;
                            continue;
                        }
                        if (string31.equalsIgnoreCase("MEDIUM")) {
                            componentDescriptor.m_spinFormatStyle = 2;
                            continue;
                        }
                        if (string31.equalsIgnoreCase("LONG")) {
                            componentDescriptor.m_spinFormatStyle = 1;
                            continue;
                        }
                        if (string31.equalsIgnoreCase("FULL")) {
                            componentDescriptor.m_spinFormatStyle = 0;
                            continue;
                        }
                        XMLPanelDefinition.debug("Bad date/time style value '" + string31 + "'");
                        objectArray = new Object[]{string31, string};
                        this.processError(SystemResourceFinder.format("badDateTimeStyleFormat", objectArray));
                    }
                    if (!bl) {
                        calendar.set(11, calendar4.get(11));
                        calendar.set(12, calendar4.get(12));
                        calendar.set(13, calendar4.get(13));
                    }
                    XMLPanelDefinition.debug("Storing date spin info:  initial[" + calendar + "] min[" + calendar4 + "] max[" + calendar5 + "]");
                    this.CheckCalendar(calendar4, calendar5, calendar, 11, 12, 13, ":", string);
                    componentDescriptor.m_calInitHour = calendar.get(11);
                    componentDescriptor.m_calInitMinute = calendar.get(12);
                    componentDescriptor.m_calInitSecond = calendar.get(13);
                    componentDescriptor.m_calMinHour = calendar4.get(11);
                    componentDescriptor.m_calMinMinute = calendar4.get(12);
                    componentDescriptor.m_calMinSecond = calendar4.get(13);
                    componentDescriptor.m_calMaxHour = calendar5.get(11);
                    componentDescriptor.m_calMaxMinute = calendar5.get(12);
                    componentDescriptor.m_calMaxSecond = calendar5.get(13);
                } else {
                    componentDescriptor.m_format = string.toUpperCase();
                    for (int i = 0; i < attributeList.getLength(); ++i) {
                        String string32 = attributeList.getName(i);
                        String string33 = attributeList.getValue(i).trim();
                        if (string32.equalsIgnoreCase("STYLE")) {
                            if (string33.equalsIgnoreCase("SHORT")) {
                                componentDescriptor.m_dateTimeStyle = 3;
                                continue;
                            }
                            if (string33.equalsIgnoreCase("MEDIUM")) {
                                componentDescriptor.m_dateTimeStyle = 2;
                                continue;
                            }
                            if (string33.equalsIgnoreCase("LONG")) {
                                componentDescriptor.m_dateTimeStyle = 1;
                                continue;
                            }
                            if (string33.equalsIgnoreCase("FULL")) {
                                componentDescriptor.m_dateTimeStyle = 0;
                                continue;
                            }
                            componentDescriptor.m_dateTimeStyle = 2;
                            continue;
                        }
                        if (!string32.equalsIgnoreCase("REQUIRED")) continue;
                        componentDescriptor.m_required = string33.equalsIgnoreCase("YES");
                        XMLPanelDefinition.debug("Storing date/time required: " + componentDescriptor.m_required);
                    }
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("ACTIONS")) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string34 = attributeList.getName(i);
                    String string35 = attributeList.getValue(i).trim();
                    if (string34.equalsIgnoreCase("RESOURCE")) {
                        this.m_toolBarDescriptor.m_baseName = string35;
                        continue;
                    }
                    if (!string34.equalsIgnoreCase("NAME")) continue;
                    this.m_toolBarDescriptor.m_menuName = string35;
                }
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("CHOICE") || string.equalsIgnoreCase("SELECTED") || string.equalsIgnoreCase("DESELECTED")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                if (componentDescriptor.m_choiceDescriptors == null) {
                    componentDescriptor.m_choiceDescriptors = new Vector();
                }
                ChoiceDescriptor choiceDescriptor = new ChoiceDescriptor(string);
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string36 = attributeList.getName(i);
                    String string37 = attributeList.getValue(i).trim();
                    if (!string36.equalsIgnoreCase("NAME")) continue;
                    choiceDescriptor.m_name = string37;
                }
                componentDescriptor.m_choiceDescriptors.addElement(choiceDescriptor);
                this.m_stack.push(choiceDescriptor);
            } else if (string.equalsIgnoreCase("NODE")) {
                NodeDescriptor nodeDescriptor = (NodeDescriptor)this.m_stack.peek();
                if (nodeDescriptor.m_children == null) {
                    nodeDescriptor.m_children = new Vector();
                }
                NodeDescriptor nodeDescriptor2 = new NodeDescriptor();
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string38 = attributeList.getName(i);
                    String string39 = attributeList.getValue(i).trim();
                    if (!string38.equalsIgnoreCase("NAME")) continue;
                    nodeDescriptor2.m_name = string39;
                    XMLPanelDefinition.debug("Storing node name: " + nodeDescriptor2.m_name);
                    this.m_curTree.m_nodeDictionary.put(nodeDescriptor2.m_name, nodeDescriptor2);
                }
                nodeDescriptor.m_children.add(nodeDescriptor2);
                this.m_stack.push(nodeDescriptor2);
            } else if (string.equalsIgnoreCase("ROOT")) {
                this.m_curTree = (ComponentDescriptor)this.m_stack.peek();
                if (this.m_curTree.m_nodeDictionary == null) {
                    this.m_curTree.m_nodeDictionary = new Hashtable();
                }
                NodeDescriptor nodeDescriptor = new NodeDescriptor();
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string40 = attributeList.getName(i);
                    String string41 = attributeList.getValue(i).trim();
                    if (!string40.equalsIgnoreCase("NAME")) continue;
                    nodeDescriptor.m_name = string41;
                    XMLPanelDefinition.debug("Storing node name: " + nodeDescriptor.m_name);
                    this.m_curTree.m_nodeDictionary.put(nodeDescriptor.m_name, nodeDescriptor);
                }
                this.m_curTree.m_root = nodeDescriptor;
                this.m_stack.push(nodeDescriptor);
            } else if (string.equalsIgnoreCase("MENUBAR")) {
                this.m_pulldownDescriptors = new Vector();
                this.m_stack.push(string);
            } else if (string.equalsIgnoreCase("PULLDOWN")) {
                PulldownDescriptor pulldownDescriptor = new PulldownDescriptor();
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string42 = attributeList.getName(i);
                    String string43 = attributeList.getValue(i).trim();
                    if (string42.equalsIgnoreCase("RESOURCE")) {
                        pulldownDescriptor.m_baseName = string43;
                        continue;
                    }
                    if (!string42.equalsIgnoreCase("NAME")) continue;
                    pulldownDescriptor.m_menuName = string43;
                }
                XMLPanelDefinition.debug("Storing resource name: " + pulldownDescriptor.m_baseName);
                XMLPanelDefinition.debug("Storing pulldown name: " + pulldownDescriptor.m_menuName);
                this.m_pulldownDescriptors.addElement(pulldownDescriptor);
                this.m_stack.push(pulldownDescriptor);
            } else if (string.equalsIgnoreCase("TOOLBAR")) {
                this.m_toolBarDescriptor = new ToolBarDescriptor();
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string44 = attributeList.getName(i);
                    String string45 = attributeList.getValue(i).trim();
                    if (string44.equalsIgnoreCase("ORIENTATION")) {
                        this.m_toolBarDescriptor.m_orientation = string45;
                        continue;
                    }
                    if (!string44.equalsIgnoreCase("FLOATABLE")) continue;
                    this.m_toolBarDescriptor.m_floatable = string45.equalsIgnoreCase("YES");
                }
                this.m_stack.push(this.m_toolBarDescriptor);
            } else if (string.equalsIgnoreCase("ITEM")) {
                ItemDescriptor itemDescriptor = new ItemDescriptor();
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string46 = attributeList.getName(i);
                    String string47 = attributeList.getValue(i).trim();
                    if (!string46.equalsIgnoreCase("NAME")) continue;
                    itemDescriptor.m_name = string47;
                    XMLPanelDefinition.debug("Storing item name: " + itemDescriptor.m_name);
                }
                if (this.m_stack.peek() instanceof ComponentDescriptor) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                    if (componentDescriptor.m_itemDescriptors == null) {
                        componentDescriptor.m_itemDescriptors = new Vector();
                    }
                    componentDescriptor.m_itemDescriptors.addElement(itemDescriptor);
                } else if (this.m_stack.peek() instanceof ColumnDescriptor) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_stack.peek();
                    if (columnDescriptor.m_itemDescriptors == null) {
                        columnDescriptor.m_itemDescriptors = new Vector();
                    }
                    columnDescriptor.m_itemDescriptors.addElement(itemDescriptor);
                }
                this.m_stack.push(itemDescriptor);
            } else if (string.equalsIgnoreCase("COLUMN")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                ColumnDescriptor columnDescriptor = new ColumnDescriptor();
                if (componentDescriptor.m_tableColumns == null) {
                    componentDescriptor.m_tableColumns = new Vector();
                }
                componentDescriptor.m_tableColumns.addElement(columnDescriptor);
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string48 = attributeList.getName(i);
                    String string49 = attributeList.getValue(i).trim();
                    if (string48.equalsIgnoreCase("NAME")) {
                        columnDescriptor.m_name = string49;
                        XMLPanelDefinition.debug("Storing column name: " + columnDescriptor.m_name);
                        continue;
                    }
                    if (string48.equalsIgnoreCase("PRIMARY")) {
                        columnDescriptor.m_primaryColumn = string49.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string48.equalsIgnoreCase("EDITABLE")) {
                        columnDescriptor.m_editable = string49.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string48.equalsIgnoreCase("HEADERALIGNMENT")) {
                        columnDescriptor.m_headerAlignment = string49.toUpperCase();
                        continue;
                    }
                    if (string48.equalsIgnoreCase("ALIGNMENT")) {
                        columnDescriptor.m_alignment = string49.toUpperCase();
                        continue;
                    }
                    if (string48.equalsIgnoreCase("TREECOLUMN")) {
                        columnDescriptor.m_treeColumn = string49.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (string48.equalsIgnoreCase("FILL")) {
                        columnDescriptor.m_fill = string49.equalsIgnoreCase("YES");
                        continue;
                    }
                    if (!string48.equalsIgnoreCase("DATATYPE")) continue;
                    columnDescriptor.m_datatype = string49;
                }
                this.m_stack.push(columnDescriptor);
            } else if (string.equalsIgnoreCase("BUTTONGROUP")) {
                ComponentDescriptor componentDescriptor = new ComponentDescriptor(string);
                this.m_componentDescriptors.addElement(componentDescriptor);
                this.inButtonGroup = true;
                this.curButtonGroup = componentDescriptor;
                componentDescriptor.m_groupButtons = new Vector();
                this.processComponentAttributes(attributeList, componentDescriptor);
                this.m_stack.push(componentDescriptor);
            } else if (string.equalsIgnoreCase("LABEL") || string.equalsIgnoreCase("IMAGE") || string.equalsIgnoreCase("CUSTOM") || string.equalsIgnoreCase("GROUPBOX") || string.equalsIgnoreCase("RADIOBUTTON") || string.equalsIgnoreCase("CHECKBOX") || string.equalsIgnoreCase("COMBOBOX") || string.equalsIgnoreCase("TEXTFIELD") || string.equalsIgnoreCase("SPINNER") || string.equalsIgnoreCase("TEXTAREA") || string.equalsIgnoreCase("SLIDER") || string.equalsIgnoreCase("PROGRESSBAR") || string.equalsIgnoreCase("TREE") || string.equalsIgnoreCase("LIST") || string.equalsIgnoreCase("TABLE") || string.equalsIgnoreCase("BUTTON")) {
                ComponentDescriptor componentDescriptor = new ComponentDescriptor(string);
                this.m_componentDescriptors.addElement(componentDescriptor);
                this.processComponentAttributes(attributeList, componentDescriptor);
                if (this.inButtonGroup) {
                    componentDescriptor.m_group = this.curButtonGroup.m_name;
                }
                this.m_stack.push(componentDescriptor);
            } else if (string.equalsIgnoreCase("SPLITPANE")) {
                ComponentDescriptor componentDescriptor = new ComponentDescriptor(string);
                this.processComponentAttributes(attributeList, componentDescriptor);
                try {
                    componentDescriptor.m_splitPaneDefinition = this.m_sxml == null ? new XMLSplitPaneDefinition(this.m_baseName, this.m_locale, componentDescriptor.m_name) : new XMLSplitPaneDefinition(this.m_baseName, this.m_bundle, componentDescriptor.m_name, this.m_sxml, this.m_panelDefinitions);
                    componentDescriptor.m_name = componentDescriptor.m_splitPaneDefinition.getSplitPane().m_name;
                    componentDescriptor.m_position = componentDescriptor.m_splitPaneDefinition.getSplitPane().m_position;
                }
                catch (ParseException parseException) {
                    if (this.m_pdmlException == null) {
                        Object[] objectArray = new Object[]{this.m_documentName};
                        this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
                    }
                    this.m_pdmlException.addException(new PDMLSpecificationException(parseException.getMessage()));
                    XMLPanelDefinition.debug("Parse exception processing TabbedPane");
                }
                catch (IOException iOException) {
                    if (this.m_pdmlException == null) {
                        Object[] objectArray = new Object[]{this.m_documentName};
                        this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
                    }
                    this.m_pdmlException.addException(new PDMLSpecificationException(iOException.getMessage()));
                    XMLPanelDefinition.debug("IO exception processing TabbedPane");
                }
                catch (PDMLSpecificationException pDMLSpecificationException) {
                    if (this.m_pdmlException == null) {
                        Object[] objectArray = new Object[]{this.m_documentName};
                        this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
                    }
                    this.m_pdmlException.addException(pDMLSpecificationException);
                    XMLPanelDefinition.debug("Specification exception processing SplitPane");
                }
                this.m_componentDescriptors.addElement(componentDescriptor);
                this.m_stack.push(componentDescriptor);
                this.inSubPane = true;
            } else if (string.equalsIgnoreCase("DECKPANE")) {
                ComponentDescriptor componentDescriptor = new ComponentDescriptor(string);
                this.processComponentAttributes(attributeList, componentDescriptor);
                try {
                    componentDescriptor.m_deckPaneDefinition = this.m_sxml == null ? new XMLDeckPaneDefinition(this.m_baseName, this.m_locale, componentDescriptor.m_name) : new XMLDeckPaneDefinition(this.m_baseName, this.m_bundle, componentDescriptor.m_name, this.m_sxml, this.m_panelDefinitions);
                    componentDescriptor.m_name = componentDescriptor.m_deckPaneDefinition.getDeckPane().m_name;
                    componentDescriptor.m_position = componentDescriptor.m_deckPaneDefinition.getDeckPane().m_position;
                }
                catch (ParseException parseException) {
                    if (this.m_pdmlException == null) {
                        Object[] objectArray = new Object[]{this.m_documentName};
                        this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
                    }
                    this.m_pdmlException.addException(new PDMLSpecificationException(parseException.getMessage()));
                    XMLPanelDefinition.debug("Parse exception processing DeckPane");
                }
                catch (IOException iOException) {
                    if (this.m_pdmlException == null) {
                        Object[] objectArray = new Object[]{this.m_documentName};
                        this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
                    }
                    this.m_pdmlException.addException(new PDMLSpecificationException(iOException.getMessage()));
                    XMLPanelDefinition.debug("IO exception processing TabbedPane");
                }
                catch (PDMLSpecificationException pDMLSpecificationException) {
                    if (this.m_pdmlException == null) {
                        Object[] objectArray = new Object[]{this.m_documentName};
                        this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
                    }
                    this.m_pdmlException.addException(pDMLSpecificationException);
                    XMLPanelDefinition.debug("Specification exception processing DeckPane");
                }
                this.m_componentDescriptors.addElement(componentDescriptor);
                this.m_stack.push(componentDescriptor);
                this.inSubPane = true;
            } else if (string.equalsIgnoreCase("TABBEDPANE")) {
                ComponentDescriptor componentDescriptor = new ComponentDescriptor(string);
                this.processComponentAttributes(attributeList, componentDescriptor);
                try {
                    componentDescriptor.m_tabbedPaneDefinition = this.m_sxml == null ? new XMLTabbedPaneDefinition(this.m_baseName, this.m_locale, componentDescriptor.m_name) : new XMLTabbedPaneDefinition(this.m_baseName, this.m_bundle, componentDescriptor.m_name, this.m_sxml, this.m_panelDefinitions);
                    componentDescriptor.m_name = componentDescriptor.m_tabbedPaneDefinition.getTabbedPane().m_name;
                    componentDescriptor.m_position = componentDescriptor.m_tabbedPaneDefinition.getTabbedPane().m_position;
                }
                catch (ParseException parseException) {
                    if (this.m_pdmlException == null) {
                        Object[] objectArray = new Object[]{this.m_documentName};
                        this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
                    }
                    this.m_pdmlException.addException(new PDMLSpecificationException(parseException.getMessage()));
                    XMLPanelDefinition.debug("Parse exception processing TabbedPane");
                }
                catch (IOException iOException) {
                    if (this.m_pdmlException == null) {
                        Object[] objectArray = new Object[]{this.m_documentName};
                        this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
                    }
                    this.m_pdmlException.addException(new PDMLSpecificationException(iOException.getMessage()));
                    XMLPanelDefinition.debug("IO exception processing TabbedPane");
                }
                catch (PDMLSpecificationException pDMLSpecificationException) {
                    if (this.m_pdmlException == null) {
                        Object[] objectArray = new Object[]{this.m_documentName};
                        this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
                    }
                    this.m_pdmlException.addException(pDMLSpecificationException);
                    XMLPanelDefinition.debug("Specification exception processing TabbedPane");
                }
                this.m_componentDescriptors.addElement(componentDescriptor);
                this.m_stack.push(componentDescriptor);
                this.inSubPane = true;
            } else {
                this.m_stack.push(string);
                XMLPanelDefinition.debug("Invalid TagName: " + string);
            }
        }
    }

    public void endElement(String string) {
        XMLPanelDefinition.debug("  endElement <" + string + ">");
        if (!this.m_chars.equals("")) {
            this.writeChars();
            this.m_chars = "";
        }
        if (string.equalsIgnoreCase("BUTTONGROUP")) {
            this.inButtonGroup = false;
        }
        if (string.equalsIgnoreCase("TABBEDPANE") || string.equalsIgnoreCase("DECKPANE") || string.equalsIgnoreCase("SPLITPANE")) {
            this.inSubPane = false;
        }
        if (this.found && !this.inSubPane) {
            this.m_stack.pop();
            if (this.m_stack.empty()) {
                XMLPanelDefinition.debug("Throwing Abort Exception on rawName[" + string + "].");
                this.found = false;
                throw new AbortException();
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (!this.found || this.inSubPane) {
            return;
        }
        if (!(this.m_stack.peek() instanceof String)) {
            XMLPanelDefinition.debug("STRING expected on the stack");
            return;
        }
        this.m_chars = this.m_chars + new String(cArray, n, n2).trim();
    }

    private void writeChars() {
        String string = this.m_chars;
        String string2 = (String)this.m_stack.pop();
        if (!string2.equalsIgnoreCase("BASESCREENSIZE")) {
            if (string2.equalsIgnoreCase("LOCATION")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                String string3 = string;
                int n = string3.indexOf(44);
                if (n == -1) {
                    XMLPanelDefinition.debug("Component location '" + string3 + "' invalid");
                    Object[] objectArray = new Object[]{string3, componentDescriptor.m_element};
                    this.processError(SystemResourceFinder.format("locationNotValid", objectArray));
                    return;
                }
                String string4 = string3.substring(0, n).trim();
                String string5 = string3.substring(n + 1).trim();
                try {
                    int n2 = Integer.parseInt(string4);
                    int n3 = Integer.parseInt(string5);
                    componentDescriptor.m_position.setLocation(n2, n3);
                }
                catch (NumberFormatException numberFormatException) {
                    XMLPanelDefinition.debug("Component location '" + string3 + "' invalid");
                    this.processError(numberFormatException, string2 + "= " + string);
                    return;
                }
                XMLPanelDefinition.debug("Storing component location: " + string3);
            } else if (string2.equalsIgnoreCase("SIZE")) {
                String string6 = string;
                int n = string6.indexOf(44);
                if (n == -1) {
                    XMLPanelDefinition.debug("Component size '" + string6 + "' invalid");
                    Object[] objectArray = new Object[]{string6, string2};
                    this.processError(SystemResourceFinder.format("sizeNotValid", objectArray));
                    return;
                }
                String string7 = string6.substring(0, n).trim();
                String string8 = string6.substring(n + 1).trim();
                try {
                    int n4 = Integer.parseInt(string7);
                    int n5 = Integer.parseInt(string8);
                    if (this.m_stack.peek() instanceof PanelDescriptor) {
                        this.m_panelDescriptor.m_size.setSize(n4, n5);
                    } else if (this.m_stack.peek() instanceof ComponentDescriptor) {
                        ((ComponentDescriptor)this.m_stack.peek()).m_position.setSize(n4, n5);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    XMLPanelDefinition.debug("Panel size '" + string6 + "' invalid");
                    this.processError(numberFormatException, string2 + "= " + string);
                    return;
                }
                XMLPanelDefinition.debug("Storing size: " + string6);
            } else if (string2.equalsIgnoreCase("DATACLASS")) {
                if (this.m_stack.peek() instanceof ComponentDescriptor) {
                    ((ComponentDescriptor)this.m_stack.peek()).m_dataClass = string;
                    XMLPanelDefinition.debug("Storing DataClass: " + ((ComponentDescriptor)this.m_stack.peek()).m_dataClass);
                } else if (this.m_stack.peek() instanceof ColumnDescriptor) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_dataClass = string;
                    XMLPanelDefinition.debug("Storing DataClass: " + ((ColumnDescriptor)this.m_stack.peek()).m_dataClass);
                }
            } else if (string2.equalsIgnoreCase("ATTRIBUTE")) {
                if (this.m_stack.peek() instanceof ComponentDescriptor) {
                    ((ComponentDescriptor)this.m_stack.peek()).m_attribute = string;
                    XMLPanelDefinition.debug("Storing Attribute: " + ((ComponentDescriptor)this.m_stack.peek()).m_attribute);
                } else if (this.m_stack.peek() instanceof ColumnDescriptor) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_attribute = string;
                    XMLPanelDefinition.debug("Storing Attribute: " + ((ColumnDescriptor)this.m_stack.peek()).m_attribute);
                }
            } else if (string2.equalsIgnoreCase("ICON")) {
                Object e = this.m_stack.peek();
                if (e instanceof PanelDescriptor) {
                    PanelDescriptor panelDescriptor = (PanelDescriptor)e;
                    panelDescriptor.m_icon = string;
                    panelDescriptor.m_iconBundle = string;
                    try {
                        panelDescriptor.m_icon = this.m_bundle.getString(panelDescriptor.m_iconBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing panel icon: " + panelDescriptor.m_icon);
                } else if (e instanceof ComponentDescriptor) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)e;
                    componentDescriptor.m_icon = string;
                    componentDescriptor.m_iconBundle = string;
                    try {
                        componentDescriptor.m_icon = this.m_bundle.getString(componentDescriptor.m_iconBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing button icon: " + componentDescriptor.m_icon + "");
                } else if (e instanceof ItemDescriptor) {
                    ItemDescriptor itemDescriptor = (ItemDescriptor)e;
                    itemDescriptor.m_imageFile = string;
                    itemDescriptor.m_imageFileBundle = string;
                    try {
                        itemDescriptor.m_imageFile = this.m_bundle.getString(itemDescriptor.m_imageFileBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing item image file: " + itemDescriptor.m_imageFile);
                } else if (e instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)e;
                    nodeDescriptor.m_imageFile = string;
                    nodeDescriptor.m_imageFileBundle = string;
                    try {
                        nodeDescriptor.m_imageFile = this.m_bundle.getString(nodeDescriptor.m_imageFileBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing node icon: " + nodeDescriptor.m_imageFile);
                }
            } else if (string2.equalsIgnoreCase("ACTIVATE")) {
                PanelDescriptor panelDescriptor = (PanelDescriptor)this.m_stack.peek();
                panelDescriptor.m_activationHandler = string;
                XMLPanelDefinition.debug("Storing panel activation handler: " + panelDescriptor.m_activationHandler);
            } else if (string2.equalsIgnoreCase("FORMAT")) {
                ComponentDescriptor componentDescriptor = null;
                if (this.m_stack.peek() instanceof ComponentDescriptor) {
                    componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                } else if (this.m_stack.peek() instanceof ColumnDescriptor && (componentDescriptor = ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor) == null) {
                    ((ColumnDescriptor)this.m_stack.peek()).m_componentDescriptor = componentDescriptor = new ComponentDescriptor("COLUMNFORMATTER");
                }
                componentDescriptor.m_format = string;
                XMLPanelDefinition.debug("Storing component format: " + componentDescriptor.m_format);
            } else if (string2.equalsIgnoreCase("ACTION")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                componentDescriptor.m_action = string;
                XMLPanelDefinition.debug("Storing component action: " + componentDescriptor.m_action);
            } else if (string2.equalsIgnoreCase("DOUBLECLICK")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                componentDescriptor.m_doubleClick = string;
                XMLPanelDefinition.debug("Storing component double click handler: " + componentDescriptor.m_doubleClick);
            } else if (string2.equalsIgnoreCase("TITLE")) {
                Object e = this.m_stack.peek();
                if (e instanceof PanelDescriptor) {
                    PanelDescriptor panelDescriptor = (PanelDescriptor)e;
                    panelDescriptor.m_title = string;
                    panelDescriptor.m_titleBundle = string;
                    try {
                        panelDescriptor.m_title = this.m_bundle.getString(panelDescriptor.m_titleBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing panel title: " + panelDescriptor.m_title);
                } else if (e instanceof ComponentDescriptor) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)e;
                    componentDescriptor.m_title = string;
                    componentDescriptor.m_titleBundle = string;
                    try {
                        componentDescriptor.m_title = this.m_bundle.getString(componentDescriptor.m_titleBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (!(componentDescriptor.m_element.equals("LABEL") || componentDescriptor.m_element.equals("IMAGE") || componentDescriptor.m_element.equals("GROUPBOX") || componentDescriptor.m_element.equals("COMBOBOX") || componentDescriptor.m_element.equals("TEXTFIELD") || componentDescriptor.m_element.equals("TEXTAREA"))) {
                        this.checkMnemonic(componentDescriptor);
                    }
                    XMLPanelDefinition.debug("Storing component title: " + componentDescriptor.m_title + "");
                    if (componentDescriptor.m_mnemonic != '\u0000') {
                        XMLPanelDefinition.debug("Storing component mnemonic: " + componentDescriptor.m_mnemonic);
                    }
                } else if (e instanceof ChoiceDescriptor) {
                    ChoiceDescriptor choiceDescriptor = (ChoiceDescriptor)e;
                    choiceDescriptor.m_title = string;
                    choiceDescriptor.m_titleBundle = string;
                    try {
                        choiceDescriptor.m_title = this.m_bundle.getString(choiceDescriptor.m_titleBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing choice title: |" + choiceDescriptor.m_title + "|");
                } else if (e instanceof ItemDescriptor) {
                    ItemDescriptor itemDescriptor = (ItemDescriptor)e;
                    itemDescriptor.m_title = string;
                    itemDescriptor.m_titleBundle = string;
                    try {
                        itemDescriptor.m_title = this.m_bundle.getString(itemDescriptor.m_titleBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing item title: " + itemDescriptor.m_title);
                } else if (e instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)e;
                    nodeDescriptor.m_title = string;
                    nodeDescriptor.m_titleBundle = string;
                    try {
                        nodeDescriptor.m_title = this.m_bundle.getString(nodeDescriptor.m_titleBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing node title: " + nodeDescriptor.m_title);
                } else if (e instanceof ColumnDescriptor) {
                    ColumnDescriptor columnDescriptor = (ColumnDescriptor)e;
                    columnDescriptor.m_title = string;
                    columnDescriptor.m_titleBundle = string;
                    try {
                        columnDescriptor.m_title = this.m_bundle.getString(columnDescriptor.m_titleBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing column title: " + columnDescriptor.m_title);
                }
            } else if (string2.equalsIgnoreCase("STYLE")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                componentDescriptor.m_style = string;
                XMLPanelDefinition.debug("Storing component style: " + componentDescriptor.m_style);
            } else if (string2.equalsIgnoreCase("DEFAULTWIDTH")) {
                ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_stack.peek();
                try {
                    columnDescriptor.m_defaultWidth = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    XMLPanelDefinition.debug("Component default width '" + string + "' invalid");
                    this.processError(numberFormatException, string2 + "= " + string);
                }
                XMLPanelDefinition.debug("Storing default width: " + columnDescriptor.m_defaultWidth);
            } else if (string2.equalsIgnoreCase("MINVALUE")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                try {
                    componentDescriptor.m_minValue = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    XMLPanelDefinition.debug("Component min value '" + string + "' invalid");
                    this.processError(numberFormatException, string2 + "= " + string);
                }
                XMLPanelDefinition.debug("Storing component min value: " + componentDescriptor.m_minValue);
            } else if (string2.equalsIgnoreCase("MAXVALUE")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                try {
                    componentDescriptor.m_maxValue = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    XMLPanelDefinition.debug("Component max value '" + string + "' invalid");
                    this.processError(numberFormatException, string2 + "= " + string);
                }
                XMLPanelDefinition.debug("Storing component max value: " + componentDescriptor.m_maxValue);
            } else if (string2.equalsIgnoreCase("MAJORTICKS")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                try {
                    componentDescriptor.m_majorTicks = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    XMLPanelDefinition.debug("Component major ticks '" + string + "' invalid");
                    this.processError(numberFormatException, string2 + "= " + string);
                }
                XMLPanelDefinition.debug("Storing component major ticks: " + componentDescriptor.m_majorTicks);
            } else if (string2.equalsIgnoreCase("MINORTICKS")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                try {
                    componentDescriptor.m_minorTicks = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    XMLPanelDefinition.debug("Component minor ticks '" + string + "' invalid");
                    this.processError(numberFormatException, string2 + "= " + string);
                }
                XMLPanelDefinition.debug("Storing component minor ticks: " + componentDescriptor.m_minorTicks);
            } else if (string2.equalsIgnoreCase("ADJUST")) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                componentDescriptor.m_action = string;
                XMLPanelDefinition.debug("Storing component action: " + componentDescriptor.m_action);
            } else if (string2.equalsIgnoreCase("ENABLE")) {
                Object e = this.m_stack.peek();
                if (e instanceof ChoiceDescriptor) {
                    ChoiceDescriptor choiceDescriptor = (ChoiceDescriptor)e;
                    if (choiceDescriptor.m_handlerTasks == null) {
                        choiceDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(1);
                    String string9 = string;
                    XMLPanelDefinition.debug("Storing enable actions: " + string9);
                    this.getComponents(string9, handlerTask);
                    choiceDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof ItemDescriptor) {
                    ItemDescriptor itemDescriptor = (ItemDescriptor)e;
                    if (itemDescriptor.m_handlerTasks == null) {
                        itemDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(1);
                    String string10 = string;
                    XMLPanelDefinition.debug("Storing enable actions: " + string10);
                    this.getComponents(string10, handlerTask);
                    itemDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)e;
                    if (nodeDescriptor.m_handlerTasks == null) {
                        nodeDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(1);
                    String string11 = string;
                    XMLPanelDefinition.debug("Storing enable actions: " + string11);
                    this.getComponents(string11, handlerTask);
                    nodeDescriptor.m_handlerTasks.addElement(handlerTask);
                }
            } else if (string2.equalsIgnoreCase("DISABLE")) {
                Object e = this.m_stack.peek();
                if (e instanceof ChoiceDescriptor) {
                    ChoiceDescriptor choiceDescriptor = (ChoiceDescriptor)e;
                    if (choiceDescriptor.m_handlerTasks == null) {
                        choiceDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(2);
                    String string12 = string;
                    XMLPanelDefinition.debug("Storing disable actions: " + string12);
                    this.getComponents(string12, handlerTask);
                    choiceDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof ItemDescriptor) {
                    ItemDescriptor itemDescriptor = (ItemDescriptor)e;
                    if (itemDescriptor.m_handlerTasks == null) {
                        itemDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(2);
                    String string13 = string;
                    XMLPanelDefinition.debug("Storing disable actions: " + string13);
                    this.getComponents(string13, handlerTask);
                    itemDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)e;
                    if (nodeDescriptor.m_handlerTasks == null) {
                        nodeDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(2);
                    String string14 = string;
                    XMLPanelDefinition.debug("Storing disable actions: " + string14);
                    this.getComponents(string14, handlerTask);
                    nodeDescriptor.m_handlerTasks.addElement(handlerTask);
                }
            } else if (string2.equalsIgnoreCase("REFRESH")) {
                Object e = this.m_stack.peek();
                if (e instanceof ChoiceDescriptor) {
                    ChoiceDescriptor choiceDescriptor = (ChoiceDescriptor)e;
                    if (choiceDescriptor.m_handlerTasks == null) {
                        choiceDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(3);
                    String string15 = string;
                    XMLPanelDefinition.debug("Storing refresh actions: " + string15);
                    this.getComponents(string15, handlerTask);
                    choiceDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof ItemDescriptor) {
                    ItemDescriptor itemDescriptor = (ItemDescriptor)e;
                    if (itemDescriptor.m_handlerTasks == null) {
                        itemDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(3);
                    String string16 = string;
                    XMLPanelDefinition.debug("Storing refresh actions: " + string16);
                    this.getComponents(string16, handlerTask);
                    itemDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)e;
                    if (nodeDescriptor.m_handlerTasks == null) {
                        nodeDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(3);
                    String string17 = string;
                    XMLPanelDefinition.debug("Storing refresh actions: " + string17);
                    this.getComponents(string17, handlerTask);
                    nodeDescriptor.m_handlerTasks.addElement(handlerTask);
                }
            } else if (string2.equalsIgnoreCase("SHOW")) {
                Object e = this.m_stack.peek();
                if (e instanceof ChoiceDescriptor) {
                    ChoiceDescriptor choiceDescriptor = (ChoiceDescriptor)e;
                    if (choiceDescriptor.m_handlerTasks == null) {
                        choiceDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(4);
                    String string18 = string;
                    XMLPanelDefinition.debug("Storing add actions: " + string18);
                    this.getComponents(string18, handlerTask);
                    choiceDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof ItemDescriptor) {
                    ItemDescriptor itemDescriptor = (ItemDescriptor)e;
                    if (itemDescriptor.m_handlerTasks == null) {
                        itemDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(4);
                    String string19 = string;
                    XMLPanelDefinition.debug("Storing add actions: " + string19);
                    this.getComponents(string19, handlerTask);
                    itemDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)e;
                    if (nodeDescriptor.m_handlerTasks == null) {
                        nodeDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(4);
                    String string20 = string;
                    XMLPanelDefinition.debug("Storing add actions: " + string20);
                    this.getComponents(string20, handlerTask);
                    nodeDescriptor.m_handlerTasks.addElement(handlerTask);
                }
            } else if (string2.equalsIgnoreCase("HIDE")) {
                Object e = this.m_stack.peek();
                if (e instanceof ChoiceDescriptor) {
                    ChoiceDescriptor choiceDescriptor = (ChoiceDescriptor)e;
                    if (choiceDescriptor.m_handlerTasks == null) {
                        choiceDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(5);
                    String string21 = string;
                    XMLPanelDefinition.debug("Storing remove actions: " + string21);
                    this.getComponents(string21, handlerTask);
                    choiceDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof ItemDescriptor) {
                    ItemDescriptor itemDescriptor = (ItemDescriptor)e;
                    if (itemDescriptor.m_handlerTasks == null) {
                        itemDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(5);
                    String string22 = string;
                    XMLPanelDefinition.debug("Storing remove actions: " + string22);
                    this.getComponents(string22, handlerTask);
                    itemDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)e;
                    if (nodeDescriptor.m_handlerTasks == null) {
                        nodeDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(5);
                    String string23 = string;
                    XMLPanelDefinition.debug("Storing remove actions: " + string23);
                    this.getComponents(string23, handlerTask);
                    nodeDescriptor.m_handlerTasks.addElement(handlerTask);
                }
            } else if (string2.equalsIgnoreCase("DISPLAY")) {
                Object e = this.m_stack.peek();
                if (e instanceof ChoiceDescriptor) {
                    ChoiceDescriptor choiceDescriptor = (ChoiceDescriptor)e;
                    if (choiceDescriptor.m_handlerTasks == null) {
                        choiceDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(6);
                    String string24 = string;
                    XMLPanelDefinition.debug("Storing display actions: " + string24);
                    this.getComponents(string24, handlerTask);
                    choiceDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof ItemDescriptor) {
                    ItemDescriptor itemDescriptor = (ItemDescriptor)e;
                    if (itemDescriptor.m_handlerTasks == null) {
                        itemDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(6);
                    String string25 = string;
                    XMLPanelDefinition.debug("Storing display actions: " + string25);
                    this.getComponents(string25, handlerTask);
                    itemDescriptor.m_handlerTasks.addElement(handlerTask);
                } else if (e instanceof NodeDescriptor) {
                    NodeDescriptor nodeDescriptor = (NodeDescriptor)e;
                    if (nodeDescriptor.m_handlerTasks == null) {
                        nodeDescriptor.m_handlerTasks = new Vector();
                    }
                    HandlerTask handlerTask = new HandlerTask(6);
                    String string26 = string;
                    XMLPanelDefinition.debug("Storing display actions: " + string26);
                    this.getComponents(string26, handlerTask);
                    nodeDescriptor.m_handlerTasks.addElement(handlerTask);
                }
            } else if (!string2.equalsIgnoreCase("STEP")) {
                if (string2.equalsIgnoreCase("MANAGERCLASS")) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                    componentDescriptor.m_componentManager = string;
                    XMLPanelDefinition.debug("Storing custom component manager: " + componentDescriptor.m_componentManager);
                } else if (string2.equalsIgnoreCase("FLYOVER")) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                    componentDescriptor.m_flyoverText = string;
                    componentDescriptor.m_flyoverBundle = string;
                    try {
                        componentDescriptor.m_flyoverText = this.m_bundle.getString(componentDescriptor.m_flyoverBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    if (!(componentDescriptor.m_element.equals("LABEL") || componentDescriptor.m_element.equals("IMAGE") || componentDescriptor.m_element.equals("GROUPBOX") || componentDescriptor.m_element.equals("COMBOBOX") || componentDescriptor.m_element.equals("TEXTFIELD") || componentDescriptor.m_element.equals("TEXTAREA"))) {
                        componentDescriptor.m_flyoverText = this.removeMnemonic(componentDescriptor.m_flyoverText);
                    }
                    XMLPanelDefinition.debug("Storing component flyover text: " + componentDescriptor.m_flyoverText);
                } else if (string2.equalsIgnoreCase("HELPALIAS")) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                    componentDescriptor.m_aliasName = string;
                    XMLPanelDefinition.debug("Storing component alias name: " + componentDescriptor.m_aliasName);
                } else if (string2.equalsIgnoreCase("HELPLINK")) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                    componentDescriptor.m_helpLink = string;
                    componentDescriptor.m_helpLinkBundle = string;
                    try {
                        componentDescriptor.m_helpLink = this.m_bundle.getString(componentDescriptor.m_helpLinkBundle);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    XMLPanelDefinition.debug("Storing help link: " + componentDescriptor.m_helpLink);
                } else if (!string2.equalsIgnoreCase("ITEMLINK")) {
                    if (string2.equalsIgnoreCase("RENDERER")) {
                        if (this.m_stack.peek() instanceof ComponentDescriptor) {
                            ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.m_stack.peek();
                            componentDescriptor.m_renderer = string;
                            XMLPanelDefinition.debug("Storing component renderer class: " + componentDescriptor.m_renderer);
                        } else if (this.m_stack.peek() instanceof ColumnDescriptor) {
                            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_stack.peek();
                            columnDescriptor.m_cellRenderer = string;
                            XMLPanelDefinition.debug("Storing column renderer class: " + columnDescriptor.m_cellRenderer);
                        }
                    } else if (string2.equalsIgnoreCase("EDITOR")) {
                        ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_stack.peek();
                        columnDescriptor.m_cellEditor = string;
                        XMLPanelDefinition.debug("Storing column editor" + columnDescriptor.m_cellEditor);
                    } else if (string2.equalsIgnoreCase("EXPANDEDICON")) {
                        NodeDescriptor nodeDescriptor = (NodeDescriptor)this.m_stack.peek();
                        nodeDescriptor.m_expandedImageFile = string;
                        nodeDescriptor.m_expandedImageFileBundle = string;
                        try {
                            nodeDescriptor.m_expandedImageFile = this.m_bundle.getString(nodeDescriptor.m_expandedImageFileBundle);
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                        XMLPanelDefinition.debug("Storing node expanded icon: " + nodeDescriptor.m_expandedImageFile);
                    }
                }
            }
        }
        this.m_stack.push(string2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    private void processComponentAttributes(AttributeList attributeList, ComponentDescriptor componentDescriptor) {
        for (int i = 0; i < attributeList.getLength(); ++i) {
            String string = attributeList.getName(i);
            String string2 = attributeList.getValue(i).trim();
            if (string.equalsIgnoreCase("NAME")) {
                componentDescriptor.m_name = string2;
                continue;
            }
            if (string.equalsIgnoreCase("DISABLED")) {
                componentDescriptor.m_disabled = string2.equalsIgnoreCase("YES");
                continue;
            }
            if (string.equalsIgnoreCase("GROUP")) {
                componentDescriptor.m_group = string2;
                continue;
            }
            if (string.equalsIgnoreCase("EDITABLE")) {
                componentDescriptor.m_editable = string2.equalsIgnoreCase("YES");
                continue;
            }
            if (string.equalsIgnoreCase("MASKED")) {
                componentDescriptor.m_masked = string2.equalsIgnoreCase("YES");
                continue;
            }
            if (string.equalsIgnoreCase("WRAP")) {
                componentDescriptor.m_wrap = string2.equalsIgnoreCase("YES");
                continue;
            }
            if (string.equalsIgnoreCase("ORIENTATION")) {
                componentDescriptor.m_orientation = string2;
                continue;
            }
            if (string.equalsIgnoreCase("SELECTION")) {
                componentDescriptor.m_selection = string2.toUpperCase();
                continue;
            }
            if (string.equalsIgnoreCase("TREETABLE")) {
                componentDescriptor.m_treeTable = string2.equalsIgnoreCase("YES");
                continue;
            }
            XMLPanelDefinition.debug("Unknown Attribute '" + string + "' = " + string2 + " encountered");
        }
    }

    Calendar getCalDate(Calendar calendar, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-/");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        int n = 2050;
        int n2 = 11;
        int n3 = 31;
        try {
            n = Integer.valueOf(string3.trim());
            n2 = Integer.valueOf(string4.trim());
            n3 = Integer.valueOf(string5.trim());
            if (n2 > 12 || n2 < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            XMLPanelDefinition.debug("Date intepretation failed for '" + string);
            Object[] objectArray = new Object[]{string, string2};
            this.processError(SystemResourceFinder.format("badPDMLDate", objectArray));
            return calendar;
        }
        calendar.set(n, --n2, n3);
        return calendar;
    }

    Calendar getCalTime(Calendar calendar, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.valueOf(string3.trim());
            n2 = Integer.valueOf(string4.trim());
            n3 = Integer.valueOf(string5.trim());
        }
        catch (NumberFormatException numberFormatException) {
            XMLPanelDefinition.debug("Time intepretation failed for '" + string);
            Object[] objectArray = new Object[]{string, string2};
            this.processError(SystemResourceFinder.format("badPDMLTime", objectArray));
            return calendar;
        }
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        return calendar;
    }

    void CheckCalendar(Calendar calendar, Calendar calendar2, Calendar calendar3, int n, int n2, int n3, String string, String string2) {
        Object object;
        String string3;
        String string4;
        if (calendar.after(calendar2)) {
            XMLPanelDefinition.debug("Spin date minimum greater than maximum");
            string4 = calendar.get(n) + string + calendar.get(n2) + string + calendar.get(n3);
            string3 = calendar2.get(n) + string + calendar2.get(n2) + string + calendar2.get(n3);
            object = new Object[]{string4, string3, string2};
            this.processError(SystemResourceFinder.format("minMaxReversed", object));
        }
        if (calendar3.after(calendar2) || calendar3.before(calendar)) {
            XMLPanelDefinition.debug("Spin date initial value outside of min - max range");
            string4 = calendar.get(n) + string + calendar.get(n2) + string + calendar.get(n3);
            string3 = calendar2.get(n) + string + calendar2.get(n2) + string + calendar2.get(n3);
            object = calendar3.get(n) + string + calendar3.get(n2) + string + calendar3.get(n3);
            Object[] objectArray = new Object[]{string4, string3, object, string2};
            this.processError(SystemResourceFinder.format("initialValueOutOfRange", objectArray));
        }
    }

    public String getDocumentName() {
        return this.m_documentName;
    }

    public Enumeration getComponentDescriptors() {
        return this.m_componentDescriptors.elements();
    }

    private static void debug(String string) {
        if (m_bElementTrace) {
            System.out.println("XMLPanelDefinition: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

