/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework;

import com.ibm.as400.ui.framework.MessageLog;
import com.ibm.as400.ui.framework.ResourceLoader;
import com.ibm.as400.ui.framework.SystemClassLoader;
import com.ibm.as400.ui.framework.java.FileClassLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class SystemResourceFinder {
    private static ResourceLoader m_loader = new ResourceLoader();
    private static Hashtable m_classLoaders;
    private static boolean debugFlag;
    private static final Integer NOTFOUND;
    private static String m_lastBundleLocale;
    private static String m_lastDocumentLocale;
    private static Hashtable m_imageDictionary;
    private static final String m_pdmlHeaderName = "com/ibm/as400/ui/framework/pdmlHeader.xml";
    private static int m_headerLineCount;

    private SystemResourceFinder() {
    }

    public static final String format(String string) {
        return SystemResourceFinder.format(string, null);
    }

    public static final String format(String string, Object[] objectArray) {
        if (objectArray != null) {
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof Number) {
                    objectArray2[i] = objectArray[i];
                    continue;
                }
                if (objectArray[i] instanceof Date) {
                    objectArray2[i] = objectArray[i];
                    continue;
                }
                objectArray2[i] = objectArray[i].toString();
                if (objectArray2[i] != null) continue;
                objectArray2[i] = "null";
            }
            return MessageFormat.format(m_loader.getString(string), objectArray2);
        }
        return m_loader.getString(string);
    }

    public static final ResourceBundle getUncachedBundle(String string) throws MissingResourceException {
        return SystemResourceFinder.getBundle(string, null, SystemResourceFinder.getLoader());
    }

    public static final ResourceBundle getUncachedBundle(String string, Locale locale) throws MissingResourceException {
        return SystemResourceFinder.getBundle(string, locale, SystemResourceFinder.getLoader());
    }

    public static final String getLastResourceLocale() {
        return m_lastBundleLocale;
    }

    public static final InputStream getPDMLDocument(String string) throws MissingResourceException {
        return SystemResourceFinder.getPDMLDocument(string, null, SystemResourceFinder.getLoader());
    }

    public static final InputStream getPDMLDocument(String string, Locale locale) throws MissingResourceException {
        return SystemResourceFinder.getPDMLDocument(string, locale, SystemResourceFinder.getLoader());
    }

    public static final InputStream getSerializedPDMLDocument(String string) throws MissingResourceException {
        return SystemResourceFinder.getSerializedPDMLDocument(string, null, SystemResourceFinder.getLoader());
    }

    public static final InputStream getSerializedPDMLDocument(String string, Locale locale) throws MissingResourceException {
        return SystemResourceFinder.getSerializedPDMLDocument(string, locale, SystemResourceFinder.getLoader());
    }

    public static final String getLastDocumentLocale() {
        return m_lastDocumentLocale;
    }

    public static final URL getHTMLDocument(String string) throws MissingResourceException {
        return SystemResourceFinder.getHTMLDocument(string, null, SystemResourceFinder.getLoader());
    }

    public static final URL getHTMLDocument(String string, Locale locale) throws MissingResourceException {
        return SystemResourceFinder.getHTMLDocument(string, locale, SystemResourceFinder.getLoader());
    }

    public static final ImageIcon getImageResource(String string) throws MissingResourceException {
        return SystemResourceFinder.getImageResource(string, SystemResourceFinder.getLoader());
    }

    public static final InputStream getPDMLHeader() throws MissingResourceException {
        return SystemResourceFinder.getPDMLHeader(SystemResourceFinder.getLoader());
    }

    public static final int getHeaderLineCount() {
        return m_headerLineCount;
    }

    public static final void createNamespace(String string) {
        SystemResourceFinder.setLoader(string);
    }

    public static final void createNamespace(String string, ClassLoader classLoader) {
        SystemResourceFinder.setLoader(string, classLoader);
    }

    public static final void setClasspath(String string, String string2) {
        try {
            ((FileClassLoader)SystemResourceFinder.getLoader(string)).setClasspath(string2);
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("unsupportedLoaderOperation", objectArray));
        }
    }

    public static final String getClasspath(String string) {
        try {
            return ((FileClassLoader)SystemResourceFinder.getLoader(string)).getClasspath();
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("unsupportedLoaderOperation", objectArray));
        }
    }

    public static final void addPath(String string, String string2) {
        try {
            ((FileClassLoader)SystemResourceFinder.getLoader(string)).addPath(string2);
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("unsupportedLoaderOperation", objectArray));
        }
    }

    public static final boolean removePath(String string, String string2) {
        try {
            return ((FileClassLoader)SystemResourceFinder.getLoader(string)).removePath(string2);
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("unsupportedLoaderOperation", objectArray));
        }
    }

    public static final Class loadClass(String string, String string2) throws ClassNotFoundException {
        return SystemResourceFinder.getLoader(string).loadClass(string2);
    }

    public static final URL getResource(String string, String string2) {
        return SystemResourceFinder.getLoader(string).getResource(string2);
    }

    public static final InputStream getResourceAsStream(String string, String string2) {
        return SystemResourceFinder.getLoader(string).getResourceAsStream(string2);
    }

    public static final InputStream getPDMLDocument(String string, String string2) throws MissingResourceException {
        return SystemResourceFinder.getPDMLDocument(string2, null, SystemResourceFinder.getLoader(string));
    }

    public static final InputStream getPDMLDocument(String string, String string2, Locale locale) throws MissingResourceException {
        return SystemResourceFinder.getPDMLDocument(string2, locale, SystemResourceFinder.getLoader(string));
    }

    public static final InputStream getSerializedPDMLDocument(String string, String string2) throws MissingResourceException {
        return SystemResourceFinder.getSerializedPDMLDocument(string2, null, SystemResourceFinder.getLoader(string));
    }

    public static final InputStream getSerializedPDMLDocument(String string, String string2, Locale locale) throws MissingResourceException {
        return SystemResourceFinder.getSerializedPDMLDocument(string2, locale, SystemResourceFinder.getLoader(string));
    }

    public static final URL getHTMLDocument(String string, String string2) throws MissingResourceException {
        return SystemResourceFinder.getHTMLDocument(string2, null, SystemResourceFinder.getLoader(string));
    }

    public static final URL getHTMLDocument(String string, String string2, Locale locale) throws MissingResourceException {
        return SystemResourceFinder.getHTMLDocument(string2, locale, SystemResourceFinder.getLoader(string));
    }

    public static final ImageIcon getImageResource(String string, String string2) throws MissingResourceException {
        return SystemResourceFinder.getImageResource(string2, SystemResourceFinder.getLoader(string));
    }

    public static final void flushImages() {
        Enumeration enumeration = m_imageDictionary.elements();
        while (enumeration.hasMoreElements()) {
            ImageIcon imageIcon = (ImageIcon)enumeration.nextElement();
            imageIcon.getImage().flush();
        }
        m_imageDictionary.clear();
    }

    public static final void flushImage(ImageIcon imageIcon) {
        Enumeration enumeration = m_imageDictionary.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ImageIcon imageIcon2 = (ImageIcon)m_imageDictionary.get(string);
            if (!imageIcon2.equals(imageIcon)) continue;
            SystemResourceFinder.debug("SystemResourceFinder: Flushing image " + imageIcon2);
            m_imageDictionary.remove(string);
            imageIcon2.getImage().flush();
            break;
        }
    }

    private static ClassLoader getLoader(String string) {
        if (string == null) {
            return SystemResourceFinder.getLoader();
        }
        if (m_classLoaders == null) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("loaderNotFound", objectArray));
        }
        ClassLoader classLoader = (ClassLoader)m_classLoaders.get(string);
        if (classLoader == null) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(SystemResourceFinder.format("loaderNotFound", objectArray));
        }
        return classLoader;
    }

    private static void setLoader(String string) {
        FileClassLoader fileClassLoader = new FileClassLoader();
        SystemResourceFinder.setLoader(string, fileClassLoader);
    }

    private static void setLoader(String string, ClassLoader classLoader) {
        if (m_classLoaders == null) {
            m_classLoaders = new Hashtable();
        }
        m_classLoaders.put(string, classLoader);
    }

    private static ClassLoader getLoader() {
        SystemResourceFinder.debug("SecurityManager=" + System.getSecurityManager());
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.as400.ui.framework.SystemResourceFinder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageLog.logError(SystemResourceFinder.format("noClassObject"));
        }
        ClassLoader classLoader = null;
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                classLoader = new SystemClassLoader();
            }
        } else {
            classLoader = new SystemClassLoader();
        }
        SystemResourceFinder.debug("getLoader returning " + classLoader);
        return classLoader;
    }

    private static synchronized ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        ResourceBundle resourceBundle;
        Locale locale2 = locale != null ? locale : Locale.getDefault();
        StringBuffer stringBuffer = new StringBuffer("_").append(locale2.toString());
        if (locale2.toString().equals("")) {
            stringBuffer.setLength(0);
        }
        if ((resourceBundle = SystemResourceFinder.findBundle(string, stringBuffer, classLoader, false)) == null) {
            if (locale != null) {
                Object[] objectArray = new Object[]{new String(string + "_" + locale2)};
                throw new MissingResourceException(SystemResourceFinder.format("resourceNotFound", objectArray), string + "_" + locale2, "");
            }
            stringBuffer.setLength(0);
            stringBuffer.append("_").append(Locale.getDefault().toString());
            resourceBundle = SystemResourceFinder.findBundle(string, stringBuffer, classLoader, true);
            if (resourceBundle == null) {
                Object[] objectArray = new Object[]{new String(string + "_" + locale2)};
                throw new MissingResourceException(SystemResourceFinder.format("resourceNotFound", objectArray), string + "_" + locale2, "");
            }
        }
        return resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle findBundle(String string, StringBuffer stringBuffer, ClassLoader classLoader, boolean bl) {
        String string2 = stringBuffer.toString();
        String string3 = string.replace('.', '/');
        PropertyResourceBundle propertyResourceBundle = null;
        InputStream inputStream = null;
        m_lastBundleLocale = null;
        while (true) {
            String string4 = string + string2;
            SystemResourceFinder.debug("Searching for " + string4);
            try {
                propertyResourceBundle = (PropertyResourceBundle)classLoader.loadClass(string4).newInstance();
            }
            catch (Exception exception) {
                int n;
                string4 = string3 + string2 + ".properties";
                SystemResourceFinder.debug("Searching for " + string4);
                inputStream = classLoader.getResourceAsStream(string4);
                if (inputStream != null) {
                    inputStream = new BufferedInputStream(inputStream);
                    try {
                        propertyResourceBundle = new PropertyResourceBundle(inputStream);
                        break;
                    }
                    catch (Exception exception2) {
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if ((n = string2.lastIndexOf(95)) == 0 && !bl || n == -1) break;
                string2 = string2.substring(0, n);
                stringBuffer.setLength(n);
                continue;
            }
            break;
        }
        if (propertyResourceBundle == NOTFOUND || propertyResourceBundle == null) {
            return null;
        }
        m_lastBundleLocale = string2;
        return propertyResourceBundle;
    }

    private static synchronized InputStream getPDMLDocument(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        Object[] objectArray;
        BufferedInputStream bufferedInputStream = null;
        String string2 = string.replace('.', '/');
        Locale locale2 = locale != null ? locale : Locale.getDefault();
        String string3 = "_" + locale2.toString();
        m_lastDocumentLocale = null;
        while (true) {
            objectArray = string2 + string3 + ".pdml";
            SystemResourceFinder.debug("Searching for PDML document " + (String)objectArray);
            InputStream inputStream = classLoader.getResourceAsStream((String)objectArray);
            if (inputStream != null) {
                bufferedInputStream = new BufferedInputStream(inputStream);
                m_lastDocumentLocale = string3;
                return bufferedInputStream;
            }
            int n = string3.lastIndexOf(95);
            if (n == 0 && locale != null || n == -1) break;
            string3 = string3.substring(0, n);
        }
        objectArray = new Object[]{new String(string + "_" + locale2)};
        throw new MissingResourceException(SystemResourceFinder.format("pdmlNotFound", objectArray), string + "_" + locale2, "");
    }

    private static synchronized InputStream getSerializedPDMLDocument(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        Object[] objectArray;
        BufferedInputStream bufferedInputStream = null;
        String string2 = string.replace('.', '/');
        Locale locale2 = locale != null ? locale : Locale.getDefault();
        String string3 = "_" + locale2.toString();
        m_lastDocumentLocale = null;
        while (true) {
            objectArray = string2 + string3 + ".pdml.ser";
            SystemResourceFinder.debug("Searching for serialized PDML document " + (String)objectArray);
            InputStream inputStream = classLoader.getResourceAsStream((String)objectArray);
            if (inputStream != null) {
                bufferedInputStream = new BufferedInputStream(inputStream);
                m_lastDocumentLocale = string3;
                return bufferedInputStream;
            }
            int n = string3.lastIndexOf(95);
            if (n == 0 && locale != null || n == -1) break;
            string3 = string3.substring(0, n);
        }
        objectArray = new Object[]{new String(string + "_" + locale2)};
        throw new MissingResourceException(SystemResourceFinder.format("serializedPdmlNotFound", objectArray), string + "_" + locale2, "");
    }

    private static synchronized URL getHTMLDocument(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        Object[] objectArray;
        Object object;
        URL uRL = null;
        String string2 = string;
        int n = string.indexOf(47);
        if (n >= 0) {
            object = string.substring(0, n);
            string2 = ((String)object).replace('.', '/') + string.substring(n);
        }
        object = locale != null ? locale : Locale.getDefault();
        String string3 = "_" + ((Locale)object).toString();
        while (true) {
            objectArray = string2 + string3 + ".html";
            SystemResourceFinder.debug("Searching for HTML document " + (String)objectArray);
            uRL = classLoader.getResource((String)objectArray);
            if (uRL != null) {
                return uRL;
            }
            int n2 = string3.lastIndexOf(95);
            if (n2 == -1) break;
            if (n2 == 0) {
                string3 = "";
                continue;
            }
            string3 = string3.substring(0, n2);
        }
        objectArray = new Object[]{new String(string + "_" + object)};
        throw new MissingResourceException(SystemResourceFinder.format("htmlNotFound", objectArray), string + "_" + object, "");
    }

    private static synchronized InputStream getPDMLHeader(ClassLoader classLoader) throws MissingResourceException {
        InputStream inputStream = classLoader.getResourceAsStream(m_pdmlHeaderName);
        if (inputStream == null) {
            Object[] objectArray = new Object[]{m_pdmlHeaderName};
            throw new MissingResourceException(SystemResourceFinder.format("pdmlHeaderNotFound", objectArray), m_pdmlHeaderName, "");
        }
        if (m_headerLineCount <= 0) {
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            try {
                String string = lineNumberReader.readLine();
                while (string != null) {
                    ++m_headerLineCount;
                    string = lineNumberReader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inputStream = classLoader.getResourceAsStream(m_pdmlHeaderName);
        }
        return new BufferedInputStream(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized ImageIcon getImageResource(String string, ClassLoader classLoader) throws MissingResourceException {
        ImageIcon imageIcon = (ImageIcon)m_imageDictionary.get(string);
        if (imageIcon != null) {
            return imageIcon;
        }
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("imageFileNotFound", objectArray), string, "");
        }
        try {
            int n;
            byte[] byArray;
            inputStream = new BufferedInputStream(inputStream);
            int n2 = 0;
            try {
                n2 = inputStream.available();
            }
            catch (IOException iOException) {
                MessageLog.printStackTrace(iOException);
                ImageIcon imageIcon2 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                return imageIcon2;
            }
            if (n2 > 1) {
                try {
                    byArray = new byte[n2];
                    n = inputStream.read(byArray);
                }
                catch (IOException iOException) {
                    MessageLog.printStackTrace(iOException);
                    ImageIcon imageIcon3 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                    return imageIcon3;
                }
            }
            n = 0;
            int n3 = 0;
            byArray = new byte[65535];
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                MessageLog.printStackTrace(iOException);
                ImageIcon imageIcon4 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException4) {
                        // empty catch block
                    }
                }
                return imageIcon4;
            }
            while (n != -1) {
                if (n3 >= byArray.length) {
                    byte[] byArray2 = new byte[byArray.length * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    byArray = byArray2;
                }
                byArray[n3++] = (byte)n;
                try {
                    n = inputStream.read();
                }
                catch (IOException iOException) {
                    MessageLog.printStackTrace(iOException);
                    ImageIcon imageIcon5 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException5) {
                            // empty catch block
                        }
                    }
                    return imageIcon5;
                }
            }
            imageIcon = new ImageIcon(byArray);
            SystemResourceFinder.debug("IMAGE LOAD STATUS=" + imageIcon.getImageLoadStatus());
            m_imageDictionary.put(string, imageIcon);
            if (imageIcon.getImageLoadStatus() == 4) {
                Object[] objectArray = new Object[]{string};
                MessageLog.logError(SystemResourceFinder.format("imageError", objectArray));
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageIcon;
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("SystemResourceFinder: " + string);
        }
    }

    static {
        m_loader.setResourceName("com.ibm.as400.ui.framework.FRMRI");
        debugFlag = false;
        NOTFOUND = new Integer(-1);
        m_imageDictionary = new Hashtable();
    }
}

