/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.components;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobInfo {
    private String jobName_;
    private String userName_;
    private String jobNumber_;
    private String jobType_;
    private String status_;
    private String subsystem_;
    private String functionPrefix_;
    private String functionName_;
    private String currentUser_;
    private int cpu_;
    private int threadCount_;
    private int runPriority_;
    private long totalCPU_;
    private String memoryPool_;
    private static final Comparator<JobInfo> comparator_ = new Comparator<JobInfo>(){

        @Override
        public int compare(JobInfo jobInfo, JobInfo jobInfo2) {
            String string = jobInfo.getJobName().trim();
            String string2 = jobInfo2.getJobName().trim();
            String string3 = jobInfo.getJobType().trim();
            String string4 = jobInfo2.getJobType().trim();
            String string5 = jobInfo.getSubsystem();
            String string6 = jobInfo2.getSubsystem();
            string5 = string5 == null ? "" : string5.trim();
            String string7 = string6 = string6 == null ? "" : string6.trim();
            if (string3.equals("SBS")) {
                if (string4.equals("SBS")) {
                    return JobInfo.compareStrings(string, string2);
                }
                if (string4.equals("SYS")) {
                    return -1;
                }
                if (string.equals(string6)) {
                    return -1;
                }
                return JobInfo.compareStrings(string, string6);
            }
            if (string4.equals("SBS")) {
                if (string3.equals("SYS")) {
                    return 1;
                }
                if (string2.equals(string5)) {
                    return 1;
                }
                return JobInfo.compareStrings(string5, string2);
            }
            if (string3.equals("SYS") && string4.equals("SYS")) {
                return JobInfo.compareStrings(string, string2);
            }
            if (string3.equals("SYS")) {
                return 1;
            }
            if (string4.equals("SYS")) {
                return -1;
            }
            if (string5.equals(string6)) {
                return JobInfo.compareStrings(string, string2);
            }
            return JobInfo.compareStrings(string5, string6);
        }
    };

    JobInfo(String string, String string2, String string3, String string4, String string5) {
        this.jobName_ = string;
        this.userName_ = string2;
        this.jobNumber_ = string3;
        this.jobType_ = string4;
        this.status_ = string5;
    }

    public static void arrangeBySubsystem(JobInfo[] jobInfoArray) {
        Arrays.sort(jobInfoArray, comparator_);
    }

    private static final boolean isDigit(char c) {
        return c <= '9' && c >= '0';
    }

    private static final int compareStrings(String string, String string2) {
        for (int i = 0; i < string.length() && i < string2.length(); ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i))) continue;
            if (JobInfo.isDigit(c2)) {
                if (JobInfo.isDigit(c)) {
                    return c2 - c;
                }
                return 1;
            }
            if (JobInfo.isDigit(c)) {
                return -1;
            }
            return c2 - c;
        }
        return string.length() - string2.length();
    }

    public static void arrangeBySubsystem(List<JobInfo> list) {
        Collections.sort(list, comparator_);
    }

    public String getJobName() {
        return this.jobName_;
    }

    public String getUserName() {
        return this.userName_;
    }

    public void setCurrentUser(String string) {
        this.currentUser_ = string;
    }

    public String getCurrentUser() {
        return this.currentUser_;
    }

    public String getJobNumber() {
        return this.jobNumber_;
    }

    public String getJobType() {
        return this.jobType_;
    }

    public String getStatus() {
        return this.status_;
    }

    public void setSubsystem(String string) {
        this.subsystem_ = string;
    }

    public String getSubsystem() {
        return this.subsystem_;
    }

    public void setFunctionPrefix(String string) {
        this.functionPrefix_ = string == null ? "" : string;
    }

    public void setFunctionName(String string) {
        this.functionName_ = string == null ? "" : string;
    }

    public String getFunction() {
        return this.functionPrefix_ + this.functionName_;
    }

    public void setCPUPercent(int n) {
        this.cpu_ = n;
    }

    public int getCPUPercentInTenths() {
        return this.cpu_;
    }

    public float getCPUPercent() {
        return (float)this.cpu_ / 10.0f;
    }

    public void setThreadCount(int n) {
        this.threadCount_ = n;
    }

    public int getThreadCount() {
        return this.threadCount_;
    }

    public void setRunPriority(int n) {
        this.runPriority_ = n;
    }

    public int getRunPriority() {
        return this.runPriority_;
    }

    public void setTotalCPUUsed(long l) {
        this.totalCPU_ = l;
    }

    public long getTotalCPUUsed() {
        return this.totalCPU_;
    }

    void setMemoryPool(String string) {
        this.memoryPool_ = string;
    }

    public String getMemoryPool() {
        return this.memoryPool_;
    }

    public int getMemoryPoolID() {
        if (this.memoryPool_ == null) {
            return 0;
        }
        if (this.memoryPool_.equals("*BASE     ")) {
            return 2;
        }
        if (this.memoryPool_.equals("*INTERACT ")) {
            return 4;
        }
        if (this.memoryPool_.equals("*SPOOL    ")) {
            return 3;
        }
        if (this.memoryPool_.equals("*MACHINE  ")) {
            return 1;
        }
        return 0;
    }

    private String getCPUString() {
        int n = this.cpu_ / 10;
        int n2 = this.cpu_ % 10;
        String string = n == 0 ? "   ." : n + ".";
        string = string + n2;
        while (string.length() < 5) {
            string = " " + string;
        }
        return string;
    }

    public String toString() {
        boolean bl = this.jobType_.equals("SBS") || this.jobType_.equals("SYS");
        String string = this.getCPUString();
        return (bl ? "" : "  ") + this.jobName_ + (bl ? "   " : " ") + this.currentUser_ + " " + this.jobType_ + " " + string + " " + this.getFunction() + " " + this.status_;
    }

    private String getTotalCPUString() {
        int n = (int)(this.totalCPU_ / 100L);
        int n2 = n / 10;
        int n3 = n % 10;
        String string = n2 == 0 ? "      ." : n2 + ".";
        string = string + n3;
        while (string.length() < 8) {
            string = " " + string;
        }
        return string;
    }

    public String toString2() {
        boolean bl = this.jobType_.equals("SBS") || this.jobType_.equals("SYS");
        String string = this.getTotalCPUString();
        return (bl ? "" : "  ") + this.jobName_ + (bl ? "   " : " ") + this.jobType_ + " " + this.getMemoryPoolID() + " " + (this.runPriority_ < 10 ? " " : "") + this.runPriority_ + " " + string;
    }

    private String getThreadString() {
        String string = String.valueOf(this.threadCount_);
        while (string.length() < 8) {
            string = " " + string;
        }
        return string;
    }

    public String toString3() {
        boolean bl = this.jobType_.equals("SBS") || this.jobType_.equals("SYS");
        String string = this.getCPUString();
        String string2 = this.getThreadString();
        return (bl ? "" : "  ") + this.jobName_ + (bl ? "   " : " ") + this.userName_ + " " + this.jobNumber_ + " " + this.jobType_ + " " + string + " " + string2;
    }
}

