/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.command.program.journal;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.command.program.CallServiceProgramParameterFormat;
import com.ibm.jtopenlite.command.program.CallServiceProgramProcedure;
import com.ibm.jtopenlite.command.program.journal.RetrieveJournalEntriesListener;
import com.ibm.jtopenlite.command.program.journal.RetrieveJournalEntriesSelectionListener;

public class RetrieveJournalEntries
extends CallServiceProgramProcedure
implements CallServiceProgramParameterFormat {
    public static final String FORMAT_RJNE0100 = "RJNE0100";
    public static final String FORMAT_RJNE0200 = "RJNE0200";
    public static final int KEY_RANGE_OF_JOURNAL_RECEIVERS = 1;
    public static final int KEY_STARTING_SEQUENCE_NUMBER = 2;
    public static final int KEY_STARTING_TIME_STAMP = 3;
    public static final int KEY_ENDING_SEQUENCE_NUMBER = 4;
    public static final int KEY_ENDING_TIME_STAMP = 5;
    public static final int KEY_NUMBER_OF_ENTRIES = 6;
    public static final int KEY_JOURNAL_CODES = 7;
    public static final int KEY_JOURNAL_ENTRY_TYPES = 8;
    public static final int KEY_JOB = 9;
    public static final int KEY_PROGRAM = 10;
    public static final int KEY_USER_PROFILE = 11;
    public static final int KEY_COMMIT_CYCLE_IDENTIFIER = 12;
    public static final int KEY_DEPENDENT_ENTRIES = 13;
    public static final int KEY_INCLUDE_ENTRIES = 14;
    public static final int KEY_NULL_VALUE_INDICATORS_LENGTH = 15;
    public static final int KEY_FILE = 16;
    public static final int KEY_OBJECT = 17;
    public static final int KEY_OBJECT_PATH = 18;
    public static final int KEY_OBJECT_FILE_IDENTIFIER = 19;
    public static final int KEY_DIRECTORY_SUBTREE = 20;
    public static final int KEY_NAME_PATTERN = 21;
    public static final int KEY_FORMAT_MINIMIZED_DATA = 22;
    private int inputLength_;
    private String journalName_;
    private String journalLibrary_;
    private String formatName_;
    private RetrieveJournalEntriesSelectionListener selection_;
    private RetrieveJournalEntriesListener listener_;
    private final char[] charBuffer_ = new char[30];

    public RetrieveJournalEntries() {
        super("QJOURNAL", "QSYS", "QjoRetrieveJournalEntries", 0);
        this.setParameterFormat(this);
    }

    public RetrieveJournalEntries(int n, String string, String string2, String string3, RetrieveJournalEntriesListener retrieveJournalEntriesListener) {
        this();
        this.inputLength_ = n < 13 ? 13 : n;
        this.journalName_ = string;
        this.journalLibrary_ = string2;
        this.formatName_ = string3;
        this.listener_ = retrieveJournalEntriesListener;
    }

    public RetrieveJournalEntriesSelectionListener getSelectionListener() {
        return this.selection_;
    }

    public void setSelectionListener(RetrieveJournalEntriesSelectionListener retrieveJournalEntriesSelectionListener) {
        this.selection_ = retrieveJournalEntriesSelectionListener;
    }

    public int getParameterCount() {
        return 6;
    }

    public int getParameterLength(int n) {
        switch (n) {
            case 0: {
                return this.inputLength_;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 8;
            }
            case 4: {
                int n2 = 4;
                if (this.selection_ != null) {
                    int n3 = this.selection_.getNumberOfVariableLengthRecords();
                    for (int i = 0; i < n3; ++i) {
                        int n4 = this.selection_.getVariableLengthRecordDataLength(i);
                        n2 += 12 + n4;
                    }
                }
                return n2;
            }
            case 5: {
                return 4;
            }
        }
        return 0;
    }

    public int getParameterFormat(int n) {
        return 2;
    }

    public void fillInputData(int n, byte[] byArray, int n2) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                Conv.intToByteArray(this.inputLength_, byArray, n2);
                break;
            }
            case 2: {
                Conv.stringToBlankPadEBCDICByteArray(this.journalName_, byArray, n2, 10);
                Conv.stringToBlankPadEBCDICByteArray(this.journalLibrary_, byArray, n2 + 10, 10);
                break;
            }
            case 3: {
                Conv.stringToEBCDICByteArray37(this.formatName_, byArray, n2);
                break;
            }
            case 4: {
                if (this.selection_ == null) {
                    Conv.intToByteArray(0, byArray, n2);
                    break;
                }
                int n3 = this.selection_.getNumberOfVariableLengthRecords();
                Conv.intToByteArray(n3, byArray, n2);
                n2 += 4;
                for (int i = 0; i < n3; ++i) {
                    int n4 = this.selection_.getVariableLengthRecordDataLength(i);
                    int n5 = 12 + n4;
                    Conv.intToByteArray(n5, byArray, n2);
                    Conv.intToByteArray(this.selection_.getVariableLengthRecordKey(i), byArray, n2 + 4);
                    Conv.intToByteArray(n4, byArray, n2 + 8);
                    this.selection_.setVariableLengthRecordData(i, byArray, n2 + 12);
                    n2 += n5;
                }
                break;
            }
            case 5: {
                Conv.intToByteArray(0, byArray, n2);
            }
        }
    }

    public void setOutputData(int n, byte[] byArray, int n2) {
        if (n == 0 && this.formatName_.equals(FORMAT_RJNE0100)) {
            int n3 = Conv.byteArrayToInt(byArray, n2 += 4);
            int n4 = Conv.byteArrayToInt(byArray, n2 += 4);
            char c = Conv.ebcdicByteToChar(byArray[n2 += 4]);
            ++n2;
            if (this.listener_ != null) {
                this.listener_.newJournalEntries(n4, c);
            }
            if (n3 > 0 && this.listener_ != null) {
                n2 = n3;
                for (int i = 0; i < n4; ++i) {
                    int n5 = Conv.byteArrayToInt(byArray, n2);
                    int n6 = Conv.byteArrayToInt(byArray, n2 + 12);
                    long l = Conv.zonedDecimalToLong(byArray, n2 + 16, 20);
                    char c2 = Conv.ebcdicByteToChar(byArray[n2 + 36]);
                    String string = Conv.ebcdicByteArrayToString(byArray, n2 + 37, 2, this.charBuffer_);
                    String string2 = Conv.ebcdicByteArrayToString(byArray, n2 + 39, 26, this.charBuffer_);
                    String string3 = Conv.ebcdicByteArrayToString(byArray, n2 + 65, 10, this.charBuffer_);
                    String string4 = Conv.ebcdicByteArrayToString(byArray, n2 + 75, 10, this.charBuffer_);
                    String string5 = Conv.ebcdicByteArrayToString(byArray, n2 + 85, 6, this.charBuffer_);
                    String string6 = Conv.ebcdicByteArrayToString(byArray, n2 + 91, 10, this.charBuffer_);
                    String string7 = Conv.ebcdicByteArrayToString(byArray, n2 + 101, 30, this.charBuffer_);
                    int n7 = Conv.zonedDecimalToInt(byArray, n2 + 131, 10);
                    char c3 = Conv.ebcdicByteToChar(byArray[n2 + 141]);
                    long l2 = Conv.zonedDecimalToLong(byArray, n2 + 142, 20);
                    String string8 = Conv.ebcdicByteArrayToString(byArray, n2 + 162, 10, this.charBuffer_);
                    String string9 = Conv.ebcdicByteArrayToString(byArray, n2 + 172, 8, this.charBuffer_);
                    String string10 = Conv.ebcdicByteArrayToString(byArray, n2 + 180, 10, this.charBuffer_);
                    char c4 = Conv.ebcdicByteToChar(byArray[n2 + 190]);
                    char c5 = Conv.ebcdicByteToChar(byArray[n2 + 191]);
                    char c6 = Conv.ebcdicByteToChar(byArray[n2 + 192]);
                    char c7 = Conv.ebcdicByteToChar(byArray[n2 + 193]);
                    char c8 = Conv.ebcdicByteToChar(byArray[n2 + 194]);
                    char c9 = Conv.ebcdicByteToChar(byArray[n2 + 195]);
                    this.listener_.newEntryData(n6, l, c2, string, string2, string3, string4, string5, string6, string7, n7, c3, l2, string8, string9, string10, c4, c5, c6, c7, c8, c9);
                    n2 += n5;
                }
            }
        }
    }

    public int getLengthOfReceiverVariable() {
        return this.inputLength_;
    }

    public void setLengthOfReceiverVariable(int n) {
        this.inputLength_ = n;
    }

    public String getJournalName() {
        return this.journalName_;
    }

    public void setJournalName(String string) {
        this.journalName_ = string;
    }

    public String getJournalLibrary() {
        return this.journalLibrary_;
    }

    public void setJournalLibrary(String string) {
        this.journalLibrary_ = string;
    }

    public String getFormatName() {
        return this.formatName_;
    }

    public void setFormatName(String string) {
        this.formatName_ = string;
    }

    public RetrieveJournalEntriesListener getListener() {
        return this.listener_;
    }

    public void setListener(RetrieveJournalEntriesListener retrieveJournalEntriesListener) {
        this.listener_ = retrieveJournalEntriesListener;
    }
}

