/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.rpgunit.handler;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ObjectList;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.UserSpace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.rpgunit.model.CallStackEntry;
import miworkplace.rpgunit.model.UnitTestCase;
import miworkplace.rpgunit.model.UnitTestResult;
import org.apache.commons.lang3.StringUtils;

public class UnitTestUtil {
    public static UnitTestResult runRemoteUnitTest(IRemoteObject serviceprogram, String rpgunitLibrary, String rpgunitRunner, String rpgunitJobd) throws Exception {
        UnitTestResult testResult = null;
        AS400 system = serviceprogram.getConnection().getSystem();
        UnitTestUtil.addLibrary(system, rpgunitLibrary);
        QSYSObjectPathName jobd = UnitTestUtil.buildJobDescription(rpgunitJobd);
        QSYSObjectPathName testRunner = new QSYSObjectPathName(rpgunitLibrary, rpgunitRunner, "PGM");
        UserSpace us = UnitTestUtil.createUserspace(serviceprogram.getConnection());
        int rc = UnitTestUtil.executeTest(system, us, new QSYSObjectPathName(serviceprogram.getPath()), testRunner, jobd, rpgunitLibrary);
        switch (rc) {
            case -1: 
            case 0: {
                testResult = UnitTestUtil.retrieveUnitTestResult(system, us, serviceprogram, rpgunitLibrary);
                break;
            }
            default: {
                throw new Exception("Unit test " + serviceprogram.getName() + " exited with return code " + rc + ".");
            }
        }
        try {
            us.delete();
        }
        catch (Exception exception) {}
        return testResult;
    }

    private static QSYSObjectPathName buildJobDescription(String rpgunitJobd) throws Exception {
        QSYSObjectPathName jobd = new QSYSObjectPathName();
        jobd.setObjectType("JOBD");
        String[] parts = rpgunitJobd.split("/", 2);
        if (parts.length == 1) {
            jobd.setLibraryName("%LIBL%");
            jobd.setObjectName(parts[0]);
        } else {
            jobd.setLibraryName(parts[0]);
            jobd.setObjectName(parts[1]);
        }
        return jobd;
    }

    private static void addLibrary(AS400 system, String rpgunitLibrary) {
        try {
            new CommandCall(system, "ADDLIBLE " + rpgunitLibrary + " *LAST").run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static UnitTestResult retrieveUnitTestResult(AS400 system, UserSpace us, IRemoteObject serviceprogram, String rpgunitLibrary) throws Exception {
        AS400Bin4 intConv = new AS400Bin4();
        UnitTestResult result = new UnitTestResult(serviceprogram);
        byte[] bytes = UnitTestUtil.getUserspaceBytes(us);
        int offsetTestcases = intConv.toInt(bytes, 44);
        result.setNumberRuns(intConv.toInt(bytes, 28));
        result.setNumberAssertions(intConv.toInt(bytes, 32));
        result.setNumberFailures(intConv.toInt(bytes, 36));
        result.setNumberErrors(intConv.toInt(bytes, 40));
        result.setNumberTestCases(intConv.toInt(bytes, 48));
        result.addTestCases(UnitTestUtil.retrieveTestCases(system, bytes, result, serviceprogram, offsetTestcases, rpgunitLibrary));
        return result;
    }

    private static byte[] getUserspaceBytes(UserSpace us) throws Exception {
        AS400Bin4 intConv = new AS400Bin4();
        byte[] bytes = new byte[4];
        us.read(bytes, 0);
        int usedUserspaceBytes = intConv.toInt(bytes);
        bytes = new byte[usedUserspaceBytes];
        us.read(bytes, 0);
        return bytes;
    }

    private static List<UnitTestCase> retrieveTestCases(AS400 system, byte[] bytes, UnitTestResult result, IRemoteObject serviceprogram, int offsetTestcases, String rpgunitLibrary) throws Exception {
        ArrayList<UnitTestCase> testCases = new ArrayList<UnitTestCase>();
        int i = 0;
        while (i < result.getNumberTestCases()) {
            Object[] returnValue = UnitTestUtil.buildTestCase(result, serviceprogram, bytes, offsetTestcases, rpgunitLibrary);
            testCases.add((UnitTestCase)returnValue[0]);
            offsetTestcases = (Integer)returnValue[1];
            ++i;
        }
        return testCases;
    }

    private static Object[] buildTestCase(UnitTestResult result, IRemoteObject serviceprogram, byte[] bytes, int offset, String rpgunitLibrary) throws Exception {
        UnitTestCase testcase = new UnitTestCase(result, serviceprogram);
        AS400 system = serviceprogram.getConnection().getSystem();
        CharConverter charConv = new CharConverter(system.getCcsid(), system);
        AS400Bin2 shortConv = new AS400Bin2();
        AS400Bin4 intConv = new AS400Bin4();
        AS400Bin8 longConv = new AS400Bin8();
        String statusCode = charConv.byteArrayToString(bytes, offset + 4, 1);
        testcase.setStatus(UnitTestUtil.getStatus(statusCode));
        testcase.setAssertions(intConv.toInt(bytes, offset + 16));
        short nameLength = shortConv.toShort(bytes, offset + 32);
        testcase.setName(charConv.byteArrayToString(bytes, offset + 36, (int)nameLength).trim());
        short exceptionLength = shortConv.toShort(bytes, offset + 34);
        String errorMessage = charConv.byteArrayToString(bytes, offset + 136, (int)exceptionLength);
        if (!StringUtils.isEmpty((CharSequence)errorMessage)) {
            testcase.setErrorMessage(errorMessage);
            int numberCallStackEntries = intConv.toInt(bytes, offset + 20);
            int offsetCallStack = intConv.toInt(bytes, offset + 24);
            int i = 0;
            while (i < numberCallStackEntries) {
                Object[] returnValue = UnitTestUtil.buildCallStackEntry(bytes, offsetCallStack, system);
                CallStackEntry callStackEntry = (CallStackEntry)returnValue[0];
                if (callStackEntry.senderProgramLibrary.equals(rpgunitLibrary) && callStackEntry.senderProgramName.equals("RUPGMRMT")) break;
                testcase.addCallStackEntry(callStackEntry);
                offsetCallStack = (Integer)returnValue[1];
                ++i;
            }
        }
        testcase.setExecutionTime(longConv.toLong(bytes, offset + 1160));
        int offsetNextEntry = intConv.toInt(bytes, offset + 28);
        return new Object[]{testcase, offsetNextEntry};
    }

    private static UnitTestCase.Status getStatus(String statusCode) {
        switch (statusCode) {
            case "S": {
                return UnitTestCase.Status.Success;
            }
            case "E": {
                return UnitTestCase.Status.Error;
            }
            case "F": {
                return UnitTestCase.Status.Failure;
            }
        }
        return null;
    }

    private static Object[] buildCallStackEntry(byte[] bytes, int offset, AS400 system) throws Exception {
        CharConverter charConv = new CharConverter(system.getCcsid(), system);
        AS400Bin2 shortConv = new AS400Bin2();
        AS400Bin4 intConv = new AS400Bin4();
        CallStackEntry entry = new CallStackEntry();
        int offsetNext = intConv.toInt(bytes, offset + 54);
        entry.senderProgramName = charConv.byteArrayToString(bytes, offset, 10).trim();
        entry.senderProgramLibrary = charConv.byteArrayToString(bytes, offset + 10, 10).trim();
        if (entry.senderProgramLibrary.equals("*N")) {
            entry.senderProgramLibrary = "";
        }
        entry.senderModuleName = charConv.byteArrayToString(bytes, offset + 20, 10).trim();
        entry.senderModuleLibrary = charConv.byteArrayToString(bytes, offset + 30, 10).trim();
        if (entry.senderModuleLibrary.equals("*N")) {
            entry.senderModuleLibrary = "";
        }
        entry.statementNumber = charConv.byteArrayToString(bytes, offset + 40, 10).trim();
        short procedureNameLength = shortConv.toShort(bytes, offset + 66);
        entry.procedureName = charConv.byteArrayToString(bytes, offset + 68, (int)procedureNameLength).trim();
        return new Object[]{entry, offsetNext};
    }

    private static int executeTest(AS400 system, UserSpace us, QSYSObjectPathName test, QSYSObjectPathName testRunner, QSYSObjectPathName jobd, String rpgunitLibrary) throws Exception {
        int returnValue = 0;
        AS400Bin4 intConv = new AS400Bin4();
        QSYSObjectPathName usPath = new QSYSObjectPathName(us.getPath());
        ProgramParameter[] parameter = UnitTestUtil.composeProgramParameter(system, usPath, jobd, test, rpgunitLibrary);
        ProgramCall program = new ProgramCall(system);
        program.setProgram(testRunner.getPath());
        program.setParameterList(parameter);
        if (!program.run()) {
            AS400Message[] msgList = program.getMessageList();
            StringBuilder as400ErrorMsg = new StringBuilder();
            int j = 0;
            while (j < msgList.length) {
                as400ErrorMsg.append(msgList[j].getID() + " - " + msgList[j].getText() + " ");
                ++j;
            }
            throw new Exception("Error during test execution. " + as400ErrorMsg.toString());
        }
        returnValue = intConv.toInt(program.getParameterList()[0].getOutputData());
        return returnValue;
    }

    private static ProgramParameter composeLibraryList(AS400 system, String rpgunitLibrary) throws Exception {
        CharConverter conv = new CharConverter(system.getCcsid(), system);
        ArrayList<String> libraryList = new ArrayList<String>(Arrays.asList(system.getJobs(2)[0].getUserLibraryList()));
        if (!libraryList.contains(rpgunitLibrary)) {
            libraryList.add(rpgunitLibrary);
        }
        StringBuilder sb = new StringBuilder();
        for (String library : libraryList) {
            sb.append(StringUtils.rightPad((String)library, (int)10));
        }
        String allLibrariesString = StringUtils.rightPad((String)sb.toString(), (int)2500);
        byte[] content = conv.stringToByteArray(allLibrariesString);
        AS400Bin2 shortConv = new AS400Bin2();
        byte[] numberEntries = shortConv.toBytes((short)libraryList.size());
        byte[] bytes = new byte[numberEntries.length + content.length];
        System.arraycopy(numberEntries, 0, bytes, 0, numberEntries.length);
        System.arraycopy(content, 0, bytes, 2, content.length);
        ProgramParameter parameter = new ProgramParameter(2, bytes);
        return parameter;
    }

    private static ProgramParameter composeTestProcedureList(AS400 system) throws Exception {
        CharConverter conv = new CharConverter(system.getCcsid(), system);
        AS400Bin2 shortConv = new AS400Bin2();
        byte[] numberEntries = shortConv.toBytes((short)1);
        byte[] procLen = shortConv.toBytes((short)4);
        byte[] content = conv.stringToByteArray(StringUtils.rightPad((String)"*ALL", (int)256));
        byte[] bytes = new byte[numberEntries.length + procLen.length + content.length];
        System.arraycopy(numberEntries, 0, bytes, 0, 2);
        System.arraycopy(procLen, 0, bytes, 2, 2);
        System.arraycopy(content, 0, bytes, 4, 256);
        ProgramParameter parameter = new ProgramParameter(2, bytes);
        return parameter;
    }

    private static ProgramParameter[] composeProgramParameter(AS400 system, QSYSObjectPathName usPath, QSYSObjectPathName jobdPath, QSYSObjectPathName test, String rpgunitLibrary) throws Exception {
        CharConverter conv = new CharConverter(system.getCcsid(), system);
        ProgramParameter[] parameter = new ProgramParameter[]{new ProgramParameter(2, 4), new ProgramParameter(2, conv.stringToByteArray(usPath.toQualifiedObjectName())), new ProgramParameter(2, conv.stringToByteArray(test.toQualifiedObjectName())), UnitTestUtil.composeTestProcedureList(system), new ProgramParameter(2, conv.stringToByteArray(StringUtils.rightPad((String)"*API", (int)10))), new ProgramParameter(2, conv.stringToByteArray(StringUtils.rightPad((String)"*ALL", (int)10))), new ProgramParameter(2, conv.stringToByteArray(StringUtils.rightPad((String)"*ALLWAYS", (int)10))), UnitTestUtil.composeLibraryList(system, rpgunitLibrary), new ProgramParameter(2, conv.stringToByteArray(jobdPath.toQualifiedObjectName())), new ProgramParameter(2, conv.stringToByteArray(StringUtils.rightPad((String)"*NO", (int)10)))};
        return parameter;
    }

    private static UserSpace createUserspace(IConnection conn) throws Exception {
        String secs = String.valueOf(System.currentTimeMillis() / 1000L);
        String usName = "RU" + secs.substring(secs.length() - 8);
        UserSpace us = new UserSpace(conn.getSystem(), QSYSObjectPathName.toPath((String)"QTEMP", (String)usName, (String)"USRSPC"));
        us.setMustUseProgramCall(true);
        us.create(65535, true, "MIWORKPLAC", (byte)0, "Userspace for Unit Test", "*ALL");
        return us;
    }

    public static boolean isTestCaseRunnerAvailable(IConnection conn, String rpgunitLibrary, String rpgunitRunner) throws Exception {
        boolean available = false;
        ObjectList objects = new ObjectList(conn.getSystem(), rpgunitLibrary, rpgunitRunner, "*PGM");
        objects.load();
        available = objects.getObjects().hasMoreElements();
        return available;
    }
}

