/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.rpgunit.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.rpgunit.RunUnitTestJob;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.ITreeSelection;

public class RunUnitTestHandler {
    @Inject
    private IEclipseContext context;
    @Inject
    private EPartService partService;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        boolean canExecute = false;
        for (Object object : selection) {
            IRemoteObject remoteObject;
            if (!(object instanceof IRemoteObject) || !IRemoteObject.Type.serviceprogram.equals((Object)(remoteObject = (IRemoteObject)object).getType())) continue;
            return true;
        }
        return canExecute;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        this.showView("miworkplace.rpgunit.part");
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set(ITreeSelection.class, (Object)selection);
        if (!selection.isEmpty()) {
            IConnection connection = ((IRemoteObject)selection.getFirstElement()).getConnection();
            additionalContext.set(IConnection.class, (Object)connection);
        }
        Job job = (Job)ContextInjectionFactory.make(RunUnitTestJob.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
        job.schedule();
    }

    private void showView(String partId) {
        MPart rpgunitPart = null;
        Collection parts = this.partService.getParts();
        for (MPart part : parts) {
            if (!part.getElementId().equals("miworkplace.rpgunit.part")) continue;
            rpgunitPart = part;
            break;
        }
        if (rpgunitPart == null) {
            rpgunitPart = this.partService.createPart("miworkplace.rpgunit.part");
            this.partService.showPart(rpgunitPart, EPartService.PartState.ACTIVATE);
        }
        this.partService.activate(rpgunitPart);
    }
}

