/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.rpgunit;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.rpgunit.handler.UnitTestException;
import miworkplace.rpgunit.handler.UnitTestUtil;
import miworkplace.rpgunit.model.UnitTestResult;
import miworkplace.rpgunit.ui.RpgUnitView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.ITreeSelection;
import org.osgi.service.log.LogService;

public class RunUnitTestJob
extends Job {
    @Inject
    private UISynchronize sync;
    @Inject
    private LogService logger;
    @Inject
    private EPartService partService;
    @Inject
    private ITreeSelection selection;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    private IConnection connection;

    public RunUnitTestJob() {
        super(Messages.rpgunit_job_title);
        this.setPriority(20);
    }

    @PostConstruct
    public void postConstruct() {
        String name = this.getFirstUnitTestName();
        this.setName(Messages.rpgunit_job_title + " (" + name + ")");
    }

    private String getFirstUnitTestName() {
        return this.selection.getFirstElement().toString();
    }

    protected IStatus run(IProgressMonitor monitor) {
        String errorMessage = null;
        final RpgUnitView view = (RpgUnitView)this.partService.findPart("miworkplace.rpgunit.part").getObject();
        final ArrayList<UnitTestResult> results = new ArrayList<UnitTestResult>();
        for (Object object : this.selection) {
            if (!(object instanceof IRemoteObject)) continue;
            String rpgunitLibrary = this.applicationPreferences.get("miworkplace.rpgunit.library", "RPGUNIT");
            String rpgunitRunner = this.applicationPreferences.get("miworkplace.rpgunit.runner", "RUPGMRMT");
            String rpgunitJobd = this.applicationPreferences.get("miworkplace.rpgunit.runner", "RPGUNIT/RPGUNIT");
            IRemoteObject selectedObject = (IRemoteObject)object;
            try {
                UnitTestResult testResult = UnitTestUtil.runRemoteUnitTest(selectedObject, rpgunitLibrary, rpgunitRunner, rpgunitJobd);
                if (testResult == null) continue;
                results.add(testResult);
            }
            catch (UnitTestException unitTestException) {
                errorMessage = String.format(Messages.rpgunit_error_notestcases, selectedObject.getName());
                Notifier.info((String)Messages.rpgunit_job_title, (String)errorMessage);
            }
            catch (Exception e) {
                try {
                    if (UnitTestUtil.isTestCaseRunnerAvailable(selectedObject.getConnection(), rpgunitLibrary, rpgunitRunner)) {
                        errorMessage = String.format(Messages.rpgunit_error_nosuccess, selectedObject.getName());
                        Notifier.warn((String)Messages.rpgunit_job_title, (String)errorMessage);
                        continue;
                    }
                    errorMessage = Messages.rpgunit_error_norunner;
                    Notifier.error((String)Messages.rpgunit_job_title, (String)errorMessage);
                }
                catch (Exception exception) {
                    errorMessage = e.getMessage();
                    this.logger.log(1, errorMessage);
                }
            }
        }
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (results.size() > 0) {
                    view.setInput(results.toArray(new UnitTestResult[results.size()]));
                } else {
                    view.setInput(null);
                }
            }
        });
        if (errorMessage == null) {
            return Status.OK_STATUS;
        }
        return new Status(4, "miworkplace.rpgunit", errorMessage);
    }

    public boolean belongsTo(Object family) {
        return this.connection.getName().equals(family);
    }
}

