/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.rpgunit;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.rpgunit.handler.UnitTestException;
import miworkplace.rpgunit.handler.UnitTestUtil;
import miworkplace.rpgunit.model.UnitTestResult;
import miworkplace.rpgunit.ui.RpgUnitView;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class RerunUnitTestJob
extends Job {
    @Inject
    private UISynchronize sync;
    @Inject
    private EPartService partService;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    @Named(value="miworkplace.rpgunit.results")
    private List<UnitTestResult> results;
    private IConnection connection;

    public RerunUnitTestJob() {
        super(Messages.rpgunit_job_title);
        this.setPriority(20);
    }

    @PostConstruct
    public void postConstruct() {
        String name = this.getFirstUnitTestName();
        this.setName(Messages.rpgunit_job_title + " (" + name + ")");
        this.connection = this.results.get(0).getServiceProgram().getConnection();
    }

    private String getFirstUnitTestName() {
        return this.results.get(0).getServiceProgram().getName();
    }

    protected IStatus run(IProgressMonitor monitor) {
        String errorMessage = null;
        final RpgUnitView view = (RpgUnitView)this.partService.findPart("miworkplace.rpgunit.part").getObject();
        final ArrayList<UnitTestResult> newResults = new ArrayList<UnitTestResult>();
        for (UnitTestResult unitTestResult : this.results) {
            String rpgunitLibrary = this.applicationPreferences.get("miworkplace.rpgunit.library", "RPGUNIT");
            String rpgunitRunner = this.applicationPreferences.get("miworkplace.rpgunit.runner", "RUPGMRMT");
            String rpgunitJobd = this.applicationPreferences.get("miworkplace.rpgunit.runner", "RPGUNIT/RPGUNIT");
            IRemoteObject serviceProgram = unitTestResult.getServiceProgram();
            try {
                UnitTestResult testResult = UnitTestUtil.runRemoteUnitTest(serviceProgram, rpgunitLibrary, rpgunitRunner, rpgunitJobd);
                if (testResult == null) continue;
                newResults.add(testResult);
            }
            catch (UnitTestException unitTestException) {
                errorMessage = String.format(Messages.rpgunit_error_notestcases, serviceProgram.getName());
                Notifier.info((String)Messages.rpgunit_job_title, (String)errorMessage);
            }
            catch (Exception exception) {
                errorMessage = String.format(Messages.rpgunit_error_nosuccess, serviceProgram.getName());
                Notifier.warn((String)Messages.rpgunit_job_title, (String)errorMessage);
            }
        }
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (newResults.size() > 0) {
                    view.setInput(newResults.toArray(new UnitTestResult[newResults.size()]));
                } else {
                    view.setInput(null);
                }
            }
        });
        if (errorMessage == null) {
            return Status.OK_STATUS;
        }
        return new Status(4, "miworkplace.rpgunit", errorMessage);
    }

    public boolean belongsTo(Object family) {
        return this.connection.getName().equals(family);
    }
}

