/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.validator;

import com.ibm.as400.access.QSYSObjectTypeTable;
import java.util.ArrayList;
import java.util.Arrays;
import miworkplace.i18n.Messages;
import org.eclipse.jface.dialogs.IInputValidator;

public class IFSObjectNameValidator
implements IInputValidator {
    private ArrayList<String> validSuffices = new ArrayList();

    public IFSObjectNameValidator() {
        this.validSuffices.addAll(Arrays.asList(QSYSObjectTypeTable.getSupportedObjectTypes()));
    }

    public String isValid(String newText) {
        String errorMessage = null;
        if (!newText.contains(".")) {
            errorMessage = Messages.ifs_name_val_valsuffix;
        } else {
            String[] parts = newText.split("\\.");
            String newName = parts[0];
            String suffix = null;
            if (parts.length == 2) {
                suffix = parts[1];
            }
            if (parts.length != 2) {
                errorMessage = Messages.ifs_name_val_partlen;
            } else if (!this.validSuffices.contains(suffix) && !suffix.toUpperCase().equals("MBR")) {
                errorMessage = Messages.ifs_name_val_valsuffix;
            } else if (newText.length() == 0) {
                errorMessage = Messages.ifs_name_val_empty;
            } else if (newName.length() > 10) {
                errorMessage = Messages.ifs_name_val_length;
            } else if (!newName.substring(0, 1).matches("[a-zA-Z]")) {
                errorMessage = Messages.ifs_name_val_chars;
            }
        }
        return errorMessage;
    }
}

