/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.listener;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public class NumericVerifyListener
implements VerifyListener {
    private int rangeStart = -1;
    private int rangeEnd = -1;
    private boolean checkRange = false;

    public NumericVerifyListener() {
    }

    public NumericVerifyListener(boolean enable, int start, int end) {
        this.checkRange = enable;
        this.rangeStart = start;
        this.rangeEnd = end;
    }

    public void enableRangeChecking() {
        this.checkRange = true;
    }

    public void disableRangeChecking() {
        this.checkRange = false;
    }

    public void setCheckRange(int start, int end) {
        this.rangeStart = start;
        this.rangeEnd = end;
    }

    public void verifyText(VerifyEvent e) {
        if (e.text.length() > 0) {
            if (!e.text.matches("[0-9,\\.]")) {
                e.doit = false;
            } else if (this.checkRange) {
                try {
                    Text widget = (Text)e.widget;
                    String text = widget.getText();
                    Point selection = widget.getSelection();
                    String string = text.substring(0, selection.x) + e.text + text.substring(selection.y, text.length());
                    int x = Integer.parseInt(string);
                    if (x < this.rangeStart || x > this.rangeEnd) {
                        if (x < this.rangeStart) {
                            e.text = "";
                            widget.setText(String.valueOf(this.rangeStart));
                        } else if (x > this.rangeEnd) {
                            e.text = "";
                            widget.setText(String.valueOf(this.rangeEnd));
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    e.text = "";
                }
            }
        }
    }
}

