/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miworkplace.common.model.TextAttribute;
import miworkplace.services.api.ITextAttributeService;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.json.JSONObject;

public class TextAttributeService
implements ITextAttributeService {
    private List<String> categories = new ArrayList<String>();
    private Map<String, TextAttribute> attributes = new HashMap<String, TextAttribute>();
    private IEclipsePreferences preferences;
    private PreferenceChangeListener preferenceChangeListener = new PreferenceChangeListener();

    @Override
    public void add(TextAttribute attribute) {
        if (attribute.getCategory() != null && !this.categories.contains(attribute.getCategory())) {
            this.categories.add(attribute.getCategory());
        }
        this.attributes.put(attribute.getId(), attribute);
    }

    @Override
    public void remove(TextAttribute attribute) {
        this.attributes.remove(attribute);
        boolean categoryStillPresent = false;
        for (TextAttribute ta : this.attributes.values()) {
            if (!ta.getCategory().equals(attribute.getCategory())) continue;
            categoryStillPresent = true;
            break;
        }
        if (!categoryStillPresent) {
            this.categories.remove(attribute.getCategory());
        }
    }

    @Override
    public List<TextAttribute> list() {
        return Collections.unmodifiableList(new ArrayList<TextAttribute>(this.attributes.values()));
    }

    @Override
    public List<TextAttribute> list(String category) {
        ArrayList<TextAttribute> ats = new ArrayList<TextAttribute>();
        for (TextAttribute ta : this.attributes.values()) {
            if (!ta.getCategory().equals(category)) continue;
            ats.add(ta);
        }
        return ats;
    }

    @Override
    public List<String> categories() {
        return Collections.unmodifiableList(this.categories);
    }

    @Override
    public void setPreferences(IEclipsePreferences appearancePreferences) {
        this.preferences = appearancePreferences;
        this.addPreferencesListener();
        try {
            this.updateTextAttributes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTextAttributes() throws Exception {
        for (TextAttribute ta : this.attributes.values()) {
            this.updateTextAttribute(ta.getId());
        }
    }

    private void updateTextAttribute(String id) throws Exception {
        String value = this.preferences.get(id, "");
        if (!value.isEmpty()) {
            JSONObject jo = new JSONObject(value);
            TextAttribute attribute = this.attributes.get(id);
            attribute.setValue(jo.getString("value"));
        }
    }

    private void addPreferencesListener() {
        this.preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.preferenceChangeListener);
    }

    @Override
    public TextAttribute get(String id) {
        return this.attributes.get(id);
    }

    class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        PreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (TextAttributeService.this.attributes.containsKey(event.getKey())) {
                try {
                    TextAttributeService.this.updateTextAttribute(event.getKey());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

