/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.properties;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.extra.xstream.XStream;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.services.debug.Option;
import miworkplace.services.properties.MemberPropertiesLoader;
import miworkplace.services.properties.ObjectPropertiesLoader;
import miworkplace.services.properties.StreamFilePropertiesLoader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;

public class ObjectPropertiesStore
implements IObjectPropertiesStore {
    private static final Object OBJECT_PROPERTIES_FILENAME_SUFFIX = ".properties";
    private Debug logger = Debug.getInstance();
    @Inject
    private IEclipseContext context;
    private IPath bundleStateLocation;

    @PostConstruct
    public void init() {
        Bundle bundle = Platform.getBundle((String)"miworkplace.services");
        this.bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
    }

    @Override
    public synchronized void put(IRemoteObject object, Map<ObjectProperty, Object> properties) {
        File f = this.getObjectPropertiesFile(object);
        if (f.exists()) {
            Object obj = properties.get((Object)ObjectProperty.notloaded);
            if (obj != null && ((Boolean)obj).equals(Boolean.TRUE)) {
                f.delete();
            } else {
                Object existingChangeDate;
                Object newChangeDate;
                Map<ObjectProperty, Object> existingProperties = this.load(f);
                Object newRawChangeDate = properties.get((Object)ObjectProperty.rawchangedate);
                if (newRawChangeDate == null) {
                    newChangeDate = properties.get((Object)ObjectProperty.changedate);
                    existingChangeDate = existingProperties.get((Object)ObjectProperty.changedate);
                } else {
                    newChangeDate = properties.get((Object)ObjectProperty.rawchangedate);
                    existingChangeDate = existingProperties.get((Object)ObjectProperty.rawchangedate);
                }
                if (Objects.equals(newChangeDate, existingChangeDate)) {
                    if (properties.containsKey((Object)ObjectProperty.rawcreationdate)) {
                        return;
                    }
                    f.delete();
                } else {
                    f.delete();
                }
            }
        }
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        this.store(properties, f);
    }

    private void store(Map<ObjectProperty, Object> properties, File f) {
        try {
            f.createNewFile();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
            xstream.setClassLoader(this.getClass().getClassLoader());
            xstream.toXML(properties, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            this.logger.error((miworkplace.common.debug.Option)Option.loading, "Could not write object properties to " + f.getAbsolutePath() + ". Error: " + e.getMessage());
        }
    }

    private StaxDriver createSerializationDriverInstance() {
        return new StaxDriver();
    }

    @Override
    public boolean contains(IRemoteObject object, Map<ObjectProperty, Object> properties) {
        return this.getObjectPropertiesFile(object).exists();
    }

    @Override
    public void remove(IRemoteObject object) {
        File f = this.getObjectPropertiesFile(object);
        if (f != null) {
            f.delete();
        }
    }

    private File getObjectPropertiesFile(IRemoteObject object) {
        IPath path = this.bundleStateLocation.append("objectdescriptions").append(object.getConnection().getName()).append(this.composeObjectPropertiesFileName(object));
        return path.toFile();
    }

    private String composeObjectPropertiesFileName(IRemoteObject object) {
        String filename = object.getPath().replaceAll("/", "#") + String.valueOf(OBJECT_PROPERTIES_FILENAME_SUFFIX);
        return filename;
    }

    @Override
    public Map<ObjectProperty, Object> get(IRemoteObject object) {
        return this.get(object, false);
    }

    @Override
    public Map<ObjectProperty, Object> get(IRemoteObject object, boolean load) {
        Map<ObjectProperty, Object> properties = null;
        this.logger.debug((miworkplace.common.debug.Option)Option.loading, "Getting object properties for " + object.getName() + "." + String.valueOf(object.getAttribute()));
        File file = this.getObjectPropertiesFile(object);
        if (file != null) {
            if (!file.exists()) {
                this.loadRemoteObjectDescription(object, false);
            } else {
                properties = this.load(file);
            }
        }
        if (properties != null && load && properties.get((Object)ObjectProperty.notloaded) == Boolean.TRUE) {
            this.loadRemoteObjectDescription(object, load);
            properties = this.load(file);
        }
        return properties;
    }

    @Override
    public Map<ObjectProperty, Object> fetch(IRemoteObject object) {
        IStatus status;
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set(IRemoteObject.class, (Object)object);
        if (object instanceof SourceMember) {
            MemberPropertiesLoader loader = (MemberPropertiesLoader)((Object)ContextInjectionFactory.make(MemberPropertiesLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            status = loader.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            ObjectPropertiesLoader loader = (ObjectPropertiesLoader)((Object)ContextInjectionFactory.make(ObjectPropertiesLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            status = loader.run((IProgressMonitor)new NullProgressMonitor());
        }
        if (status.isOK()) {
            return this.get(object);
        }
        throw new RuntimeException("The properties for " + object.getName() + " could not be retrieved from the server.");
    }

    @Override
    public void update(IRemoteObject object) {
        this.loadRemoteObjectDescription(object, false);
    }

    private void loadRemoteObjectDescription(IRemoteObject object, boolean loadSynchronously) {
        if (object.getPath().contains("QTEMP.LIB")) {
            return;
        }
        this.logger.debug((miworkplace.common.debug.Option)Option.loading, "Determining type of properties to load (object or member) for " + object.getName());
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set(IRemoteObject.class, (Object)object);
        if (object instanceof SourceMember) {
            MemberPropertiesLoader loader = (MemberPropertiesLoader)((Object)ContextInjectionFactory.make(MemberPropertiesLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            if (loadSynchronously) {
                loader.run((IProgressMonitor)new NullProgressMonitor());
            } else {
                loader.schedule();
            }
        } else if (object instanceof StreamFile) {
            StreamFilePropertiesLoader loader = (StreamFilePropertiesLoader)((Object)ContextInjectionFactory.make(StreamFilePropertiesLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            if (loadSynchronously) {
                loader.run((IProgressMonitor)new NullProgressMonitor());
            } else {
                loader.schedule();
            }
        } else {
            ObjectPropertiesLoader loader = (ObjectPropertiesLoader)((Object)ContextInjectionFactory.make(ObjectPropertiesLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            if (loadSynchronously) {
                loader.run((IProgressMonitor)new NullProgressMonitor());
            } else {
                loader.schedule();
            }
        }
    }

    private Map<ObjectProperty, Object> load(File file) {
        XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
        xstream.setClassLoader(this.getClass().getClassLoader());
        String xml = "empty";
        try {
            xml = this.toString(file);
            Map map = (Map)xstream.fromXML(xml);
            return map;
        }
        catch (Exception e) {
            this.logger.error("Could not read object description properties file " + file.getAbsolutePath() + ". Error: ", (Throwable)e);
            this.logger.error("XML we tried to parse is " + xml, (Throwable)e);
            return null;
        }
    }

    private String toString(File pFile) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(pFile), "UTF-8");
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader bufReader = new BufferedReader(reader);){
            String line;
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void update(IRemoteObject object, ObjectProperty property, Object value) {
        Map<ObjectProperty, Object> properties = this.get(object);
        properties.put(property, value);
        File f = this.getObjectPropertiesFile(object);
        this.store(properties, f);
    }

    @Inject
    @Optional
    public void notifiedObjectDeleted(@UIEventTopic(value="miworkplace/object/deleted") Event event) {
        IRemoteObject object = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
        this.remove(object);
    }

    @Inject
    @Optional
    public void notifiedObjectRenamed(@EventTopic(value="miworkplace/object/renamed") Event event) {
        IRemoteObject oldObject = (IRemoteObject)event.getProperty("old.object");
        this.remove(oldObject);
        IRemoteObject newObject = (IRemoteObject)event.getProperty("new.object");
        this.get(newObject, true);
    }

    @Inject
    @Optional
    public void notifiedMemberRenamed(@EventTopic(value="miworkplace/member/renamed") Event event) {
        IRemoteObject oldMember = (IRemoteObject)event.getProperty("old.member");
        this.remove(oldMember);
        SourceMember newMember = (SourceMember)event.getProperty("new.member");
        this.get((IRemoteObject)newMember, true);
    }

    @Inject
    @Optional
    public void notifiedMemberMoved(@EventTopic(value="miworkplace/member/moved") Event event) {
        IRemoteObject oldMember = (IRemoteObject)event.getProperty("old.member");
        this.remove(oldMember);
        IRemoteObject newMember = (IRemoteObject)event.getProperty("new.member");
        this.loadRemoteObjectDescription(newMember, false);
    }

    @Inject
    @Optional
    public void notifiedObjectUpdated(@EventTopic(value="miworkplace/object/updated") Event event) {
        IRemoteObject object = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
        this.loadRemoteObjectDescription(object, false);
    }

    @Inject
    @Optional
    public void notifiedMemberUpdated(@EventTopic(value="miworkplace/member/updated") Event event) {
        SourceMember member = (SourceMember)event.getProperty("org.eclipse.e4.data");
        this.loadRemoteObjectDescription((IRemoteObject)member, false);
    }
}

