/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.lock;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.services.api.ILock;
import miworkplace.services.api.ILockService;
import miworkplace.services.lock.MemberLock;
import miworkplace.services.lock.ObjectLock;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LockService
implements ILockService,
EventHandler {
    private Map<IConnection, List<ILock>> fLocks = new HashMap<IConnection, List<ILock>>();
    private IConnectionUtilities connUtil;
    private Debug logger = Debug.getInstance();

    public void bindConnectionUtility(IConnectionUtilities connUtil) {
        this.connUtil = connUtil;
    }

    public void unbindConnectionUtility(IConnectionUtilities connUtil) {
        this.connUtil = null;
    }

    @Override
    public ILockService releaseAllLocks(IConnection conn) {
        if (this.getLocks(conn).isEmpty()) {
            this.logger.debug((Option)miworkplace.services.debug.Option.locking, "No locks held");
            return this;
        }
        for (ILock lock : this.getLocks(conn)) {
            try {
                lock.unlock(this.connUtil);
            }
            catch (Exception e) {
                Exception exception = new Exception(MessageFormat.format("Could not release lock on object {0}.", lock.getResourcePath()), e);
                this.logger.error(exception.getMessage(), (Throwable)exception);
            }
        }
        this.getLocks(conn).clear();
        return this;
    }

    private synchronized List<ILock> getLocks(IConnection pConn) {
        if (this.fLocks.get(pConn) == null) {
            this.fLocks.put(pConn, new ArrayList());
        }
        return this.fLocks.get(pConn);
    }

    @Override
    public ILock getLock(IConnection conn, String path) {
        for (ILock lock : this.getLocks(conn)) {
            if (!lock.getResourcePath().equals(path)) continue;
            return lock;
        }
        return null;
    }

    @Override
    public ILockService releaseLock(IConnection connection, String path) throws Exception {
        this.logger.debug((Option)miworkplace.services.debug.Option.locking, "Unlocking " + path);
        ArrayList<ILock> copyOfLocks = new ArrayList<ILock>(this.getLocks(connection));
        int lockCount = 0;
        for (ILock lock : copyOfLocks) {
            if (!lock.getResourcePath().equals(path)) continue;
            lock.unlock(this.connUtil);
            this.getLocks(connection).remove(lock);
            if (!this.logger.isOn((Option)miworkplace.services.debug.Option.locking)) continue;
            this.logger.debug((Option)miworkplace.services.debug.Option.locking, MessageFormat.format("We had the lock and removed it ({0}) {1}", ++lockCount, path));
        }
        if (lockCount == 0 && this.logger.isOn((Option)miworkplace.services.debug.Option.locking)) {
            this.logger.debug((Option)miworkplace.services.debug.Option.locking, "No lock found for " + path);
        }
        return this;
    }

    @Override
    public MemberLock lockMember(IConnection connection, String path) throws Exception {
        this.releaseLock(connection, path);
        MemberLock lock = new MemberLock(connection, path);
        lock.lock(this.connUtil);
        this.getLocks(connection).add(lock);
        return lock;
    }

    @Override
    public ObjectLock lockObject(IConnection connection, String path) throws Exception {
        this.releaseLock(connection, path);
        ObjectLock lock = new ObjectLock(connection, path);
        lock.lock(this.connUtil);
        this.getLocks(connection).add(lock);
        return lock;
    }

    @Override
    public ILockService.LockStatus isLocked(IConnection connection, String path) {
        for (ILock lock : this.getLocks(connection)) {
            if (!lock.getResourcePath().equals(path)) continue;
            this.logger.debug((Option)miworkplace.services.debug.Option.locking, "We own the lock on " + path);
            return ILockService.LockStatus.SELF;
        }
        try {
            if (this.connUtil.isMemberLocked(connection, path, new String[]{"*EXCL", "*EXCLRD"})) {
                return ILockService.LockStatus.OTHER;
            }
        }
        catch (Exception e) {
            try {
                this.logger.debug((Option)miworkplace.services.debug.Option.locking, "Could not get lock status. Assuming locked. " + path, (Throwable)e);
                return ILockService.LockStatus.OTHER;
            }
            catch (Exception e2) {
                this.logger.debug((Option)miworkplace.services.debug.Option.locking, "Someone else has a lock on " + path, (Throwable)e2);
                return ILockService.LockStatus.OTHER;
            }
        }
        this.logger.debug((Option)miworkplace.services.debug.Option.locking, "Nobody has a lock on " + path);
        return ILockService.LockStatus.FREE;
    }

    public void handleEvent(Event event) {
        IConnection connection;
        if (event.getTopic().equals("miworkplace/connection/disconnect")) {
            connection = (IConnection)event.getProperty("org.eclipse.e4.data");
            this.releaseAllLocks(connection);
        }
        if (event.getTopic().equals("miworkplace/connection/connected")) {
            connection = (IConnection)event.getProperty("org.eclipse.e4.data");
            this.reAssignLocks(connection);
        }
    }

    private synchronized void reAssignLocks(IConnection pConnection) {
        this.logger.traceEntry((Option)miworkplace.services.debug.Option.locking, new Object[]{"Start transferring locks"});
        List<ILock> locks = this.getLocks(pConnection);
        for (ILock lock : locks) {
            if (!lock.getConnection().equals(pConnection)) continue;
            this.logger.debug((Option)miworkplace.services.debug.Option.locking, "Removing stale lock on " + lock.getResourcePath());
            this.getLocks(pConnection).remove(lock);
            try {
                lock.lock(this.connUtil);
                this.addLock(pConnection, lock);
            }
            catch (Exception e) {
                this.logger.debug((Option)miworkplace.services.debug.Option.conn, e.getMessage(), (Throwable)e);
            }
        }
        this.logger.traceExit((Option)miworkplace.services.debug.Option.conn, (Object)"End of transferring locks.");
    }

    private void addLock(IConnection pConnection, ILock pLock) {
        while (this.getLocks(pConnection).contains(pLock)) {
            this.getLocks(pConnection).remove(pLock);
        }
        this.getLocks(pConnection).add(pLock);
    }
}

