/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.index;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.services.api.Index;
import miworkplace.services.api.IndexStore;
import miworkplace.services.api.Indexer;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;

public class InMemoryIndexStore
implements IndexStore,
EventHandler {
    private LogService logger;
    private List<Indexer> indexers = new LinkedList<Indexer>();
    private Map<String, Index> indexMap = new HashMap<String, Index>();

    public void bindLogService(LogService logger) {
        this.logger = logger;
    }

    public void unbindLogService(LogService logger) {
        this.logger = null;
    }

    @Override
    public void register(Indexer indexer) {
        if (!this.indexers.contains(indexer)) {
            this.indexers.add(indexer);
        }
    }

    @Override
    public void deregister(Indexer indexer) {
        this.indexers.remove(indexer);
    }

    @Override
    public void index(String connectionName, String ifsPath, Object indexSource) {
        Indexer indexer = null;
        if (indexSource == null) {
            return;
        }
        for (Indexer indxr : this.indexers) {
            if (!indxr.supportsIndexSource(indexSource)) continue;
            indexer = indxr;
            break;
        }
        if (indexer == null) {
            this.logger.log(4, "Class " + indexSource.getClass().getName() + " not supported for indexing.");
            return;
        }
        indexer.index(connectionName, ifsPath, indexSource);
    }

    @Override
    public Index get(String connectionName, String ifsPath) {
        return this.indexMap.get(EditorInputUriUtil.buildInputUri((String)connectionName, (String)ifsPath));
    }

    @Override
    public void add(String connectionName, String ifsPath, Index index) {
        this.indexMap.put(EditorInputUriUtil.buildInputUri((String)connectionName, (String)ifsPath), index);
    }

    public void handleEvent(Event event) {
        Object ast = event.getProperty("org.eclipse.e4.data");
        String inputUri = event.getProperty("inputUri").toString();
        String ifsPath = event.getProperty("memberPath").toString();
        String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
        this.index(connectionName, ifsPath, ast);
    }
}

