/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs.test;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import miworkplace.iledocs.Parser;
import miworkplace.iledocs.model.EscapeMessage;
import miworkplace.iledocs.model.IledocsModel;
import miworkplace.iledocs.model.Link;
import miworkplace.iledocs.model.Parameter;
import miworkplace.iledocs.model.Revision;
import miworkplace.iledocs.test.IledocsParameterizedTest;
import org.junit.Assert;
import org.junit.Test;

public class IledocsParserTest {
    private Parser parser = new Parser("\\");

    @Test
    public void test_minimum() {
        String text = this.load("iledocs02.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        Assert.assertEquals((Object)"Service program initialization", (Object)model.getTitle());
        Assert.assertEquals((Object)"String formattings are preloaded.", (Object)model.getDescription());
    }

    @Test
    public void test_author() {
        String text = this.load("iledocs01.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        Assert.assertEquals((Object)"Mihael Schmidt", (Object)model.getAuthor());
    }

    @Test
    public void test_date() {
        String text = this.load("iledocs01.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        Assert.assertEquals((Object)"20.03.2008", (Object)model.getDate());
    }

    @Test
    public void test_link() {
        String text = this.load("iledocs01.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        List<Link> links = model.getLinks();
        Assert.assertNotNull(links);
        Assert.assertEquals((long)2L, (long)links.size());
        Link link = links.get(0);
        Assert.assertEquals((Object)"http://www.json.org", (Object)link.getUrl());
        Assert.assertEquals((Object)"JSON", (Object)link.getTitle());
        link = links.get(1);
        Assert.assertEquals((Object)"http://www.rpgnextgen.com?content=json", (Object)link.getUrl());
        Assert.assertNull((Object)link.getTitle());
    }

    @Test
    public void test_returnValue() {
        String text = this.load("iledocs06.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        Assert.assertEquals((Object)"*on = JSON object contains key<br> *off = JSON object does not contain key", (Object)model.getReturnValue().getDescription());
    }

    @Test
    public void test_singleParameter() {
        String text = this.load("iledocs04.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        List<Parameter> parameters = model.getParameters();
        Assert.assertNotNull(parameters);
        Assert.assertEquals((long)1L, (long)parameters.size());
        Parameter parameter = parameters.get(0);
        Assert.assertEquals((Object)"Pointer to the JSON object", (Object)parameter.getDescription());
    }

    @Test
    public void test_multipleParameter() {
        String text = this.load("iledocs05.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        List<Parameter> parameters = model.getParameters();
        Assert.assertNotNull(parameters);
        Assert.assertEquals((long)2L, (long)parameters.size());
        Parameter parameter = parameters.get(0);
        Assert.assertEquals((Object)"Pointer to the JSON object", (Object)parameter.getDescription());
        parameter = parameters.get(1);
        Assert.assertEquals((Object)"Entry key", (Object)parameter.getDescription());
    }

    @Test
    public void test_interface() {
        String text = this.load("iledocs07.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        Assert.assertTrue((boolean)model.isFlagInterface());
    }

    @Test
    public void test_escapeMessages() {
        String text = this.load("iledocs08.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        List<EscapeMessage> escapeMessages = model.getEscapeMessages();
        Assert.assertNotNull(escapeMessages);
        Assert.assertEquals((long)2L, (long)escapeMessages.size());
        EscapeMessage escapeMessage = escapeMessages.get(0);
        Assert.assertEquals((Object)"CPF9898", (Object)escapeMessage.getId());
        Assert.assertEquals((Object)"Incomplete implementation", (Object)escapeMessage.getDescription());
        escapeMessage = escapeMessages.get(1);
        Assert.assertEquals((Object)"CPF9999", (Object)escapeMessage.getId());
        Assert.assertEquals((Object)"Error", (Object)escapeMessage.getDescription());
    }

    @Test
    public void test_revision() {
        String text = this.load("iledocs01.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        List<Revision> revisions = model.getRevisions();
        Assert.assertNotNull(revisions);
        Assert.assertEquals((long)8L, (long)revisions.size());
        Revision revision = revisions.get(0);
        Assert.assertEquals((Object)"27.01.2010", (Object)revision.getDate());
        Assert.assertEquals((Object)"Mihael Schmidt", (Object)revision.getAuthor());
        Assert.assertEquals((Object)"Added support for getting numbers with procedures json_getInt, json_getLong, json_getDouble no matter what the original type was (f. e. double value will be cast to int with json_getInt).", (Object)revision.getDescription());
        revision = revisions.get(1);
        Assert.assertEquals((Object)"13.02.2011", (Object)revision.getDate());
        Assert.assertEquals((Object)"Mihael Schmidt", (Object)revision.getAuthor());
        Assert.assertEquals((Object)"Fixed bug in remove procedure. Replaced string and hex constants with unicode constants.", (Object)revision.getDescription());
        revision = revisions.get(7);
        Assert.assertEquals((Object)"24.07.2012", (Object)revision.getDate());
        Assert.assertEquals((Object)"Hugo Cantor", (Object)revision.getAuthor());
        Assert.assertEquals((Object)"Bugfix: json_putString : wrong parameter value length from CEEDOD added new parm for length", (Object)revision.getDescription());
    }

    @Test
    public void test_warnings() {
        String text = this.load("iledocs11.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        List<String> warnings = model.getWarnings();
        Assert.assertNotNull(warnings);
        Assert.assertEquals((long)2L, (long)warnings.size());
        Assert.assertEquals((Object)"Warning One Multiple Lines", (Object)warnings.get(0));
        Assert.assertEquals((Object)"Warning Two", (Object)warnings.get(1));
    }

    @Test
    public void test_infos() {
        String text = this.load("iledocs10.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = this.parser.parse(list, new IledocsModel());
        List<String> infos = model.getInfos();
        Assert.assertNotNull(infos);
        Assert.assertEquals((long)2L, (long)infos.size());
        Assert.assertEquals((Object)"The lower border must be passed as the first value followed by the upper border.", (Object)infos.get(0));
        Assert.assertEquals((Object)"Dummy info statement", (Object)infos.get(1));
    }

    @Test
    public void test_mixedPrefix() {
        String text = this.load("iledocs13.txt");
        List<String> list = Arrays.asList(text.split("\n"));
        IledocsModel model = new Parser("$").parse(list, new IledocsModel());
        Assert.assertEquals((Object)"Mixed ILEDocs Prefix Test", (Object)model.getTitle());
        Assert.assertEquals((Object)"Mihael Schmidt", (Object)model.getAuthor());
        Assert.assertEquals((Object)"29.07.2018", (Object)model.getDate());
        List<String> infos = model.getInfos();
        Assert.assertNotNull(infos);
        Assert.assertEquals((long)1L, (long)infos.size());
        Assert.assertEquals((Object)"This is an info block declared with a custom prefix.", (Object)infos.get(0));
    }

    private String load(String testcase) {
        URL resource = IledocsParameterizedTest.class.getClassLoader().getResource("testcases/" + testcase);
        File testCase = new File(resource.getPath());
        try {
            return new Scanner(new FileInputStream(testCase)).useDelimiter("\\A").next();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

