/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import miworkplace.iledocs.Parser;
import miworkplace.iledocs.model.IledocsModel;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IledocsParameterizedTest {
    private Parser parser = new Parser("\\");
    private String testcase;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> supplyTestParameters() {
        String[] listTestcases = IledocsParameterizedTest.listTestcases();
        Object[][] parameters = new Object[listTestcases.length][1];
        int i = 0;
        while (i < listTestcases.length) {
            parameters[i][0] = listTestcases[i];
            ++i;
        }
        return Arrays.asList(parameters);
    }

    public IledocsParameterizedTest(String testcase) {
        this.testcase = testcase;
    }

    @Test
    public void test() {
        String text = this.load(this.testcase);
        List<String> list = Arrays.asList(text.split("\n"));
        this.parser.parse(list, new IledocsModel());
    }

    private static String[] listTestcases() {
        URL resource = IledocsParameterizedTest.class.getClassLoader().getResource("testcases");
        File testcaseDir = new File(resource.getPath());
        String[] testcaseNames = testcaseDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".txt");
            }
        });
        return testcaseNames;
    }

    private String load(String testcase) {
        URL resource = IledocsParameterizedTest.class.getClassLoader().getResource("testcases/" + testcase);
        File testCase = new File(resource.getPath());
        try {
            return new Scanner(new FileInputStream(testCase)).useDelimiter("\\A").next();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

