/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs.rpg;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import miworkplace.ast.rpg.AST;
import miworkplace.ast.rpg.ASTBuilder;
import miworkplace.ast.rpg.Parameter;
import miworkplace.ast.rpg.Program;
import miworkplace.ast.rpg.iledocs.ILEDocs;
import miworkplace.ast.rpg.iledocs.Link;
import miworkplace.common.model.IConnection;
import miworkplace.iledocs.IledocsBuilder;
import miworkplace.iledocs.model.Procedure;
import miworkplace.iledocs.model.ReturnValue;
import miworkplace.iledocs.model.Revision;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;

public class RpgIledocsBuilder
implements IledocsBuilder {
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    private Boolean iledocsIncludeCopyBooks = Boolean.FALSE;
    private Boolean iledocsIncludeFiles = Boolean.FALSE;

    @PostConstruct
    public void postConstruct() {
        this.iledocsIncludeCopyBooks = this.applicationPreferences.getBoolean("miworkplace.iledocs.pref.include.copybooks", Boolean.FALSE.booleanValue());
        this.iledocsIncludeFiles = this.applicationPreferences.getBoolean("miworkplace.iledocs.pref.include.files", Boolean.FALSE.booleanValue());
    }

    @Override
    public miworkplace.iledocs.model.Program build(IConnection connection, String code) throws Exception {
        ILEDocs[] docs;
        AST ast = ASTBuilder.buildAST((String)code);
        miworkplace.iledocs.model.Program program = new miworkplace.iledocs.model.Program();
        ILEDocs[] iLEDocsArray = docs = ast.getDocumentation();
        int n = docs.length;
        int n2 = 0;
        while (n2 < n) {
            ILEDocs iledocs = iLEDocsArray[n2];
            if (iledocs.getDocumentedObject() instanceof Program) {
                this.composeProgram(iledocs, program, ast);
            } else {
                boolean cfr_ignored_0 = iledocs.getDocumentedObject() instanceof miworkplace.ast.rpg.Procedure;
            }
            ++n2;
        }
        if (this.iledocsIncludeCopyBooks.booleanValue() && ast.getIncludes() != null && ast.getIncludes().length > 0) {
            program.setIncludes(new LinkedList<String>());
            iLEDocsArray = ast.getIncludes();
            n = iLEDocsArray.length;
            n2 = 0;
            while (n2 < n) {
                ILEDocs include = iLEDocsArray[n2];
                program.getIncludes().add(include.getIncludedFile());
                ++n2;
            }
        }
        this.iledocsIncludeFiles.booleanValue();
        return program;
    }

    private void composeProgram(ILEDocs iledocs, miworkplace.iledocs.model.Program program, AST ast) {
        int n;
        int n2;
        Link[] linkArray;
        program.setProject(iledocs.getProject());
        program.setAuthor(iledocs.getAuthor());
        program.setTitle(iledocs.getBriefDescription());
        program.setDate(iledocs.getDate());
        program.setDeprecated(iledocs.getDeprecatedDescription());
        program.setDescription(iledocs.getDescription());
        if (iledocs.getWarnings() != null) {
            program.setWarnings(Arrays.asList(iledocs.getWarnings()));
        }
        if (iledocs.getInfos() != null) {
            program.setInfos(Arrays.asList(iledocs.getInfos()));
        }
        if (iledocs.getLinks() != null) {
            linkArray = iledocs.getLinks();
            n2 = linkArray.length;
            n = 0;
            while (n < n2) {
                Link rpgLink = linkArray[n];
                program.getLinks().add(new miworkplace.iledocs.model.Link(rpgLink.getUrl(), rpgLink.getDescription()));
                ++n;
            }
        }
        if (iledocs.getParameterDescriptions() != null) {
            Parameter[] astProgramParameters = ast.getProgram().getParameters();
            int x = 1;
            String[] stringArray = iledocs.getParameterDescriptions();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String desc = stringArray[n4];
                miworkplace.iledocs.model.Parameter parameter = new miworkplace.iledocs.model.Parameter();
                if (astProgramParameters.length >= x) {
                    parameter.setName(astProgramParameters[x - 1].getName());
                } else {
                    parameter.setName("param" + x);
                }
                parameter.setDescription(desc);
                program.getParameters().add(parameter);
                ++x;
                ++n4;
            }
        }
        if (iledocs.getRevisions() != null && iledocs.getRevisions().length > 0) {
            linkArray = iledocs.getRevisions();
            n2 = linkArray.length;
            n = 0;
            while (n < n2) {
                Link revision = linkArray[n];
                Revision rev = new Revision();
                rev.setAuthor(revision.getAuthor());
                rev.setDate(revision.getDate());
                rev.setDescription(revision.getDescription());
                program.getRevisions().add(rev);
                ++n;
            }
        }
    }

    private Procedure composeProcedure(ILEDocs iledocs, miworkplace.ast.rpg.Procedure procedure, AST ast) {
        int n;
        Link[] linkArray;
        Procedure p = new Procedure();
        p.setAuthor(iledocs.getAuthor());
        p.setDate(iledocs.getDate());
        p.setDeprecated(iledocs.getDeprecatedDescription());
        p.setDescription(iledocs.getDescription());
        if (iledocs.getWarnings() != null) {
            p.setWarnings(Arrays.asList(iledocs.getWarnings()));
        }
        if (iledocs.getInfos() != null) {
            p.setInfos(Arrays.asList(iledocs.getInfos()));
        }
        if (iledocs.getLinks() != null) {
            linkArray = iledocs.getLinks();
            n = linkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Link link = linkArray[n2];
                p.getLinks().add(new miworkplace.iledocs.model.Link(link.getUrl(), link.getDescription()));
                ++n2;
            }
        }
        p.setName(procedure.getName());
        if (iledocs.getParameterDescriptions() != null) {
            if (p.getParameters() == null) {
                p.setParameters(new ArrayList<miworkplace.iledocs.model.Parameter>());
            }
            int x = 1;
            String[] stringArray = iledocs.getParameterDescriptions();
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String desc = stringArray[n];
                miworkplace.iledocs.model.Parameter parameter = new miworkplace.iledocs.model.Parameter();
                parameter.setName("parameter" + x);
                parameter.setDescription(desc);
                p.getParameters().add(parameter);
                ++x;
                ++n;
            }
        }
        p.setReturnValue(this.mapReturnValue(procedure.getReturnValue()));
        if (iledocs.getRevisions() != null && iledocs.getRevisions().length > 0) {
            linkArray = iledocs.getRevisions();
            n = linkArray.length;
            int n4 = 0;
            while (n4 < n) {
                Link revision = linkArray[n4];
                Revision rev = new Revision();
                rev.setAuthor(revision.getAuthor());
                rev.setDate(revision.getDate());
                rev.setDescription(revision.getDescription());
                p.getRevisions().add(rev);
                ++n4;
            }
        }
        p.setTitle(iledocs.getBriefDescription());
        p.setWarnings(Arrays.asList(iledocs.getWarnings()));
        return p;
    }

    private ReturnValue mapReturnValue(miworkplace.ast.rpg.ReturnValue returnValue) {
        return null;
    }
}

