/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import miworkplace.i18n.Messages;
import miworkplace.ui.pref.api.IPreferenceNode;
import miworkplace.ui.pref.api.IPreferenceProvider;
import miworkplace.ui.pref.api.IPreferencesService;
import miworkplace.ui.pref.api.Preference;
import miworkplace.ui.pref.api.PreferenceNode;

public class PreferenceProvider
implements IPreferenceProvider {
    private List<IPreferenceNode> preferenceNodes = new LinkedList<IPreferenceNode>();
    private IPreferencesService service;

    void activate() {
        PreferenceNode preferenceNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.iledocs").setName("ILEDocs");
        preferenceNode.setPreferences(this.buildPreferences());
        this.preferenceNodes.add((IPreferenceNode)preferenceNode);
        if (this.service != null) {
            for (IPreferenceNode n : this.preferenceNodes) {
                this.service.add(n);
            }
        }
    }

    private Set<Preference> buildPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        Preference preference = new Preference();
        preference.setId("miworkplace.iledocs.pref.server.url");
        preference.setType(String.class);
        preference.setName(Messages.iledocs_pref_url);
        preference.setValue("");
        preference.setOrder(Integer.valueOf(1));
        preference.setWidth(Integer.valueOf(400));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.iledocs.pref.default");
        preference.setType(String.class);
        preference.setName(Messages.iledocs_pref_default_project);
        preference.setValue("IBM i");
        preference.setOrder(Integer.valueOf(4));
        preference.setWidth(Integer.valueOf(250));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.iledocs.pref.prefix");
        preference.setType(String.class);
        preference.setName(Messages.iledocs_pref_prefix);
        preference.setValue("\\");
        preference.setOrder(Integer.valueOf(5));
        preference.setWidth(Integer.valueOf(100));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.iledocs.pref.include.copybooks");
        preference.setType(Boolean.class);
        preference.setName(Messages.iledocs_pref_copybooks);
        preference.setValue(Boolean.FALSE.toString());
        preference.setOrder(Integer.valueOf(6));
        preference.setDescription(Messages.iledocs_pref_copybooks_desc);
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.iledocs.pref.include.files");
        preference.setType(Boolean.class);
        preference.setName(Messages.iledocs_pref_files);
        preference.setValue(Boolean.FALSE.toString());
        preference.setOrder(Integer.valueOf(7));
        preferences.add(preference);
        return preferences;
    }

    public void bindPreferenceService(IPreferencesService service) {
        this.service = service;
        if (!this.preferenceNodes.isEmpty()) {
            for (IPreferenceNode n : this.preferenceNodes) {
                service.add(n);
            }
        }
    }

    public void unbindPreferenceService(IPreferencesService service) {
        this.service = null;
    }
}

