/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import miworkplace.iledocs.model.Constant;
import miworkplace.iledocs.model.EscapeMessage;
import miworkplace.iledocs.model.IledocsModel;
import miworkplace.iledocs.model.Link;
import miworkplace.iledocs.model.Parameter;
import miworkplace.iledocs.model.ReturnValue;
import miworkplace.iledocs.model.Revision;
import miworkplace.iledocs.model.Variable;
import org.apache.commons.lang3.StringUtils;

public class Parser {
    private Set<String> tags = new HashSet<String>();
    private final String keywordPrefix;

    public Parser(String keywordPrefix) {
        this.keywordPrefix = keywordPrefix;
        this.init();
    }

    private void init() {
        IledocsModel.Tag tag;
        IledocsModel.Tag[] tagArray = IledocsModel.Tag.values();
        int n = tagArray.length;
        int n2 = 0;
        while (n2 < n) {
            tag = tagArray[n2];
            this.tags.add("@" + tag.keyword());
            this.tags.add("\\" + tag.keyword());
            ++n2;
        }
        if (!this.keywordPrefix.equals("@") && !this.keywordPrefix.equals("\\")) {
            tagArray = IledocsModel.Tag.values();
            n = tagArray.length;
            n2 = 0;
            while (n2 < n) {
                tag = tagArray[n2];
                this.tags.add(this.keywordPrefix + tag.keyword());
                ++n2;
            }
        }
    }

    public Constant parse(List<String> text, Constant constant) {
        IledocsModel model = this.parse(text, new IledocsModel());
        if (StringUtils.isNotBlank((CharSequence)model.getDescription()) && StringUtils.isNotBlank((CharSequence)model.getTitle())) {
            constant.setDescription(model.getTitle() + " &mdash; " + model.getDescription());
        } else if (StringUtils.isBlank((CharSequence)model.getDescription())) {
            constant.setDescription(model.getTitle());
        } else {
            constant.setDescription(model.getDescription());
        }
        return constant;
    }

    public Variable parse(List<String> text, Variable variable) {
        IledocsModel model = this.parse(text, new IledocsModel());
        if (StringUtils.isNotBlank((CharSequence)model.getDescription()) && StringUtils.isNotBlank((CharSequence)model.getTitle())) {
            variable.setDescription(model.getTitle() + " &mdash; " + model.getDescription());
        } else if (StringUtils.isBlank((CharSequence)model.getDescription())) {
            variable.setDescription(model.getTitle());
        } else {
            variable.setDescription(model.getDescription());
        }
        return variable;
    }

    public IledocsModel parse(List<String> text, IledocsModel model) {
        String line;
        StringBuilder description = new StringBuilder();
        ListIterator<String> iterator = text.listIterator();
        while (iterator.hasNext()) {
            line = StringUtils.stripEnd((String)iterator.next(), (String)" ");
            if (line.isEmpty()) continue;
            if (line.startsWith(this.keywordPrefix + IledocsModel.Tag.Brief.keyword())) {
                iterator = text.listIterator();
                break;
            }
            if (line.startsWith("@" + IledocsModel.Tag.Brief.keyword())) {
                iterator = text.listIterator();
                break;
            }
            if (line.startsWith("\\" + IledocsModel.Tag.Brief.keyword())) {
                iterator = text.listIterator();
                break;
            }
            if (!iterator.hasNext() || StringUtils.isBlank((CharSequence)iterator.next())) {
                model.setTitle(line);
                break;
            }
            iterator = text.listIterator();
            break;
        }
        while (iterator.hasNext()) {
            line = iterator.next();
            String[] parts = line.split(" ", 2);
            if (parts.length <= 0) continue;
            if (this.tags.contains(parts[0])) {
                String value = parts.length == 2 ? parts[1] : null;
                this.processTag(parts[0], value, model, iterator);
                continue;
            }
            description.append(line);
            description.append(" \n");
        }
        model.setDescription(StringUtils.strip((String)description.toString(), (String)"\n "));
        return model;
    }

    private void processTag(String keyword, String value, IledocsModel model, ListIterator<String> iterator) {
        value = value == null ? "" : value.trim();
        IledocsModel.Tag tag = this.identifyTag(keyword);
        if (tag == null) {
            return;
        }
        switch (tag) {
            case Author: {
                model.setAuthor(value);
                break;
            }
            case Brief: {
                model.setTitle(value);
                break;
            }
            case Date: {
                model.setDate(value);
                break;
            }
            case Deprecated: {
                model.setDeprecated(this.getMultiLineValue(value, iterator));
                break;
            }
            case Info: {
                model.getInfos().add(this.getMultiLineValue(value, iterator));
                break;
            }
            case Warning: {
                model.getWarnings().add(this.getMultiLineValue(value, iterator));
                break;
            }
            case Link: {
                String linkValue = this.getMultiLineValue(value, iterator);
                String[] parts = linkValue.split(" ", 2);
                if (parts.length == 1) {
                    model.getLinks().add(new Link(linkValue));
                    break;
                }
                if (parts.length != 2) break;
                model.getLinks().add(new Link(parts[0], parts[1]));
                break;
            }
            case Parameter: {
                Parameter parameter = new Parameter();
                parameter.setDescription(this.getMultiLineValue(value, iterator));
                model.getParameters().add(parameter);
                break;
            }
            case Project: {
                model.setProject(value);
                break;
            }
            case Revision: {
                Revision rev = new Revision();
                model.getRevisions().add(rev);
                String[] revHead = value.split(" ", 2);
                if (revHead.length == 1) {
                    rev.setDate(revHead[0]);
                } else if (revHead.length == 2) {
                    rev.setDate(revHead[0]);
                    rev.setAuthor(revHead[1]);
                }
                rev.setDescription(this.getMultiLineValue("", iterator).trim());
                break;
            }
            case Interface: {
                model.setFlagInterface(true);
                break;
            }
            case Implements: {
                model.setImplementation(this.getMultiLineValue(value, iterator));
                break;
            }
            case Return: {
                if (model.getReturnValue() == null) {
                    model.setReturnValue(new ReturnValue());
                }
                model.getReturnValue().setDescription(this.getMultiLineValue(value, iterator));
                break;
            }
            case EscapeMessage: {
                EscapeMessage message = new EscapeMessage();
                model.getEscapeMessages().add(message);
                String[] messageHead = value.split(" ", 2);
                if (messageHead.length == 1) {
                    message.setId(messageHead[0]);
                } else if (messageHead.length == 2) {
                    message.setId(messageHead[0]);
                    message.setDescription(messageHead[1]);
                }
                String extendedDescription = this.getMultiLineValue("", iterator).trim();
                String description = StringUtils.defaultString((String)message.getDescription()) + " " + extendedDescription;
                message.setDescription(description.trim());
                break;
            }
            case Title: {
                model.setTitle(value);
                break;
            }
            case Version: {
                model.setVersion(value);
                break;
            }
        }
    }

    private String getMultiLineValue(String startValue, ListIterator<String> iterator) {
        StringBuilder sb = new StringBuilder(startValue);
        sb.append(" ");
        while (iterator.hasNext()) {
            String value = iterator.next().trim();
            String[] parts = value.split(" ", 2);
            if (parts.length > 0 && this.tags.contains(parts[0])) {
                iterator.previous();
                break;
            }
            sb.append(StringUtils.stripEnd((String)value, null));
            sb.append(" ");
        }
        return StringUtils.stripEnd((String)sb.toString(), null);
    }

    private IledocsModel.Tag identifyTag(String keyword) {
        String strippedKeyword = keyword.substring(1);
        IledocsModel.Tag[] tagArray = IledocsModel.Tag.values();
        int n = tagArray.length;
        int n2 = 0;
        while (n2 < n) {
            IledocsModel.Tag tag = tagArray[n2];
            if (tag.keyword().equals(strippedKeyword)) {
                return tag;
            }
            ++n2;
        }
        return null;
    }
}

