/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.log.pref;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import miworkplace.log.pref.PreferenceConstants;
import miworkplace.ui.pref.api.IPreferenceNode;
import miworkplace.ui.pref.api.IPreferencesService;
import miworkplace.ui.pref.api.Preference;
import miworkplace.ui.pref.api.PreferenceNode;
import miworkplace.ui.pref.api.SelectionPreference;

public class PreferenceProvider {
    private List<IPreferenceNode> preferenceNodes = new LinkedList<IPreferenceNode>();
    private IPreferencesService service;

    void activate() {
        PreferenceNode node = (PreferenceNode)new PreferenceNode().setId("miworkplace.log").setName("Logging").setDescription("This settings will change the logging of the application. The application log can be found in the workspace folder under <workspace>/.metadata/.application.log.");
        node.setPreferences(this.buildPreferences());
        this.preferenceNodes.add((IPreferenceNode)node);
        for (IPreferenceNode n : this.preferenceNodes) {
            this.service.add(n);
        }
    }

    private Set<Preference> buildPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        SelectionPreference preference = new SelectionPreference();
        preference.setId("miworkplace.log.scope");
        preference.setType(Set.class);
        preference.setName("Scope");
        preference.setValue(PreferenceConstants.Scope.all.name());
        preference.addSuggestion(PreferenceConstants.Scope.all.name());
        preference.addSuggestion(PreferenceConstants.Scope.application.name());
        preferences.add((Preference)preference);
        preference = new SelectionPreference();
        preference.setId("miworkplace.log.level");
        preference.setType(Set.class);
        preference.setName("Level");
        preference.setValue(PreferenceConstants.Level.error.name());
        preference.addSuggestion(PreferenceConstants.Level.debug.name());
        preference.addSuggestion(PreferenceConstants.Level.info.name());
        preference.addSuggestion(PreferenceConstants.Level.warn.name());
        preference.addSuggestion(PreferenceConstants.Level.error.name());
        preferences.add((Preference)preference);
        return preferences;
    }

    public void bindPreferenceService(IPreferencesService service) {
        this.service = service;
    }

    public void unbindPreferenceService(IPreferencesService service) {
        this.service = null;
    }
}

