/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core;

import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.ResourcePool;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class LinePiece
implements PrintPiece {
    private final Device device;
    private final Point size;
    private final RGB rgb;

    LinePiece(Device device, Point size, RGB rgb) {
        this.device = device;
        this.size = size;
        this.rgb = rgb;
    }

    @Override
    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    @Override
    public void paint(GC gc, int x, int y) {
        Color oldBackground = gc.getBackground();
        Point size = this.getSize();
        try {
            gc.setBackground(ResourcePool.forDevice(this.device).getColor(this.rgb));
            gc.fillRectangle(x, y, size.x, size.y);
        }
        finally {
            gc.setBackground(oldBackground);
        }
    }

    @Override
    public void dispose() {
    }
}

