/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.template.sync;

import java.io.File;
import java.io.FileReader;
import java.net.URI;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.editor.ITemplateLoader;
import miworkplace.ui.editor.ITemplateService;
import miworkplace.ui.editor.Template;

public class FileTemplateLoader
implements ITemplateLoader {
    private ITemplateService service;

    public FileTemplateLoader(ITemplateService service) {
        this.service = service;
    }

    @Override
    public List<Template> load(URI uri) throws Exception {
        File f = new File(uri);
        if (!f.exists()) {
            throw new RuntimeException(String.format(Messages.editor_template_loader_notexist, uri.getPath()));
        }
        if (!f.canRead()) {
            throw new RuntimeException(String.format(Messages.editor_template_loader_noread, uri.getPath()));
        }
        return this.service.deserialize(new FileReader(f));
    }

    @Override
    public String getSupportedProtocol() {
        return "file";
    }
}

