/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.template;

import miworkplace.ui.editor.Template;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class TemplateViewerComparator
extends ViewerComparator {
    public static final boolean SORT_ASCENDING = false;
    public static final boolean SORT_DESCENDING = true;
    public static final int SORT_NAME = 1;
    public static final int SORT_CONTEXT = 2;
    public static final int SORT_CATEGORY = 3;
    public static final int SORT_DESCRIPTION = 4;
    private int criteria = 1;
    private boolean sortDirection = true;

    public int compare(Viewer viewer, Object obj1, Object obj2) {
        Template t1 = (Template)obj1;
        Template t2 = (Template)obj2;
        int retVal = 1;
        switch (this.getCriteria()) {
            case 1: {
                retVal = t1.getName().compareTo(t2.getName());
                break;
            }
            case 2: {
                retVal = t1.getContext().compareTo(t2.getContext());
                break;
            }
            case 3: {
                retVal = StringUtils.defaultString((String)t1.getCategory()).compareTo(StringUtils.defaultString((String)t2.getCategory()));
                break;
            }
            case 4: {
                retVal = StringUtils.defaultString((String)t1.getDescription()).compareTo(StringUtils.defaultString((String)t2.getDescription()));
                break;
            }
            default: {
                retVal = 1;
            }
        }
        if (this.isSortDescending()) {
            retVal *= -1;
        }
        return retVal;
    }

    public boolean isSortDescending() {
        return this.sortDirection;
    }

    public boolean getSortDirection() {
        return this.sortDirection;
    }

    public int getCriteria() {
        return this.criteria;
    }

    public TemplateViewerComparator setCriteria(int criteria) {
        this.criteria = criteria;
        return this;
    }

    public boolean isSortDirection() {
        return this.sortDirection;
    }

    public TemplateViewerComparator setSortDirection(boolean sortDirection) {
        this.sortDirection = sortDirection;
        return this;
    }

    public String toString() {
        return "TemplateViewerComparator [criteria=" + this.criteria + ", sortDirection=" + this.sortDirection + "]";
    }
}

