/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.pref;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.model.ContentType;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.ui.pref.api.PreferenceNode;
import miworkplace.ui.pref.api.PreferencePage;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.prefs.Preferences;

class ContentTypesPreferencePage
extends PreferencePage {
    private IContentTypeRegistry registry;
    private PreferenceNode node;
    private ListViewer mappingList;
    private ListViewer ctList;
    private Button add;
    private Button edit;
    private Button remove;
    private List<String> mappingListInput = new LinkedList<String>();
    private ContentType currentContentType;

    public ContentTypesPreferencePage(Composite parent, PreferenceNode node, IContentTypeRegistry registry) {
        super(parent, 0);
        this.node = node;
        this.registry = registry;
        this.setLayout((Layout)new FillLayout());
        this.init((Composite)this);
    }

    private void init(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 20;
        layout.marginWidth = 25;
        form.getBody().setLayout((Layout)layout);
        form.setText(Messages.editor_pref_contypes_name);
        Label description = toolkit.createLabel(form.getBody(), this.node.getDescription(), 64);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)description, 15);
        layoutData.left = new FormAttachment(0);
        Label l1 = toolkit.createLabel(form.getBody(), Messages.editor_pref_contypes_form_ct);
        l1.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)l1, 15);
        layoutData.bottom = new FormAttachment(60);
        layoutData.left = new FormAttachment((Control)l1, 0, 16384);
        layoutData.right = new FormAttachment(100);
        this.ctList = new ListViewer(form.getBody(), 516);
        this.ctList.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.ctList.getControl().setLayoutData((Object)layoutData);
        this.ctList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ctList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ContentType) {
                    return ((ContentType)element).getName();
                }
                return super.getText(element);
            }
        });
        LinkedList contentTypes = new LinkedList(this.registry.list());
        Collections.sort(contentTypes, new Comparator<ContentType>(){

            @Override
            public int compare(ContentType ct1, ContentType ct2) {
                return ct1.getName().compareTo(ct2.getName());
            }
        });
        this.ctList.setInput(contentTypes);
        this.ctList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ContentTypesPreferencePage.this.currentContentType = event.getSelection() != null && !event.getSelection().isEmpty() ? (ContentType)((IStructuredSelection)event.getSelection()).getFirstElement() : null;
                ContentTypesPreferencePage.this.updateMappingsList();
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment(this.ctList.getControl(), 15);
        layoutData.left = new FormAttachment((Control)l1, 0, 16384);
        Label l2 = toolkit.createLabel(form.getBody(), Messages.editor_pref_contypes_form_ctass);
        l2.setLayoutData((Object)layoutData);
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)l2, 15);
        layoutData.right = new FormAttachment(100);
        layoutData.width = 80;
        this.add = toolkit.createButton(form.getBody(), Messages.common_add, 8);
        this.add.setLayoutData((Object)layoutData);
        this.add.setEnabled(false);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(ContentTypesPreferencePage.this.add.getShell(), Messages.editor_pref_contypes_add, Messages.editor_pref_contypes_add_msg, "", null);
                if (dialog.open() == 0) {
                    String mapping = dialog.getValue().trim();
                    if (!ContentTypesPreferencePage.this.currentContentType.getMappings().contains(mapping)) {
                        ContentTypesPreferencePage.this.currentContentType.getMappings().add(mapping);
                        ContentTypesPreferencePage.this.updateMappingsList();
                    }
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.add, 5);
        layoutData.left = new FormAttachment((Control)this.add, 0, 16384);
        layoutData.right = new FormAttachment(100);
        this.edit = toolkit.createButton(form.getBody(), Messages.common_edit, 8);
        this.edit.setLayoutData((Object)layoutData);
        this.edit.setEnabled(false);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ContentTypesPreferencePage.this.mappingList.getSelection() == null || ContentTypesPreferencePage.this.mappingList.getSelection().isEmpty()) {
                    return;
                }
                Object selectedMapping = ((IStructuredSelection)ContentTypesPreferencePage.this.mappingList.getSelection()).getFirstElement();
                if (selectedMapping == null) {
                    return;
                }
                InputDialog dialog = new InputDialog(ContentTypesPreferencePage.this.add.getShell(), Messages.editor_pref_contypes_edit, Messages.editor_pref_contypes_edit_msg, selectedMapping.toString(), null);
                if (dialog.open() == 0) {
                    ContentTypesPreferencePage.this.currentContentType.getMappings().remove(selectedMapping);
                    String editedMapping = dialog.getValue().trim();
                    if (!ContentTypesPreferencePage.this.currentContentType.getMappings().contains(editedMapping)) {
                        ContentTypesPreferencePage.this.currentContentType.getMappings().add(editedMapping);
                    }
                    ContentTypesPreferencePage.this.updateMappingsList();
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.edit, 5);
        layoutData.left = new FormAttachment((Control)this.edit, 0, 16384);
        layoutData.right = new FormAttachment(100);
        this.remove = toolkit.createButton(form.getBody(), Messages.common_remove, 8);
        this.remove.setLayoutData((Object)layoutData);
        this.remove.setEnabled(false);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ContentTypesPreferencePage.this.ctList.getSelection() != null && !ContentTypesPreferencePage.this.ctList.getSelection().isEmpty() && ContentTypesPreferencePage.this.mappingList.getSelection() != null && !ContentTypesPreferencePage.this.mappingList.getSelection().isEmpty()) {
                    Object mapping = ((IStructuredSelection)ContentTypesPreferencePage.this.mappingList.getSelection()).getFirstElement();
                    ContentTypesPreferencePage.this.currentContentType.getMappings().remove(mapping);
                    ContentTypesPreferencePage.this.updateMappingsList();
                }
            }
        });
        layoutData = new FormData();
        layoutData.top = new FormAttachment((Control)this.add, 0, 128);
        layoutData.bottom = new FormAttachment(100);
        layoutData.left = new FormAttachment((Control)l1, 0, 16384);
        layoutData.right = new FormAttachment((Control)this.add, -10, 16384);
        this.mappingList = new ListViewer(form.getBody(), 516);
        this.mappingList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mappingList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mappingList.getControl().setLayoutData((Object)layoutData);
        this.mappingList.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.mappingList.setInput(this.mappingListInput);
        toolkit.paintBordersFor(form.getBody());
    }

    public void save(IEclipsePreferences preferences) {
        Preferences node = preferences.node("contenttypes");
        for (ContentType contentType : this.registry.list()) {
            node.put(contentType.getId(), this.serializeMappings(contentType));
        }
    }

    private void updateMappingsList() {
        ISelection selection = this.ctList.getSelection();
        if (selection != null) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            ContentType type = (ContentType)element;
            this.mappingListInput.clear();
            this.mappingListInput.addAll(type.getMappings());
            Collections.sort(this.mappingListInput);
        } else {
            this.mappingListInput.clear();
        }
        this.add.setEnabled(!selection.isEmpty());
        this.edit.setEnabled(!selection.isEmpty());
        this.remove.setEnabled(!selection.isEmpty());
        this.mappingList.refresh();
    }

    private String serializeMappings(ContentType contentType) {
        return StringUtils.join((Iterable)contentType.getMappings(), (String)"\";\"");
    }

    public boolean isValid() {
        return true;
    }
}

