/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.include;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.HashMap;
import miworkplace.ast.rpg.ASTBuilder;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.text.RpgSyntaxTypeChecker;
import miworkplace.extra.xstream.XStream;
import miworkplace.notifications.Notifier;
import miworkplace.ui.editor.include.IIncludeService;
import miworkplace.ui.editor.include.IncludeData;
import miworkplace.ui.editor.rpg.ast.Parser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class IncludeService
implements IIncludeService {
    private IPath bundleStateLocation;
    private HashMap<IncludeMapKey, IncludeData> includeMap = new HashMap();
    private Debug logger = Debug.getInstance();
    private EventAdmin eventAdmin;

    public void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void unbindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    public void activate(BundleContext bundleContext) {
        this.bundleStateLocation = Platform.getStateLocation((Bundle)bundleContext.getBundle());
    }

    private File getIncludeFile(String connectionName, String sourcePath, String includePath) {
        IPath path = null;
        path = sourcePath.equals(includePath) ? this.bundleStateLocation.append("includes").append(connectionName).append(includePath) : this.bundleStateLocation.append("includes").append(connectionName).append(sourcePath + ".source").append(includePath);
        return path.toFile();
    }

    @Override
    public boolean containsInclude(String connectionName, String sourcePath, String includePath) {
        File includeFile = this.getIncludeFile(connectionName, sourcePath, includePath);
        if (includeFile.exists()) {
            return true;
        }
        return this.includeMap.containsKey(new IncludeMapKey(connectionName, sourcePath, includePath));
    }

    @Override
    public IncludeData getIncludeData(String connectionName, String sourcePath, String includePath) {
        this.logger.debug((Option)miworkplace.ui.editor.debug.Option.loading, "Getting include data for " + includePath);
        IncludeMapKey includeMapKey = new IncludeMapKey(connectionName, sourcePath, includePath);
        if (!this.includeMap.containsKey(includeMapKey)) {
            this.loadIncludeData(connectionName, sourcePath, includePath);
        }
        return this.includeMap.get(includeMapKey);
    }

    private void loadIncludeData(String connectionName, String sourcePath, String includePath) {
        File includeFile = this.getIncludeFile(connectionName, sourcePath, includePath);
        if (includeFile.exists()) {
            try {
                String xml = Files.readString(includeFile.toPath(), Charset.defaultCharset());
                XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
                xstream.setClassLoader(this.getClass().getClassLoader());
                IncludeData include = (IncludeData)xstream.fromXML(xml);
                this.addIncludeData(sourcePath, include);
            }
            catch (Exception e) {
                String message = MessageFormat.format("Could not load included data from {0}.", includePath);
                this.logger.error(message, (Throwable)e);
                Notifier.warn((String)"Copy Members not found", (String)message);
            }
        }
    }

    @Override
    public void setIncludeDataExpired(String connectionName, String sourcePath, String includePath) {
        this.logger.debug((Option)miworkplace.ui.editor.debug.Option.editors, "Expire include " + includePath);
        this.includeMap.remove(new IncludeMapKey(connectionName, sourcePath, includePath));
        File includeFile = this.getIncludeFile(connectionName, sourcePath, includePath);
        includeFile.delete();
    }

    @Override
    public void addIncludeData(String sourcePath, IncludeData include) {
        this.logger.debug((Option)miworkplace.ui.editor.debug.Option.editors, "Add include " + include.getQualifiedIncludePath());
        if (include.getData() == null) {
            return;
        }
        try {
            if (include.getAst() == null) {
                if (RpgSyntaxTypeChecker.isFullFree((String)include.getData())) {
                    include.setAst(new Parser().parse(include.getData()));
                } else {
                    include.setAst(ASTBuilder.buildAST((String)include.getData()));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Could not build AST for " + include.getQualifiedIncludePath(), (Throwable)e);
        }
        this.includeMap.put(new IncludeMapKey(include.getConnectionName(), sourcePath, include.getUnqualifiedIncludePath()), include);
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put("connection", include.getConnectionName());
        eventData.put("path", include.getUnqualifiedIncludePath());
        eventData.put("qualifiedPath", include.getQualifiedIncludePath());
        eventData.put("sourcePath", sourcePath);
        this.eventAdmin.sendEvent(new Event("miworkplace/ui/editor/include/added", eventData));
        File includeFile = this.getIncludeFile(include.getConnectionName(), sourcePath, include.getUnqualifiedIncludePath());
        includeFile.getParentFile().mkdirs();
        try {
            FileWriter out = new FileWriter(includeFile);
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.setClassLoader(this.getClass().getClassLoader());
            xstream.toXML((Object)include, (Writer)out);
        }
        catch (Exception e) {
            this.logger.error("Could not persist include data to " + includeFile.getAbsolutePath(), (Throwable)e);
        }
    }

    class IncludeMapKey {
        final String connectionName;
        final String sourcePath;
        final String includePath;

        public IncludeMapKey(String connectionName, String sourcePath, String includePath) {
            this.connectionName = connectionName;
            this.sourcePath = sourcePath;
            this.includePath = includePath;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.connectionName == null ? 0 : this.connectionName.hashCode());
            result = 31 * result + (this.includePath == null ? 0 : this.includePath.hashCode());
            result = 31 * result + (this.sourcePath == null ? 0 : this.sourcePath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IncludeMapKey other = (IncludeMapKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.connectionName == null ? other.connectionName != null : !this.connectionName.equals(other.connectionName)) {
                return false;
            }
            if (this.includePath == null ? other.includePath != null : !this.includePath.equals(other.includePath)) {
                return false;
            }
            return !(this.sourcePath == null ? other.sourcePath != null : !this.sourcePath.equals(other.sourcePath));
        }

        public String toString() {
            return this.includePath;
        }

        private IncludeService getOuterType() {
            return IncludeService.this;
        }
    }
}

