/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.iledocs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import miworkplace.ast.rpg.AST;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.text.RpgSyntaxTypeChecker;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.iledocs.cl.ClIledocsBuilder;
import miworkplace.iledocs.model.Program;
import miworkplace.iledocs.rpg.FreeRpgIledocsBuilder;
import miworkplace.iledocs.rpg.RpgIledocsBuilder;
import miworkplace.ui.editor.ILEDocsProvider;
import miworkplace.ui.editor.include.IIncludeService;
import miworkplace.ui.editor.include.IncludeData;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Include;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class InMemoryIledocsBuilder
implements EventHandler {
    private ILEDocsProvider iledocsProvider;
    private IIncludeService includeService;
    private IConnectionManager connectionManager;
    private Debug logger = Debug.getInstance();
    private IWorkspaceStore workspaceStore;

    public void bindWorkspaceStore(IWorkspaceStore workspaceStore) {
        this.workspaceStore = workspaceStore;
    }

    public void unbindWorkspaceStore(IWorkspaceStore workspaceStore) {
        this.workspaceStore = null;
    }

    public void bindIledocsProvider(ILEDocsProvider iledocsProvider) {
        this.iledocsProvider = iledocsProvider;
    }

    public void unbindIledocsProvider(ILEDocsProvider iledocsProvider) {
        this.iledocsProvider = null;
    }

    public void bindIncludeService(IIncludeService includeService) {
        this.includeService = includeService;
    }

    public void unbindIncludeService(IIncludeService includeService) {
        this.includeService = null;
    }

    public void bindConnectionManager(IConnectionManager connManager) {
        this.connectionManager = connManager;
    }

    public void unbindConnectionManager(IConnectionManager connManager) {
        this.connectionManager = null;
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/ui/editor/include/added")) {
            IncludeData includeData;
            IConnection connection = this.connectionManager.get(event.getProperty("connection").toString());
            Program iledocsModel = this.buildIledocsModelFromIncludeData(connection, includeData = this.includeService.getIncludeData(event.getProperty("connection").toString(), event.getProperty("sourcePath").toString(), event.getProperty("path").toString()));
            if (iledocsModel != null) {
                this.logger.debug((Option)miworkplace.ui.editor.debug.Option.editors, "Added ILEDocs for " + includeData.getQualifiedIncludePath());
                this.iledocsProvider.add(connection.getName(), includeData.getQualifiedIncludePath(), iledocsModel);
            }
        } else if (event.getTopic().equals("miworkplace/editor/reconciled")) {
            String inputUri = event.getProperty("inputUri").toString();
            String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
            String path = EditorInputUriUtil.getMemberPath((String)inputUri);
            String content = "";
            if (event.getProperty("content") == null) {
                this.logger.debug((Option)miworkplace.ui.editor.debug.Option.editors, MessageFormat.format("No content supplied for reconcile event. Class {0}", InMemoryIledocsBuilder.class.getName()));
            } else {
                content = event.getProperty("content").toString();
            }
            IConnection connection = this.connectionManager.get(connectionName);
            IRemoteObject sourceFile = this.workspaceStore.get(connection, path);
            this.buildIledocsFromEditorContent(event.getProperty("org.eclipse.e4.data"), connection, sourceFile, content);
            this.buildIledocsFromIncludes(event.getProperty("org.eclipse.e4.data"), connection, sourceFile);
        }
    }

    private void buildIledocsFromEditorContent(Object ast, IConnection connection, IRemoteObject sourceFile, String content) {
        Program iledocsModel = null;
        try {
            if (ast instanceof AST) {
                RpgIledocsBuilder iledocsBuilder = new RpgIledocsBuilder();
                iledocsModel = iledocsBuilder.build(connection, content);
            } else if (ast instanceof Ast) {
                FreeRpgIledocsBuilder iledocsBuilder = new FreeRpgIledocsBuilder();
                iledocsModel = iledocsBuilder.build(connection, content);
            } else if (ast instanceof miworkplace.ui.editor.cl.ast.Ast) {
                ClIledocsBuilder iledocsBuilder = new ClIledocsBuilder();
                iledocsModel = iledocsBuilder.build(connection, content);
            }
            if (iledocsModel != null) {
                this.logger.debug((Option)miworkplace.ui.editor.debug.Option.editors, "Added ILEDocs for " + sourceFile.getPath());
                this.iledocsProvider.add(connection.getName(), sourceFile.getPath(), iledocsModel);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not build ILEDocs for " + sourceFile.getPath(), (Throwable)e);
        }
    }

    protected void buildIledocsFromIncludes(Object ast, IConnection connection, IRemoteObject sourceFile) {
        List<String> includePaths = this.getIncludePaths(ast);
        for (String includePath : includePaths) {
            Program iledocsModel;
            IncludeData includeData = this.includeService.getIncludeData(connection.getName(), sourceFile.getPath(), includePath);
            if (includeData == null || (iledocsModel = this.buildIledocsModelFromIncludeData(connection, includeData)) == null) continue;
            this.logger.debug((Option)miworkplace.ui.editor.debug.Option.editors, "Added ILEDocs for " + includeData.getQualifiedIncludePath());
            this.iledocsProvider.add(connection.getName(), includeData.getQualifiedIncludePath(), iledocsModel);
        }
    }

    private List<String> getIncludePaths(Object ast) {
        ArrayList<String> includePaths;
        block3: {
            block2: {
                miworkplace.ast.rpg.token.Include[] includes;
                includePaths = new ArrayList<String>();
                if (!(ast instanceof AST)) break block2;
                miworkplace.ast.rpg.token.Include[] includeArray = includes = ((AST)ast).getIncludes();
                int n = includes.length;
                int n2 = 0;
                while (n2 < n) {
                    miworkplace.ast.rpg.token.Include include = includeArray[n2];
                    includePaths.add(StringUtils.strip((String)include.getIncludedFile(), (String)"'"));
                    ++n2;
                }
                break block3;
            }
            if (!(ast instanceof Ast)) break block3;
            List includes = ((Ast)ast).listIncludes();
            for (Include include : includes) {
                includePaths.add(include.getFileUnquoted());
            }
        }
        return includePaths;
    }

    private Program buildIledocsModelFromIncludeData(IConnection connection, IncludeData includeData) {
        Program iledocsModel = null;
        try {
            if (includeData.getType().equals((Object)IncludeData.Type.Rpg)) {
                if (RpgSyntaxTypeChecker.isFullFree((String)includeData.getData())) {
                    FreeRpgIledocsBuilder iledocsBuilder = new FreeRpgIledocsBuilder();
                    iledocsModel = iledocsBuilder.build(connection, includeData.getData());
                } else {
                    RpgIledocsBuilder iledocsBuilder = new RpgIledocsBuilder();
                    iledocsModel = iledocsBuilder.build(connection, includeData.getData());
                }
            } else if (includeData.getType().equals((Object)IncludeData.Type.Cl)) {
                ClIledocsBuilder iledocsBuilder = new ClIledocsBuilder();
                iledocsModel = iledocsBuilder.build(connection, includeData.getData());
            }
        }
        catch (Exception e) {
            this.logger.error("Could not build ILEdocs for " + includeData.getQualifiedIncludePath(), (Throwable)e);
        }
        return iledocsModel;
    }
}

