/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.ui.api.IEditor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.adapter.Adapter;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.ITextOperationTarget;

public class UndoHandler {
    @Inject
    private Adapter _adapter;
    @Inject
    private IEventBroker eventBroker;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        ITextOperationTarget opTarget = (ITextOperationTarget)this._adapter.adapt(part.getObject(), ITextOperationTarget.class);
        opTarget.doOperation(1);
        if (part.getObject() instanceof IEditor) {
            IEditor editor = (IEditor)part.getObject();
            this.eventBroker.send("miworkplace/editor/undo", (Object)editor.getInputUri());
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        ITextOperationTarget opTarget = (ITextOperationTarget)this._adapter.adapt(part.getObject(), ITextOperationTarget.class);
        if (opTarget == null) {
            return false;
        }
        boolean canDoOperation = opTarget.canDoOperation(1);
        return canDoOperation;
    }
}

